/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.exception.PythonScriptRunnerMissingException;
import com.altair.ai.pel.python.script.PythonScriptRunner;
import com.altair.ai.pel.python.script.ScriptRunnerCMDWithLocalFileTransfer;
import com.altair.ai.pel.python.script.ScriptRunnerWebSocketWithLocalFileTransfer;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public enum PythonScriptRunnerFactory {
    INSTANCE;

    private final Map<CommunicationMode, Map<DataExchangeMode, Supplier<PythonScriptRunner>>> runners = new HashMap<CommunicationMode, Map<DataExchangeMode, Supplier<PythonScriptRunner>>>();

    private PythonScriptRunnerFactory() {
        this.registerRunner(CommunicationMode.CMD_V1, DataExchangeMode.FILE_SYSTEM, ScriptRunnerCMDWithLocalFileTransfer::new);
        this.registerRunner(CommunicationMode.WEB_SOCKET_V1, DataExchangeMode.FILE_SYSTEM, ScriptRunnerWebSocketWithLocalFileTransfer::new);
    }

    public PythonScriptRunner createNewRunner(CommunicationMode communicationMode, DataExchangeMode dataExchangeMode) throws PythonScriptRunnerMissingException {
        Map<DataExchangeMode, Supplier<PythonScriptRunner>> dataExchangeModeSupplierMap = this.runners.get((Object)communicationMode);
        if (dataExchangeModeSupplierMap == null) {
            throw new PythonScriptRunnerMissingException(communicationMode, dataExchangeMode);
        }
        Supplier<PythonScriptRunner> scriptRunnerSupplier = dataExchangeModeSupplierMap.get((Object)dataExchangeMode);
        if (scriptRunnerSupplier == null) {
            throw new PythonScriptRunnerMissingException(communicationMode, dataExchangeMode);
        }
        return scriptRunnerSupplier.get();
    }

    private void registerRunner(CommunicationMode mode, DataExchangeMode dataExchangeMode, Supplier<PythonScriptRunner> runner) {
        this.runners.computeIfAbsent((CommunicationMode)((Object)ValidationUtilV2.requireNonNull((Object)((Object)mode), (String)"mode")), cMode -> new HashMap()).putIfAbsent(dataExchangeMode, (Supplier)ValidationUtilV2.requireNonNull(runner, (String)"runner"));
    }
}

