/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.result.PythonScriptResult;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class PythonScriptTask {
    protected static final int STATE_READY = 0;
    protected static final int STATE_SUCCESS = 3;
    protected static final int STATE_ERROR = 4;
    protected static final int STATE_EXCEPTION = -1;
    protected Runnable cleanupRunnable;
    private final PythonBaseScript script;
    private volatile long runtimeInMs = -1L;
    private volatile int statusCode = 0;
    private volatile String errorMsg = null;
    private final AtomicReference<Exception> ex = new AtomicReference<Object>(null);
    private volatile int state;
    private final AtomicBoolean futureTaskStarted = new AtomicBoolean(false);
    private final CompletableFuture<PythonScriptResult> completableFuture;

    protected PythonScriptTask(PythonBaseScript script) {
        this.script = script;
        this.state = 0;
        this.completableFuture = new CompletableFuture();
    }

    public PythonBaseScript getScript() {
        return this.script;
    }

    public CompletableFuture<PythonScriptResult> getCompletableFuture() {
        return this.completableFuture;
    }

    public boolean markSuccessful(long runtimeInMs) {
        return this.setState(3, () -> {
            this.runtimeInMs = runtimeInMs;
        });
    }

    public boolean markError(int statusCode, long runtimeInMs) {
        return this.setState(4, () -> {
            this.statusCode = statusCode;
            this.runtimeInMs = runtimeInMs;
        });
    }

    public boolean markError(int statusCode, long runtimeInMs, String errorMsg) {
        return this.setState(4, () -> {
            this.statusCode = statusCode;
            this.runtimeInMs = runtimeInMs;
            this.errorMsg = errorMsg;
        });
    }

    public boolean markException(Exception ex) {
        ValidationUtilV2.requireNonNull((Object)ex, (String)"ex");
        return this.setState(-1, () -> this.ex.set(ex));
    }

    public boolean isSuccess() {
        return this.getState() == 3;
    }

    public boolean isError() {
        return this.getState() == 4;
    }

    public boolean isException() {
        return this.getState() == -1;
    }

    public long getRuntimeInMs() {
        int curState = this.getState();
        if (curState != 3 && curState != 4) {
            throw new IllegalStateException(String.format("Cannot get runtime in ms because state was %d", curState));
        }
        return this.runtimeInMs;
    }

    public int getStatusCode() {
        int curState = this.getState();
        if (curState != 3 && curState != 4) {
            throw new IllegalStateException(String.format("Cannot get status code because state was %d", curState));
        }
        return this.statusCode;
    }

    public Exception getException() {
        int curState = this.getState();
        if (curState != -1) {
            throw new IllegalStateException(String.format("Cannot get exception because state was %d", curState));
        }
        return this.ex.get();
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public void completeScriptTaskAsync() {
        if (this.futureTaskStarted.compareAndSet(false, true)) {
            Thread resultComputation = new Thread(() -> {
                try {
                    this.getCompletableFuture().complete(this.getFutureTask().call());
                }
                catch (Exception e) {
                    this.getCompletableFuture().completeExceptionally(e);
                }
            });
            resultComputation.setDaemon(true);
            resultComputation.setName("python-script-task-finalizer");
            resultComputation.start();
        }
    }

    protected abstract Callable<PythonScriptResult> getFutureTask();

    void setCleanupRunnable(Runnable cleanupRunnable) {
        if (this.cleanupRunnable == null) {
            this.cleanupRunnable = (Runnable)ValidationUtilV2.requireNonNull((Object)cleanupRunnable, (String)"cleanupRunnable");
        }
    }

    protected synchronized int getState() {
        return this.state;
    }

    private synchronized boolean setState(int newState, Runnable stateInitializer) {
        if (this.state == 0) {
            stateInitializer.run();
            this.state = newState;
            return true;
        }
        return false;
    }
}

