/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.python.exception.PythonScriptProcessingException;
import com.altair.ai.pel.python.exception.PythonScriptStoppedException;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.PythonScriptTask;
import com.altair.ai.pel.python.script.result.PythonScriptResult;
import com.altair.ai.pel.python.script.result.PythonScriptResultLocal;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

class PythonScriptTaskLocalFiles
extends PythonScriptTask {
    private final Callable<PythonScriptResult> futureTask;
    private final Consumer<String> stdOutConsumer;
    private final Consumer<String> stdErrConsumer;
    private String lastErrorLine;
    private boolean loggedErrorLine;

    PythonScriptTaskLocalFiles(PythonBaseScript script) {
        super(script);
        this.stdOutConsumer = script.getStdOutConsumer();
        this.stdErrConsumer = script.getStdErrConsumer();
        this.futureTask = () -> {
            if (this.isSuccess() || this.isError()) {
                return new PythonScriptResultLocal(script.getId(), this.getRuntimeInMs(), this.getStatusCode(), this.isSuccess(), this.cleanupRunnable, this.getErrorMessage());
            }
            if (this.isException()) {
                new Thread(null, this.cleanupRunnable, "python_workdir_cleanup").start();
                Exception exception = this.getException();
                if (exception instanceof PythonScriptStoppedException) {
                    throw exception;
                }
                throw new PythonScriptProcessingException(exception);
            }
            throw new PythonScriptProcessingException(new IllegalStateException("Python script completion task was running before end state was reached!"));
        };
    }

    @Override
    public String getErrorMessage() {
        String errorMsg = super.getErrorMessage();
        return errorMsg != null ? errorMsg : this.lastErrorLine;
    }

    @Override
    protected Callable<PythonScriptResult> getFutureTask() {
        return this.futureTask;
    }

    void addResultLine(String line) {
        if (this.stdOutConsumer != null) {
            this.stdOutConsumer.accept((String)ValidationUtilV2.requireNonNull((Object)line, (String)"line"));
        }
    }

    void addErrorLine(String line) {
        if (this.stdErrConsumer != null) {
            this.stdErrConsumer.accept((String)ValidationUtilV2.requireNonNull((Object)line, (String)"line"));
            if (!this.loggedErrorLine) {
                this.lastErrorLine = line;
            }
            if (line.startsWith("ERROR:")) {
                this.loggedErrorLine = true;
            }
        }
    }
}

