/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.python.script.PythonStreamProvider;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;

public final class PythonSourceProvider
implements PythonStreamProvider {
    private static final Set<String> VALID_SUFFIXES = new HashSet<String>();
    private final String sourceName;
    private final Callable<InputStream> sourceSupplier;

    public PythonSourceProvider(String sourceName, Callable<InputStream> sourceSupplier) {
        ValidationUtilV2.requireNonEmptyString((String)sourceName, (String)"sourceName");
        if (!VALID_SUFFIXES.contains(FileUtils.getSuffixFromFilename((String)sourceName.toLowerCase(Locale.ENGLISH)))) {
            throw new IllegalArgumentException("sourceName does not have supported suffix: " + sourceName);
        }
        this.sourceName = sourceName;
        this.sourceSupplier = (Callable)ValidationUtilV2.requireNonNull(sourceSupplier, (String)"sourceSupplier");
    }

    @Override
    public String getContentName() {
        return this.sourceName;
    }

    @Override
    public Callable<InputStream> getContentSupplier() {
        return this.sourceSupplier;
    }

    public String toString() {
        return "PythonSourceProvider{sourceName='" + this.sourceName + "'}";
    }

    static {
        VALID_SUFFIXES.add("py");
        VALID_SUFFIXES.add("pyc");
        VALID_SUFFIXES.add("zip");
    }
}

