/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.exception.PythonScriptStoppedException;
import com.altair.ai.pel.python.script.AbstractScriptRunnerWithLocalFileTransfer;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.PythonScriptTask;
import com.altair.ai.pel.python.script.PythonScriptTaskLocalFiles;
import com.altair.ai.pel.python.script.PythonStreamProvider;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.python.util.PythonRunnerTools;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;

class ScriptRunnerCMDWithLocalFileTransfer
extends AbstractScriptRunnerWithLocalFileTransfer {
    private final AtomicReference<Callable<Void>> terminator = new AtomicReference<Callable<Void>>(() -> null);
    private PythonScriptTask task;

    ScriptRunnerCMDWithLocalFileTransfer() {
    }

    @Override
    public Callable<Void> createRunner(PythonDistributionReference distRef, PythonBaseScript script) {
        PythonScriptTaskLocalFiles localTask = new PythonScriptTaskLocalFiles(script);
        this.task = localTask;
        return () -> {
            AtomicInteger exitValue = new AtomicInteger(0);
            AtomicLong startTime = new AtomicLong();
            AtomicLong endTime = new AtomicLong();
            List<PythonStreamProvider> sourceProviders = script.createSourceProviders(this.inputsDir);
            PythonRunnerTools.writeContentToDisk(sourceProviders, this.workingDir);
            Path mainSourceFile = this.workingDir.resolve(sourceProviders.get(0).getContentName());
            PythonRunnerTools.writeContentToDisk(script.createInputProviders(this.inputsDir), this.inputsDir);
            startTime.set(System.currentTimeMillis());
            this.task.setCleanupRunnable(this::cleanupRun);
            List<String> inputArguments = script.createArguments(this.workingDir);
            List<String> commands = PythonDistributionTools.createPythonInvocationCommands(distRef);
            commands.add(mainSourceFile.toString());
            commands.addAll(inputArguments);
            Path shellScript = PythonDistributionTools.formatPythonInvocationCommandsAndWriteToShellScript(commands, this.workingDir);
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(this.workingDir).addEnv("CRYPTOGRAPHY_OPENSSL_NO_LEGACY", "True").addEnv("CONDA_ENVS_PATH", PythonSDKSettings.getMiniforgeEnvDir().toAbsolutePath().toString()).addEnvUnlessOperatingSystem("HOME", () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(localTask::addResultLine).errorConsumer(localTask::addErrorLine).id(String.format("Python script %s", script.getId())).command(shellScript.toAbsolutePath().toString()).startProcess();
            this.terminator.set(() -> {
                this.task.markException(new PythonScriptStoppedException());
                result.killExternalProcessNow();
                return null;
            });
            result.getProcessFuture().thenApply(process -> {
                endTime.set(System.currentTimeMillis());
                exitValue.set(process.exitValue());
                long runtime = endTime.get() - startTime.get();
                if (exitValue.get() == 0) {
                    AccessController.doPrivileged(() -> {
                        this.setResultOutputs(script);
                        this.task.markSuccessful(runtime);
                        return null;
                    });
                } else if (!this.task.isException()) {
                    this.task.markError(exitValue.get(), runtime);
                }
                if (!this.task.isException()) {
                    LogService.getRoot().log(Level.FINE, () -> String.format("Python: Ran Python script %s via distribution %s in %d ms.", script.getId(), distRef.getDist().toDistributionString(), endTime.get() - startTime.get()));
                }
                this.task.completeScriptTaskAsync();
                return null;
            });
            return null;
        };
    }

    @Override
    public Supplier<Callable<Void>> createStopCallback() {
        return this.terminator::get;
    }

    @Override
    public PythonScriptTask getTask() {
        return this.task;
    }
}

