/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.exception.PythonScriptStoppedException;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.PythonOperatorScript;
import com.altair.ai.pel.python.script.PythonScriptTask;
import com.altair.ai.pel.python.util.PythonRunnerTools;
import com.altair.ai.pel.server.local.ServerResource;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rapidminer.tools.LogService;
import java.net.http.WebSocket;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;

public class WebSocketListenerImpl
implements WebSocket.Listener {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final float PATIENCE_SECONDS = 0.5f;
    private static final int INITIALIZING = 0;
    private static final int RUNNING = 1;
    private static final int SUCCESS = 2;
    private static final int CANCELED = 3;
    private static final int ERROR = 4;
    private static final String LOG_PATTERN = "%s@%s: %s";
    private static final String ERR_PATTERN = "%s - %s@%s(%s#%s): %s";
    private static final String AT_PATTERN = "\tat %s@%s(%s#%s)";
    private String message = "";
    private volatile String executionID = null;
    private final String startMessage;
    private final PythonScriptTask task;
    private final PythonBaseScript script;
    private final String distString;
    private final ServerResource serverResource;
    private final Consumer<PythonBaseScript> setResultOutputs;
    private final long startTime;
    private final AtomicInteger state = new AtomicInteger(0);
    private final String idPrefix;

    WebSocketListenerImpl(PythonScriptTask task, PythonBaseScript script, PythonDistributionReference distRef, ServerResource serverResource, String startMessage, Consumer<PythonBaseScript> setResultOutputs, long startTime) {
        this.task = task;
        this.script = script;
        this.distString = distRef.getDist().toDistributionString();
        this.serverResource = serverResource;
        this.startMessage = startMessage;
        this.setResultOutputs = setResultOutputs;
        this.startTime = startTime;
        this.idPrefix = "<script:" + script.getId() + "> ";
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.logWithID(Level.FINER, "Web socket open. Sending start message: " + this.startMessage);
        webSocket.sendText(this.startMessage, true);
        webSocket.request(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        if (data == null) {
            this.logWithID(Level.WARNING, "message from server is null, ignoring");
        } else {
            this.message = this.message + data;
        }
        if (last) {
            this.logWithID(Level.FINER, "received message: " + this.message);
            try {
                response = (JsonNode)WebSocketListenerImpl.MAPPER.readValue(this.message, JsonNode.class);
                var6_7 = type = response.path("type").textValue();
                var7_8 = -1;
                switch (var6_7.hashCode()) {
                    case -1179202463: {
                        if (!var6_7.equals("STARTED")) break;
                        var7_8 = 0;
                        break;
                    }
                    case 108966002: {
                        if (!var6_7.equals("FINISHED")) break;
                        var7_8 = 1;
                        break;
                    }
                    case -1166336595: {
                        if (!var6_7.equals("STOPPED")) break;
                        var7_8 = 2;
                        break;
                    }
                    case 2066319421: {
                        if (!var6_7.equals("FAILED")) break;
                        var7_8 = 3;
                        break;
                    }
                    case 66247144: {
                        if (!var6_7.equals("ERROR")) break;
                        var7_8 = 4;
                        break;
                    }
                    case 432970832: {
                        if (!var6_7.equals("OPERATOR_COMPLETED")) break;
                        var7_8 = 5;
                        break;
                    }
                    case 75556: {
                        if (!var6_7.equals("LOG")) break;
                        var7_8 = 6;
                    }
                }
                switch (var7_8) {
                    case 0: {
                        this.logWithID(Level.FINER, "script execution started");
                        this.executionID = response.path("execution_id").textValue();
                        if (this.state.compareAndSet(0, 1) || this.state.get() != 3) break;
                        this.sendStopMessage(webSocket);
                        ** break;
lbl46:
                        // 1 sources

                    }
                    case 1: {
                        if (this.state.compareAndSet(1, 2)) {
                            this.handleSuccess();
                            webSocket.sendClose(1000, "Python script execution success");
                            ** break;
lbl53:
                            // 1 sources

                        }
                        if (this.state.get() != 3) break;
                        webSocket.sendClose(1000, "Studio process canceled");
                        ** break;
lbl58:
                        // 1 sources

                    }
                    case 2: {
                        this.logWithID(Level.FINER, "script execution canceled");
                        webSocket.sendClose(1000, "Studio process canceled");
                        ** break;
lbl64:
                        // 1 sources

                    }
                    case 3: 
                    case 4: {
                        if (this.state.compareAndSet(0, 4) || this.state.compareAndSet(1, 4)) {
                            this.handleError(response);
                            webSocket.sendClose(1000, "Python script execution failed");
                            ** break;
lbl71:
                            // 1 sources

                        }
                        if (this.state.get() == 3) {
                            webSocket.sendClose(1000, "Studio process stopped");
                            ** break;
lbl76:
                            // 1 sources

                        }
                        this.logWithID(Level.FINER, "server reported script error: " + response.path("message").textValue());
                        ** break;
lbl79:
                        // 1 sources

                    }
                    case 5: {
                        this.logWithID(Level.FINER, "operator completed");
                        if (!(this.script instanceof PythonOperatorScript)) break;
                        ((PythonOperatorScript)this.script).progressCallback();
                        ** break;
lbl85:
                        // 1 sources

                    }
                    case 6: {
                        this.handleLog(response);
                        ** break;
lbl89:
                        // 1 sources

                    }
                    default: {
                        this.logWithID(Level.WARNING, "received unknown message type: " + type);
                    }
                }
            }
            catch (JsonProcessingException e) {
                this.logWithID(Level.WARNING, "parsing message from server failed: " + this.message);
            }
            finally {
                this.message = "";
            }
        } else {
            this.logWithID(Level.FINER, "received partial message, waiting for remainder");
        }
        webSocket.request(1L);
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        this.state.set(4);
        this.logWithID(Level.WARNING, "server reported web socket error: " + error.getMessage());
        this.task.markException(PythonRunnerTools.throwableToException(error));
        this.serverResource.close();
        this.task.completeScriptTaskAsync();
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.logWithID(Level.FINER, "web socket has been closed with status code " + statusCode + ". Reason: " + reason);
        this.serverResource.close();
        this.task.completeScriptTaskAsync();
        return null;
    }

    public void stop(WebSocket webSocket) {
        if (this.state.compareAndSet(0, 3)) {
            this.task.markException(new PythonScriptStoppedException());
        } else if (this.state.compareAndSet(1, 3)) {
            this.task.markException(new PythonScriptStoppedException());
            this.sendStopMessage(webSocket);
        }
    }

    private void sendStopMessage(WebSocket webSocket) {
        String stopMessage = "{\"type\": \"STOP\",\"data\": {\"execution_id\": \"" + this.executionID + "\",\"patience\": \"0.5\"}}";
        this.logWithID(Level.FINER, "sending stop message: " + stopMessage);
        webSocket.sendText(stopMessage, true);
    }

    private void handleSuccess() {
        long runtime = System.currentTimeMillis() - this.startTime;
        AccessController.doPrivileged(() -> {
            if (this.task.markSuccessful(runtime)) {
                this.setResultOutputs.accept(this.script);
            }
            return null;
        });
        LogService.getRoot().log(Level.FINE, () -> String.format("Python: Ran Python script %s via distribution %s in %d ms.", this.script.getId(), this.distString, runtime));
    }

    private void handleError(JsonNode response) {
        long runtime = System.currentTimeMillis() - this.startTime;
        JsonNode data = response.path("data");
        String errorClass = data.path("classname").textValue();
        JsonNode stackTrace = data.path("stack_trace");
        ArrayList<Object> stackTraceLines = new ArrayList<Object>(stackTrace.size());
        if (!stackTrace.isEmpty()) {
            JsonNode firstTraceLine = stackTrace.get(0);
            stackTraceLines.add(String.format(ERR_PATTERN, errorClass, firstTraceLine.path("module").textValue(), firstTraceLine.path("function").textValue(), firstTraceLine.path("filename").textValue(), firstTraceLine.path("lineno").asText(), response.path("message").textValue()));
        } else {
            stackTraceLines.add(errorClass + ": " + response.path("message").textValue());
        }
        for (int i = 1; i < stackTrace.size(); ++i) {
            JsonNode traceLine = stackTrace.get(i);
            stackTraceLines.add(String.format(AT_PATTERN, traceLine.path("module").textValue(), traceLine.path("function").textValue(), traceLine.path("filename").textValue(), traceLine.path("lineno").asText()));
        }
        stackTraceLines.forEach(line -> LogService.getRoot().log(Level.SEVERE, () -> line));
        if (this.task.markError(500, runtime, (String)stackTraceLines.get(0))) {
            LogService.getRoot().log(Level.FINE, () -> String.format("Python: Ran Python script %s via distribution %s in %d ms.", this.script.getId(), this.distString, runtime));
        }
    }

    private void handleLog(JsonNode response) {
        JsonNode data = response.path("data");
        String logMessage = data.path("message").textValue();
        String module = data.path("module").textValue();
        String function = data.path("function").textValue();
        if (logMessage != null) {
            LogService.getRoot().log(WebSocketListenerImpl.convertLogLevel(data.path("level").textValue()), () -> String.format(LOG_PATTERN, module, function, logMessage));
        } else {
            this.logWithID(Level.FINE, "Log message received from server was null");
        }
    }

    private void logWithID(Level level, String message) {
        LogService.getRoot().log(level, () -> this.idPrefix + message);
    }

    private static Level convertLogLevel(String logLevel) {
        switch (logLevel) {
            case "CRITICAL": {
                return Level.SEVERE;
            }
            case "ERROR": 
            case "WARNING": {
                return Level.WARNING;
            }
            case "INFO": {
                return Level.INFO;
            }
        }
        return Level.FINE;
    }
}

