/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script.result;

import com.altair.ai.pel.python.script.result.PythonScriptResult;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.concurrent.atomic.AtomicBoolean;

public class PythonScriptResultLocal
implements PythonScriptResult {
    private final String id;
    private final int exitCode;
    private final boolean success;
    private final long runtimeInMs;
    private final Runnable cleanupRunnable;
    private final String errorMessage;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public PythonScriptResultLocal(String id, long runtimeInMs, int exitCode, boolean success, Runnable cleanupRunnable, String errorMessage) {
        this.id = ValidationUtilV2.requireNonEmptyString((String)id, (String)"id");
        this.runtimeInMs = runtimeInMs;
        this.exitCode = exitCode;
        this.success = success;
        this.cleanupRunnable = (Runnable)ValidationUtilV2.requireNonNull((Object)cleanupRunnable, (String)"cleanupRunnable");
        this.errorMessage = errorMessage;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getRuntimeInMs() {
        return this.runtimeInMs;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void closeResultAsync() {
        if (this.closed.compareAndSet(false, true)) {
            new Thread(null, this.cleanupRunnable, "python_workdir_cleanup").start();
        }
    }
}

