/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.settings;

import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.exception.PythonSDKException;
import com.altair.ai.pel.python.settings.PythonDebugMode;
import com.altair.ai.pel.util.FileTools;
import com.altair.ai.pel.util.OSTools;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

public final class PythonSDKSettings
extends Enum<PythonSDKSettings> {
    private static final AtomicBoolean UPDATING;
    private static final AtomicBoolean INITIALIZED;
    private static long pyServerIdleShutdown;
    private static int pyServerMinPort;
    private static int pyServerMaxPort;
    private static boolean airGapped;
    private static boolean miniforgeEnabled;
    private static boolean miniforgeEnvValidationDisabled;
    private static boolean pyDistRegistrationSkipped;
    private static boolean pyForceSynchronousLoading;
    private static Path resourceRootDir;
    private static Path distRootDir;
    private static Path miniforgeDir;
    private static Path miniforgeFakeHomeDir;
    private static PythonDebugMode debugMode;
    private static final /* synthetic */ PythonSDKSettings[] $VALUES;

    public static PythonSDKSettings[] values() {
        return (PythonSDKSettings[])$VALUES.clone();
    }

    public static PythonSDKSettings valueOf(String name) {
        return Enum.valueOf(PythonSDKSettings.class, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updateSettings() throws PythonSDKException {
        if (UPDATING.compareAndSet(false, true)) {
            try {
                LogService.getRoot().log(Level.FINE, "Started Python settings update");
                String debugModeString = PythonSDKSettings.getSettingAsString("pysdk.debugMode", "pysdk.debugMode", "PYSDK_DEBUG_MODE");
                debugMode = StringUtils.trimToNull((String)debugModeString) == null ? PythonDebugMode.NONE : PythonDebugMode.parseDebugMode(debugModeString);
                PythonSDKSettings.initPyServerPorts();
                PythonSDKSettings.initPyServerIdleShutdown();
                airGapped = Boolean.parseBoolean(PythonSDKSettings.getSettingAsString("pysdk.pel.airGapped", "pysdk.pel.airGapped", "PYSDK_PEL_AIR_GAPPED"));
                miniforgeEnabled = !Boolean.parseBoolean(PythonSDKSettings.getSettingAsString("pysdk.pel.disableMiniforge", "pysdk.pel.disableMiniforge", "PYSDK_PEL_DISABLE_MINIFORGE"));
                miniforgeEnvValidationDisabled = Boolean.parseBoolean(PythonSDKSettings.getSettingAsString("pysdk.pel.miniforgeDisableEnvValidation", "pysdk.pel.miniforgeDisableEnvValidation", "PYSDK_PEL_MINIFORGE_DISABLE_ENV_VALIDATION"));
                String miniforgeDirString = PythonSDKSettings.getSettingAsString("pysdk.pel.miniforgeDir", "pysdk.pel.miniforgeDir", "PYSDK_PEL_MINIFORGE_DIR");
                String miniforgeFakeHomeDirString = PythonSDKSettings.getSettingAsString("pysdk.pel.miniforgeFakeHomeDir", "pysdk.pel.miniforgeFakeHomeDir", "PYSDK_PEL_MINIFORGE_FAKE_HOME_DIR");
                pyDistRegistrationSkipped = Boolean.parseBoolean(PythonSDKSettings.getSettingAsString("pysdk.pel.skipPythonDistRegistration", "pysdk.pel.skipPythonDistRegistration", "PYSDK_PEL_SKIP_DIST_REGISTRATION"));
                pyForceSynchronousLoading = Boolean.parseBoolean(PythonSDKSettings.getSettingAsString("pysdk.pel.forceSynchronousLoading", "pysdk.pel.forceSynchronousLoading", "PYSDK_PEL_FORCE_SYNCHRONOUS_LOADING"));
                String pyDistLocationString = PythonSDKSettings.getSettingAsString("pysdk.pel.distLoc", "pysdk.pel.distLoc", "PYSDK_PEL_DIST_LOC");
                String pyResourceLocationString = PythonSDKSettings.getSettingAsString("pysdk.pel.resourceLoc", "pysdk.pel.resourceLoc", "PYSDK_PEL_RESOURCE_LOC");
                if (StringUtils.trimToNull((String)pyDistLocationString) != null) {
                    try {
                        Path distParentPath = Paths.get(pyDistLocationString, new String[0]);
                        if (!Files.exists(distParentPath, new LinkOption[0])) {
                            Files.createDirectories(distParentPath, new FileAttribute[0]);
                        }
                        if (!Files.isDirectory(distParentPath, new LinkOption[0])) {
                            throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python distribution lookup directory, path is not a directory", pyDistLocationString));
                        }
                        distRootDir = distParentPath;
                    }
                    catch (InvalidPathException e) {
                        throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python distribution parent directory, invalid path", pyDistLocationString));
                    }
                    catch (IOException e) {
                        throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python distribution parent directory, path is not a directory", pyDistLocationString));
                    }
                } else {
                    distRootDir = FileTools.getPyDistDefaultRootDirectory();
                }
                if (StringUtils.trimToNull((String)pyResourceLocationString) != null) {
                    try {
                        Path resourcePath = Paths.get(pyResourceLocationString, new String[0]);
                        if (!Files.exists(resourcePath, new LinkOption[0])) {
                            Files.createDirectories(resourcePath, new FileAttribute[0]);
                        }
                        if (!Files.isDirectory(resourcePath, new LinkOption[0])) {
                            throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python resource directory, path is not a directory", resourcePath));
                        }
                        resourceRootDir = resourcePath;
                    }
                    catch (InvalidPathException e) {
                        throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python resource directory, invalid path", pyResourceLocationString));
                    }
                    catch (IOException e) {
                        throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python resource directory, could not create directory", pyResourceLocationString));
                    }
                } else {
                    resourceRootDir = FileTools.getPyResourceDefaultRootDirectory();
                }
                if (StringUtils.trimToNull((String)miniforgeDirString) != null) {
                    try {
                        Path miniforgeDirPath = Paths.get(miniforgeDirString, new String[0]);
                        if (!Files.exists(miniforgeDirPath, new LinkOption[0])) {
                            Files.createDirectories(miniforgeDirPath, new FileAttribute[0]);
                        }
                        if (!Files.isDirectory(miniforgeDirPath, new LinkOption[0])) {
                            throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Miniforge directory, path is not a directory", miniforgeDirPath));
                        }
                        miniforgeDir = miniforgeDirPath;
                    }
                    catch (InvalidPathException e) {
                        throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Miniforge directory, invalid path", miniforgeDirString));
                    }
                    catch (IOException e) {
                        throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Miniforge directory, could not create directory", miniforgeDirString));
                    }
                } else {
                    miniforgeDir = FileTools.getMiniforgeDefaultDirectory();
                }
                if (OSTools.getOperatingSystem() != SystemInfoUtilities.OperatingSystem.WINDOWS) {
                    if (StringUtils.trimToNull((String)miniforgeFakeHomeDirString) != null) {
                        try {
                            Path miniforgeFakeHomeDirPath = Paths.get(miniforgeFakeHomeDirString, new String[0]);
                            if (!Files.exists(miniforgeFakeHomeDirPath, new LinkOption[0])) {
                                Files.createDirectories(miniforgeFakeHomeDirPath, new FileAttribute[0]);
                            }
                            if (!Files.isDirectory(miniforgeFakeHomeDirPath, new LinkOption[0])) {
                                throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Miniforge fake home directory, path is not a directory", miniforgeFakeHomeDirPath));
                            }
                            miniforgeFakeHomeDir = miniforgeFakeHomeDirPath;
                        }
                        catch (InvalidPathException e) {
                            throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Miniforge fake home directory, invalid path", miniforgeFakeHomeDirString));
                        }
                        catch (IOException e) {
                            throw new PythonSDKException(String.format("Failed to use setting/property/env-var with value '%s' to set the Miniforge fake home directory, could not create directory", miniforgeFakeHomeDirString));
                        }
                    } else {
                        miniforgeFakeHomeDir = FileTools.getMiniforgeFakeHomeDefaultDirectory();
                    }
                }
                if (airGapped) {
                    LogService.getRoot().log(Level.INFO, "Set Python distribution to air-gapped mode");
                }
                if (miniforgeEnabled) {
                    LogService.getRoot().log(Level.INFO, () -> String.format("Set Miniforge directory to %s", miniforgeDir));
                    if (OSTools.getOperatingSystem() != SystemInfoUtilities.OperatingSystem.WINDOWS) {
                        LogService.getRoot().log(Level.INFO, () -> String.format("Set Miniforge fake home directory to %s", miniforgeFakeHomeDir));
                    }
                } else {
                    LogService.getRoot().log(Level.INFO, "Disabled Python distribution Miniforge usage");
                }
                if (miniforgeEnvValidationDisabled) {
                    LogService.getRoot().log(Level.INFO, "Disabled Miniforge detailed distribution validation");
                }
                if (pyDistRegistrationSkipped) {
                    LogService.getRoot().log(Level.INFO, "Skipping Python distribution registration - Python extensions will be loaded and register their operators, but cannot run!");
                }
                if (pyForceSynchronousLoading) {
                    LogService.getRoot().log(Level.INFO, "Loading Python extensions & distributions synchronously - Plugin init might take a long time");
                }
                LogService.getRoot().log(Level.INFO, () -> String.format("Set Python resource lookup directory to %s", resourceRootDir));
                LogService.getRoot().log(Level.INFO, () -> String.format("Set Python distribution lookup directory to %s", distRootDir));
                LogService.getRoot().log(Level.INFO, () -> String.format("Set Python SDK debug mode to %s", new Object[]{debugMode}));
            }
            finally {
                LogService.getRoot().log(Level.FINE, "Finished Python settings update");
                INITIALIZED.set(true);
                UPDATING.set(false);
            }
        }
    }

    public static boolean isInitialized() {
        return INITIALIZED.get();
    }

    public static long getPythonServerIdleShutdown() {
        PythonSDKSettings.verifyInitialization();
        return pyServerIdleShutdown;
    }

    public static int getPythonServerMinPort() {
        PythonSDKSettings.verifyInitialization();
        return pyServerMinPort;
    }

    public static int getPythonServerMaxPort() {
        PythonSDKSettings.verifyInitialization();
        return pyServerMaxPort;
    }

    public static boolean isAirGapped() {
        PythonSDKSettings.verifyInitialization();
        return airGapped;
    }

    public static boolean isMiniforgeEnabled() {
        PythonSDKSettings.verifyInitialization();
        return miniforgeEnabled;
    }

    public static boolean isMiniforgeEnvValidationDisabled() {
        PythonSDKSettings.verifyInitialization();
        return miniforgeEnvValidationDisabled;
    }

    public static boolean isPyDistRegistrationSkipped() {
        PythonSDKSettings.verifyInitialization();
        return pyDistRegistrationSkipped;
    }

    public static boolean isPyForceSynchronousLoading() {
        PythonSDKSettings.verifyInitialization();
        return pyForceSynchronousLoading;
    }

    public static Path getPythonDistLookupDir() {
        PythonSDKSettings.verifyInitialization();
        return distRootDir;
    }

    public static Path getPythonArchiveLookupDir() {
        PythonSDKSettings.verifyInitialization();
        return resourceRootDir;
    }

    public static Path getMiniforgeDir() {
        PythonSDKSettings.verifyInitialization();
        return miniforgeEnabled ? miniforgeDir : Paths.get("null", new String[0]);
    }

    public static Path getMiniforgeEnvDir() {
        PythonSDKSettings.verifyInitialization();
        return miniforgeEnabled ? miniforgeDir.resolve("envs") : Paths.get("null", new String[0]);
    }

    public static Path getMiniforgeFakeHomeDir() {
        PythonSDKSettings.verifyInitialization();
        if (!miniforgeEnabled || OSTools.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            return Paths.get("null", new String[0]);
        }
        return miniforgeFakeHomeDir;
    }

    public static PythonDebugMode getDebugMode() {
        PythonSDKSettings.verifyInitialization();
        return debugMode;
    }

    public static boolean isChainingEnabled() {
        String setting = Settings.getSetting((String)"python_sdk.chain.enable");
        return setting == null || Boolean.parseBoolean(setting);
    }

    public static CommunicationMode getGlobalCommunicationModeOverride() {
        String commModeSetting = Settings.getSetting((String)"python_sdk.communication_mode.override");
        if (commModeSetting == null) {
            return null;
        }
        try {
            return CommunicationMode.valueOf(commModeSetting);
        }
        catch (IllegalArgumentException e) {
            LogService.getRoot().log(Level.WARNING, () -> "Invalid communication mode override: " + commModeSetting);
            return null;
        }
    }

    public static DataExchangeMode getGlobalDataExchangeModeOverride() {
        String dataExModeSetting = Settings.getSetting((String)"python_sdk.data_exchange_mode.override");
        if (dataExModeSetting == null) {
            return null;
        }
        try {
            return DataExchangeMode.valueOf(dataExModeSetting);
        }
        catch (IllegalArgumentException e) {
            LogService.getRoot().log(Level.WARNING, () -> "Invalid data exchange mode override: " + dataExModeSetting);
            return null;
        }
    }

    private static void verifyInitialization() throws IllegalStateException {
        if (!INITIALIZED.get()) {
            throw new IllegalStateException("Must call updateSettings() at least once!");
        }
    }

    private static void initPyServerIdleShutdown() {
        String idleShutdownString = PythonSDKSettings.getSettingAsString("pysdk.pel.server.idleShutdown", "pysdk.pel.server.idleShutdown", "PYSDK_PEL_SERVER_IDLE_SHUTDOWN");
        if (StringUtils.trimToNull((String)idleShutdownString) == null) {
            pyServerIdleShutdown = 300L;
        } else {
            try {
                pyServerIdleShutdown = Long.parseLong(idleShutdownString);
            }
            catch (NumberFormatException e) {
                LogService.getRoot().log(Level.WARNING, "Invalid python server idle shutdown in seconds: " + idleShutdownString + ". Using default.");
                pyServerIdleShutdown = 300L;
            }
        }
        LogService.getRoot().log(Level.FINE, () -> "Setting python server idle shutdown in seconds to: " + pyServerIdleShutdown);
    }

    private static void initPyServerPorts() {
        String pyServerMinPortString = PythonSDKSettings.getSettingAsString("pysdk.pel.server.minPort", "pysdk.pel.server.minPort", "PYSDK_PEL_SERVER_MIN_PORT");
        pyServerMinPort = PythonSDKSettings.portValid(pyServerMinPortString) ? Integer.parseInt(pyServerMinPortString) : 8479;
        LogService.getRoot().log(Level.FINE, () -> "Setting minimal python server port to: " + pyServerMinPort);
        String pyServerMaxPortString = PythonSDKSettings.getSettingAsString("pysdk.pel.server.maxPort", "pysdk.pel.server.maxPort", "PYSDK_PEL_SERVER_MAX_PORT");
        if (PythonSDKSettings.portValid(pyServerMaxPortString)) {
            pyServerMaxPort = Integer.parseInt(pyServerMaxPortString);
            if (pyServerMaxPort < pyServerMinPort) {
                LogService.getRoot().log(Level.WARNING, () -> "Invalid maximal python server port: " + pyServerMaxPort + ". Port must be >= minimal port " + pyServerMinPort);
                pyServerMaxPort = pyServerMinPort + 20;
            }
        } else {
            pyServerMaxPort = pyServerMinPort + 20;
        }
        LogService.getRoot().log(Level.FINE, () -> "Setting maximal python server port to: " + pyServerMaxPort);
    }

    private static boolean portValid(String portString) {
        if (StringUtils.trimToNull((String)portString) != null) {
            try {
                int port = Integer.parseInt(portString);
                if (port >= 1024) {
                    return true;
                }
                LogService.getRoot().log(Level.WARNING, () -> "Invalid python server port: " + portString + ". Port must be >= 1024. Using default.");
            }
            catch (NumberFormatException e) {
                LogService.getRoot().log(Level.WARNING, () -> "Invalid python server port: " + portString + ". Using default.");
            }
        }
        return false;
    }

    private static String getSettingAsString(String settingKey, String sysPropKey, String envVarKey) {
        String valueString = Settings.getSetting((String)"altair-library", (String)settingKey);
        if (StringUtils.trimToNull((String)valueString) == null) {
            valueString = System.getProperty(sysPropKey);
        }
        if (StringUtils.trimToNull((String)valueString) == null) {
            valueString = System.getenv(envVarKey);
        }
        return valueString;
    }

    private static /* synthetic */ PythonSDKSettings[] $values() {
        return new PythonSDKSettings[0];
    }

    static {
        $VALUES = PythonSDKSettings.$values();
        UPDATING = new AtomicBoolean(false);
        INITIALIZED = new AtomicBoolean(false);
    }
}

