/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.util;

import com.altair.ai.pel.distribution.DistributionCapability;
import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionMode;
import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.distribution.PythonDistributionStatus;
import com.altair.ai.pel.distribution.installer.archive.ArchiveExtractor;
import com.altair.ai.pel.distribution.installer.archive.ArchiveFormat;
import com.altair.ai.pel.distribution.installer.archive.ArchiveVerifier;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.util.FileTools;
import com.altair.ai.pel.util.OSTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class PythonDistributionTools
extends Enum<PythonDistributionTools> {
    private static final List<Path> DEFAULT_EXECUTABLE_NAMES_WINDOWS;
    private static final List<Path> DEFAULT_EXECUTABLE_NAMES_UNIX;
    private static final String VERSION_LATEST = "latest";
    public static final PythonDistribution OVERRIDE_DIST;
    private static final /* synthetic */ PythonDistributionTools[] $VALUES;

    public static PythonDistributionTools[] values() {
        return (PythonDistributionTools[])$VALUES.clone();
    }

    public static PythonDistributionTools valueOf(String name) {
        return Enum.valueOf(PythonDistributionTools.class, name);
    }

    public static String createPythonLocalDistributionArchiveName(PythonDistribution distribution) {
        String platform;
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                platform = "windows";
                break;
            }
            case OSX: {
                platform = "macos";
                break;
            }
            default: {
                platform = "linux";
            }
        }
        String version = distribution.getVersion();
        if (version == null || version.isEmpty()) {
            version = VERSION_LATEST;
        }
        return String.format("pydist-%s-%s-%s", distribution.getKey(), version, platform);
    }

    public static String createPythonMiniforgeDistributionOfflineInstallerArchiveName(PythonDistribution distribution, boolean suffix) {
        String version = distribution.getVersion();
        if (version == null || version.isEmpty()) {
            version = VERSION_LATEST;
        }
        Object filename = String.format("pydist-%s-%s-installer", distribution.getKey(), version);
        if (suffix) {
            filename = (String)filename + ".zip";
        }
        return filename;
    }

    public static Path createPythonMiniforgeDistributionDefinitionYmlPath(PythonDistribution distribution) {
        String version = distribution.getVersion();
        if (version == null || version.isEmpty()) {
            version = VERSION_LATEST;
        }
        return FileTools.getTempDirectory().resolve(String.format("pydist-%s-%s.yml", distribution.getKey(), version)).toAbsolutePath();
    }

    public static Path createPythonMiniforgeDistributionPipRequirementsPath(PythonDistribution distribution) {
        String version = distribution.getVersion();
        if (version == null || version.isEmpty()) {
            version = VERSION_LATEST;
        }
        return FileTools.getTempDirectory().resolve(String.format("pydist-%s-%s-requirements.txt", distribution.getKey(), version)).toAbsolutePath();
    }

    public static boolean doesDistributionArchiveExist(PythonDistribution dist) {
        String archiveName = PythonDistributionTools.createPythonLocalDistributionArchiveName(dist);
        Path lookupDir = PythonSDKSettings.getPythonArchiveLookupDir();
        return Arrays.stream(ArchiveFormat.values()).anyMatch(archiveFormat -> Files.exists(lookupDir.resolve(archiveName + "." + archiveFormat.getSuffix()), new LinkOption[0]));
    }

    public static boolean doesOfflineMiniforgeDistributionInstallerArchiveExist(PythonDistribution dist) {
        String archiveName = PythonDistributionTools.createPythonMiniforgeDistributionOfflineInstallerArchiveName(dist, true);
        Path lookupDir = PythonSDKSettings.getPythonArchiveLookupDir();
        return Files.exists(lookupDir.resolve(archiveName), new LinkOption[0]);
    }

    public static void extractDistributionArchive(PythonDistribution dist, Path target) throws IOException {
        String archiveName = PythonDistributionTools.createPythonLocalDistributionArchiveName(dist);
        LogService.getRoot().log(Level.INFO, () -> String.format("Extracting Python distribution %s...", archiveName));
        Path lookupDir = PythonSDKSettings.getPythonArchiveLookupDir();
        for (ArchiveFormat format : ArchiveFormat.values()) {
            Path archive = lookupDir.resolve(archiveName + "." + format.getSuffix());
            if (!Files.exists(archive, new LinkOption[0])) continue;
            ArchiveExtractor extractor = format.getExtractor();
            long start = System.currentTimeMillis();
            extractor.extract(archive, target);
            long duration = System.currentTimeMillis() - start;
            LogService.getRoot().log(Level.INFO, () -> "Extracted " + archive + " in " + duration + "ms.");
            return;
        }
        String suffices = Arrays.stream(ArchiveFormat.values()).map(ArchiveFormat::getSuffix).collect(Collectors.joining("|"));
        throw new IOException(String.format("Archive '%s.[%s]' not found in archive lookup folder %s", archiveName, suffices, lookupDir));
    }

    public static void extractMiniforgeDistributionOfflineInstallerArchive(PythonDistribution dist, Path target) throws IOException {
        String archiveName = PythonDistributionTools.createPythonMiniforgeDistributionOfflineInstallerArchiveName(dist, true);
        LogService.getRoot().log(Level.INFO, () -> String.format("Extracting Python Miniforge distribution offline installer %s...", archiveName));
        Path lookupDir = PythonSDKSettings.getPythonArchiveLookupDir();
        Path archive = lookupDir.resolve(archiveName);
        ArchiveExtractor extractor = ArchiveFormat.ZIP.getExtractor();
        long start = System.currentTimeMillis();
        extractor.extract(archive, target);
        long duration = System.currentTimeMillis() - start;
        LogService.getRoot().log(Level.INFO, () -> "Extracted " + archive + " in " + duration + "ms.");
    }

    public static boolean verifyDistributionArchiveContents(PythonDistribution dist, Path target, Map<String, String> hashesToCheck) throws IOException {
        String archiveName = PythonDistributionTools.createPythonLocalDistributionArchiveName(dist);
        LogService.getRoot().log(Level.INFO, () -> "Verifying Python distribution " + archiveName);
        for (ArchiveFormat format : ArchiveFormat.values()) {
            Path archive = PythonSDKSettings.getPythonArchiveLookupDir().resolve(archiveName + "." + format.getSuffix());
            if (!Files.exists(archive, new LinkOption[0])) continue;
            ArchiveVerifier verifier = format.getVerifier();
            long start = System.currentTimeMillis();
            boolean verified = verifier.verify(archive, target, hashesToCheck);
            long duration = System.currentTimeMillis() - start;
            LogService.getRoot().log(Level.INFO, () -> "Verified disk contents for " + archive + " in " + duration + "ms.");
            return verified;
        }
        String suffices = Arrays.stream(ArchiveFormat.values()).map(ArchiveFormat::getSuffix).collect(Collectors.joining("|"));
        throw new IOException("Archive '" + archiveName + ".[" + suffices + "]' not found in internal cache!");
    }

    public static Path resolveDistributionRootDir(PythonDistribution dist, PythonDistributionMode distMode) {
        ValidationUtilV2.requireNonNull((Object)dist, (String)"dist");
        switch (distMode) {
            case MINIFORGE: {
                return PythonSDKSettings.getMiniforgeEnvDir().resolve(dist.toDistributionString());
            }
            case LOCAL: {
                return PythonSDKSettings.getPythonDistLookupDir().resolve(dist.toDistributionString());
            }
        }
        LogService.getRoot().log(Level.SEVERE, "BUG: Unhandled distribution mode: " + distMode);
        return Paths.get("null", new String[0]);
    }

    public static List<Path> getDefaultExecutableRelativePaths() {
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                return DEFAULT_EXECUTABLE_NAMES_WINDOWS;
            }
        }
        return DEFAULT_EXECUTABLE_NAMES_UNIX;
    }

    public static Path formatPythonInvocationCommandsAndWriteToShellScript(List<String> commands, Path shellScriptDir) throws IOException {
        Path shellScript = FileTools.createShellScript(shellScriptDir);
        StringBuilder sb = new StringBuilder();
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                PythonDistributionTools.createWindowsCommand(commands, sb);
                break;
            }
            case OSX: {
                PythonDistributionTools.createMacOSCommand(commands, sb);
                break;
            }
            default: {
                PythonDistributionTools.createUnixCommand(commands, sb);
            }
        }
        Files.writeString(shellScript, (CharSequence)sb.toString(), new OpenOption[0]);
        return shellScript;
    }

    public static List<String> createPythonInvocationCommands(PythonDistributionReference pyDistRef) {
        String pythonExecutable;
        ValidationUtilV2.requireNonNull((Object)pyDistRef, (String)"pyDistRef");
        ArrayList<String> commands = new ArrayList<String>();
        switch (pyDistRef.getDistributionMode()) {
            case MINIFORGE: {
                commands.addAll(PythonDistributionTools.createPythonMiniforgeDistributionActivationCommands(pyDistRef.getDist().toDistributionString()));
                commands.add("&&");
                pythonExecutable = "python";
                break;
            }
            case LOCAL: {
                pythonExecutable = pyDistRef.getExecutablePath().toString();
                break;
            }
            default: {
                LogService.getRoot().log(Level.SEVERE, () -> String.format("BUG: Unexpected distribution mode: %s", new Object[]{pyDistRef.getDistributionMode()}));
                return commands;
            }
        }
        commands.add(pythonExecutable);
        commands.add("-s");
        commands.add("-E");
        return commands;
    }

    public static List<String> createPythonMiniforgeDistributionActivationCommands(String distName) {
        ArrayList<String> commands = new ArrayList<String>();
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                commands.add(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString());
                commands.add("activate");
                break;
            }
            case OSX: {
                commands.add("eval");
                commands.add(String.format("\"$('%s' 'shell.zsh' 'hook' 2> /dev/null)\"", MiniforgeHandler.INSTANCE.getMiniforgeExecutable()));
                commands.add("&&");
                commands.add("source");
                commands.add(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent().resolve("activate").toString());
                break;
            }
            default: {
                commands.add("eval");
                commands.add(String.format("\"$('%s' 'shell.bash' 'hook' 2> /dev/null)\"", MiniforgeHandler.INSTANCE.getMiniforgeExecutable()));
                commands.add("&&");
                commands.add(".");
                commands.add(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent().resolve("activate").toString());
            }
        }
        commands.add(distName);
        return commands;
    }

    public static PythonDistribution checkPythonDistributionForOverride(PythonDistribution regularDistribution) {
        ValidationUtilV2.requireNonNull((Object)regularDistribution, (String)"regularDistribution");
        PythonDistributionStatus overrideDistStatus = PythonDistributionHandler.INSTANCE.getDistributionStatus(OVERRIDE_DIST);
        if (overrideDistStatus == PythonDistributionStatus.IN_REGISTRATION || overrideDistStatus == PythonDistributionStatus.REGISTERED) {
            LogService.getRoot().log(Level.WARNING, "USING GLOBAL PYTHON DISTRIBUTION OVERRIDE!");
            return OVERRIDE_DIST;
        }
        return regularDistribution;
    }

    public static Set<CommunicationMode> getSupportedCommunicationModes(Set<DistributionCapability> capabilities) {
        ValidationUtilV2.requireNonNull(capabilities, (String)"capabilities");
        LinkedHashSet<CommunicationMode> supportedModes = new LinkedHashSet<CommunicationMode>();
        if (capabilities.containsAll(CommunicationMode.WEB_SOCKET_V1.getRequiredCapabilities())) {
            supportedModes.add(CommunicationMode.WEB_SOCKET_V1);
        }
        if (capabilities.containsAll(CommunicationMode.CMD_V1.getRequiredCapabilities())) {
            supportedModes.add(CommunicationMode.CMD_V1);
        }
        return supportedModes;
    }

    public static Set<DataExchangeMode> getSupportedDataExchangeModes(PythonDistributionReference pyDistRef) {
        ValidationUtilV2.requireNonNull((Object)pyDistRef, (String)"pyDistRef");
        Set<DistributionCapability> capabilities = pyDistRef.getSupportedCapabilities();
        HashSet<DataExchangeMode> supportedModes = new HashSet<DataExchangeMode>();
        if (capabilities.containsAll(DataExchangeMode.FILE_SYSTEM.getRequiredCapabilities())) {
            supportedModes.add(DataExchangeMode.FILE_SYSTEM);
        }
        return supportedModes;
    }

    private static void createWindowsCommand(List<String> commands, StringBuilder sb) {
        StringJoiner commandJoiner = new StringJoiner(" ");
        boolean whitespaceFound = false;
        for (String command : commands) {
            if (command.contains(" ")) {
                commandJoiner.add("\"" + command + "\"");
                whitespaceFound = true;
                continue;
            }
            commandJoiner.add(command);
        }
        sb.append("@echo off").append("\n\n");
        sb.append("cmd /c ");
        if (whitespaceFound) {
            sb.append('\"');
        }
        sb.append(commandJoiner);
        if (whitespaceFound) {
            sb.append('\"');
        }
    }

    private static void createUnixCommand(List<String> commands, StringBuilder sb) {
        StringJoiner commandJoiner = new StringJoiner(" ");
        commands.forEach(command -> {
            if (command.contains(" ") && !command.contains("$(")) {
                command = command.replace(" ", "\\ ");
            }
            commandJoiner.add((CharSequence)command);
        });
        sb.append("#!/bin/bash");
        sb.append("\n\n");
        sb.append(commandJoiner);
    }

    private static void createMacOSCommand(List<String> commands, StringBuilder sb) {
        AtomicBoolean evalUsed = new AtomicBoolean(false);
        StringJoiner commandJoiner = new StringJoiner(" ");
        commands.forEach(command -> {
            if (command.contains("$(")) {
                evalUsed.set(true);
            }
            if (command.contains(" ") && !command.contains("$(")) {
                command = command.replace(" ", "\\ ");
            }
            commandJoiner.add((CharSequence)command);
        });
        if (!evalUsed.get()) {
            sb.append("sh -c ");
            sb.append('\"').append(commandJoiner).append('\"');
        } else {
            sb.append(commandJoiner);
        }
    }

    private static /* synthetic */ PythonDistributionTools[] $values() {
        return new PythonDistributionTools[0];
    }

    static {
        $VALUES = PythonDistributionTools.$values();
        DEFAULT_EXECUTABLE_NAMES_WINDOWS = List.of(Paths.get("python.exe", new String[0]), Paths.get("python3.exe", new String[0]), Paths.get("py.exe", new String[0]));
        DEFAULT_EXECUTABLE_NAMES_UNIX = List.of(Paths.get("bin/python", new String[0]), Paths.get("bin/python3", new String[0]));
        OVERRIDE_DIST = new PythonDistribution("OVERRIDE", null);
    }
}

