/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.util;

import com.altair.ai.pel.operator.DefaultPythonInternalIOObject;
import com.altair.ai.pel.operator.PythonCollectionMetaData;
import com.altair.ai.pel.operator.PythonIOObjectMetaData;
import com.altair.ai.pel.operator.PythonInternalIOObjectMetaData;
import com.altair.ai.pel.operator.SerializablePythonIOObject;
import com.altair.ai.pel.operator.wrapper.PythonFunctionDataType;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.gui.animation.ProcessAnimationManager;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.tools.LogService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class PythonOperatorTools
extends Enum<PythonOperatorTools> {
    public static final String DATA_CLASS_NUMPY_NDARRAY = "numpy.ndarray";
    public static final String DATA_CLASS_PANDAS_DF = "pandas.core.frame.DataFrame";
    public static final String DATA_CLASS_PATH = "pathlib.Path";
    public static final String DATA_CLASS_BYTESIO = "_io.BytesIO";
    public static final String DATA_CLASS_TEXTIOWRAPPER = "_io.TextIOWrapper";
    private static final /* synthetic */ PythonOperatorTools[] $VALUES;

    public static PythonOperatorTools[] values() {
        return (PythonOperatorTools[])$VALUES.clone();
    }

    public static PythonOperatorTools valueOf(String name) {
        return Enum.valueOf(PythonOperatorTools.class, name);
    }

    public static Class<? extends IOObject> getIOObjectClassForDataClass(String dataClass, Set<String> serializableDataClasses) {
        if (serializableDataClasses == null) {
            serializableDataClasses = Collections.emptySet();
        }
        switch (dataClass) {
            case "pandas.core.frame.DataFrame": {
                return IOTable.class;
            }
            case "pathlib.Path": 
            case "_io.BytesIO": 
            case "_io.TextIOWrapper": {
                return FileObject.class;
            }
        }
        return serializableDataClasses.contains(dataClass) ? SerializablePythonIOObject.class : DefaultPythonInternalIOObject.class;
    }

    public static PythonFunctionDataType getDataTypeForDataClass(String dataClass, Set<String> serializableDataClasses) {
        if (serializableDataClasses == null) {
            serializableDataClasses = Collections.emptySet();
        }
        switch (dataClass) {
            case "pandas.core.frame.DataFrame": {
                return PythonFunctionDataType.DATAFRAME;
            }
            case "pathlib.Path": 
            case "_io.BytesIO": 
            case "_io.TextIOWrapper": {
                return PythonFunctionDataType.FILE;
            }
        }
        return serializableDataClasses.contains(dataClass) ? PythonFunctionDataType.SERIALIZABLE_OBJECT : PythonFunctionDataType.INTERNAL_OBJECT;
    }

    public static MetaData createMetaDataForDataClass(String dataClass, boolean collection, Map<String, Set<String>> serializableDataClasses) {
        Object metaData;
        switch (PythonOperatorTools.getDataTypeForDataClass(dataClass, serializableDataClasses.keySet())) {
            case DATAFRAME: {
                metaData = new TableMetaData();
                break;
            }
            case FILE: {
                metaData = new MetaData(FileObject.class);
                break;
            }
            case SERIALIZABLE_OBJECT: {
                metaData = new PythonIOObjectMetaData(dataClass, serializableDataClasses.get(dataClass));
                break;
            }
            default: {
                metaData = new PythonInternalIOObjectMetaData(dataClass);
            }
        }
        if (collection) {
            return new PythonCollectionMetaData((MetaData)metaData);
        }
        return metaData;
    }

    public static void startRunningIndicator(Operator op) {
        AccessController.doPrivileged(() -> {
            try {
                Field runningField = Operator.class.getDeclaredField("isRunning");
                runningField.setAccessible(true);
                runningField.set(op, true);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to set running state for PythonOperatorChain.", e);
            }
            return null;
        });
    }

    public static void startProgressAnimation(Operator op) {
        AccessController.doPrivileged(() -> {
            try {
                Field runningField = Operator.class.getDeclaredField("isRunning");
                runningField.setAccessible(true);
                runningField.set(op, true);
                Method addAnimationMethod = ProcessAnimationManager.INSTANCE.getClass().getDeclaredMethod("addAnimationForOperator", Operator.class);
                addAnimationMethod.setAccessible(true);
                addAnimationMethod.invoke((Object)ProcessAnimationManager.INSTANCE, op);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to set progress animation for PythonOperatorChain.", e);
            }
            return null;
        });
    }

    public static void stopProgressAnimation(Operator op) {
        AccessController.doPrivileged(() -> {
            try {
                Field runningField = Operator.class.getDeclaredField("isRunning");
                runningField.setAccessible(true);
                runningField.set(op, false);
                Method removeAnimationMethod = ProcessAnimationManager.INSTANCE.getClass().getDeclaredMethod("removeAnimationForOperator", Operator.class);
                removeAnimationMethod.setAccessible(true);
                removeAnimationMethod.invoke((Object)ProcessAnimationManager.INSTANCE, op);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to remove progress animation for PythonOperatorChain.", e);
            }
            return null;
        });
    }

    public static void completeOperator(Operator op) {
        AccessController.doPrivileged(() -> {
            try {
                Field runningField = Operator.class.getDeclaredField("isRunning");
                runningField.setAccessible(true);
                runningField.set(op, false);
                Field dirtyField = Operator.class.getDeclaredField("dirty");
                dirtyField.setAccessible(true);
                dirtyField.set(op, false);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to set check mark for operator.", e);
            }
            return null;
        });
    }

    public static String getTitleForDescription(MetaData md) {
        if (md instanceof PythonIOObjectMetaData) {
            return ((PythonIOObjectMetaData)md).getTitleForDescription();
        }
        if (md instanceof PythonInternalIOObjectMetaData) {
            return ((PythonInternalIOObjectMetaData)md).getTitleForDescription();
        }
        return RendererService.getName((Class)md.getObjectClass());
    }

    private static /* synthetic */ PythonOperatorTools[] $values() {
        return new PythonOperatorTools[0];
    }

    static {
        $VALUES = PythonOperatorTools.$values();
    }
}

