/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.util;

import com.altair.ai.pel.python.exception.PythonScriptRunnerException;
import com.altair.ai.pel.python.script.PythonStreamProvider;
import com.rapidminer.tools.IOTools;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public final class PythonRunnerTools
extends Enum<PythonRunnerTools> {
    private static final /* synthetic */ PythonRunnerTools[] $VALUES;

    public static PythonRunnerTools[] values() {
        return (PythonRunnerTools[])$VALUES.clone();
    }

    public static PythonRunnerTools valueOf(String name) {
        return Enum.valueOf(PythonRunnerTools.class, name);
    }

    public static void writeContentToDisk(List<PythonStreamProvider> contentProviders, Path dir) throws Exception {
        for (PythonStreamProvider contentProvider : contentProviders) {
            InputStream contentInput = contentProvider.getContentSupplier().call();
            try {
                if (contentInput == null) {
                    throw new NullPointerException("Content input was null for " + contentProvider.getContentName());
                }
                Path contentPath = dir.resolve(contentProvider.getContentName());
                Path normalizedAbsoluteContentPath = contentPath.normalize().toAbsolutePath();
                if (!normalizedAbsoluteContentPath.startsWith(dir.normalize().toAbsolutePath())) {
                    throw new UnsupportedOperationException(String.format("Content file %s tried to escape working directory via %s!", contentProvider.getContentName(), contentPath));
                }
                if (Files.exists(normalizedAbsoluteContentPath, new LinkOption[0])) {
                    throw new IllegalStateException(String.format("Content file %s did already exist!", contentPath));
                }
                Files.createDirectories(normalizedAbsoluteContentPath.getParent(), new FileAttribute[0]);
                Files.createFile(normalizedAbsoluteContentPath, new FileAttribute[0]);
                IOTools.copyStreamSynchronously((InputStream)contentInput, (OutputStream)Files.newOutputStream(normalizedAbsoluteContentPath, new OpenOption[0]), (boolean)true);
            }
            finally {
                if (contentInput == null) continue;
                contentInput.close();
            }
        }
    }

    public static Exception throwableToException(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new PythonScriptRunnerException(t.getMessage(), t);
    }

    private static /* synthetic */ PythonRunnerTools[] $values() {
        return new PythonRunnerTools[0];
    }

    static {
        $VALUES = PythonRunnerTools.$values();
    }
}

