/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.server.local;

import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.exception.ServerExitException;
import com.altair.ai.pel.python.exception.ServerTimeoutException;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.server.local.ServerResource;
import com.altair.ai.pel.server.local.ServerStateListener;
import com.altair.ai.pel.server.local.ServerStateManager;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.rapidminer.tools.CleanupHooks;
import com.rapidminer.tools.ConsumerWithThrowable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;

class ServerManager {
    private ExternalProcess serverProcess;
    private boolean startupLockReleased;
    private volatile boolean idleShutdown;
    private CompletableFuture<Void> cleanUpFuture;
    private final char[] credentials;
    private final String port;
    private final String id;
    private final Semaphore lock;
    private final PythonDistributionReference distRef;
    private final ServerStateManager stateManager;
    private final AtomicInteger usages;
    private final AtomicReference<TimerTask> idleShutdownTask;
    private final long idleShutdownSeconds;
    private final Function<Process, Process> releaseLock;
    private final Consumer<Process> cleanup;

    ServerManager(String id, char[] credentials, String port, PythonDistributionReference distRef, Path serverDir) {
        this.id = id;
        this.port = port;
        this.credentials = credentials;
        this.distRef = distRef;
        this.idleShutdownSeconds = PythonSDKSettings.getPythonServerIdleShutdown();
        LogService.getRoot().log(Level.FINE, () -> this.idleShutdownSeconds > 0L ? "Python server " + id + " will shut down after idling for " + this.idleShutdownSeconds + " seconds." : "Python server idle shutdown disabled for server " + id);
        this.lock = new Semaphore(0);
        this.idleShutdownTask = new AtomicReference();
        this.releaseLock = p -> {
            this.releaseStartupLock();
            return p;
        };
        this.cleanup = p -> AccessController.doPrivileged(() -> {
            LogService.getRoot().log(Level.INFO, () -> "Shutting down local Python server " + id + " on port " + port);
            ExternalProcessTools.getSubprocesses(p).stream().filter(ProcessHandle::isAlive).forEach(ProcessHandle::destroyForcibly);
            ExternalProcessTools.getSubprocesses(p).stream().filter(ProcessHandle::isAlive).map(ProcessHandle::onExit).forEach(ConsumerWithThrowable.suppress(subProcess -> subProcess.get(1000L, TimeUnit.MILLISECONDS)));
            try {
                FileUtils.deleteDirectory((File)serverDir.toFile());
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, e, () -> "Failed to remove Python server directory for server " + id);
                CleanupHooks.addCleanupHook(() -> {
                    try {
                        FileUtils.deleteDirectory((File)serverDir.toFile());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            return null;
        });
        this.stateManager = new ServerStateManager();
        this.stateManager.registerListener(new ServerStateListener(){

            @Override
            public void ready() {
                ServerManager.this.releaseStartupLock();
            }

            @Override
            public void shutdown() {
                ServerManager.this.releaseStartupLock();
            }

            @Override
            public void finished() {
                ServerManager.this.releaseStartupLock();
            }
        });
        this.usages = new AtomicInteger(0);
        this.startupLockReleased = false;
        this.idleShutdown = false;
    }

    void setServerProcess(ExternalProcess serverProcess) {
        this.serverProcess = (ExternalProcess)ValidationUtilV2.requireNonNull((Object)serverProcess, (String)"serverProcess");
        this.cleanUpFuture = ((CompletableFuture)serverProcess.getProcessFuture().thenApply(this.releaseLock)).thenAccept(this.cleanup);
    }

    char[] getCredentials() {
        return this.credentials;
    }

    String getPort() {
        return this.port;
    }

    String getId() {
        return this.id;
    }

    PythonDistributionReference getDistRef() {
        return this.distRef;
    }

    void acceptStdOut(String logLine) {
        this.stateManager.acceptStdOut(logLine);
    }

    void acceptStdErr(String logLine) {
        this.stateManager.acceptStdErr(logLine);
    }

    boolean isActive() {
        ServerResource ignored2 = this.openResource();
        try {
            boolean bl = true;
            if (ignored2 != null) {
                ignored2.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored2 != null) {
                    try {
                        ignored2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ServerExitException | ServerTimeoutException ignored2) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    ServerResource openResource() throws InterruptedException, ServerTimeoutException, ServerExitException {
        this.lock.acquire();
        try {
            if (this.idleShutdown) {
                throw new ServerTimeoutException();
            }
            if (!this.serverProcess.getProcess().isAlive() || this.stateManager.getState() != ServerStateManager.ServerState.READY) {
                throw new ServerExitException();
            }
            if (this.usages.getAndIncrement() == 0 && this.idleShutdownTask.get() != null) {
                this.idleShutdownTask.get().cancel();
            }
            ServerResource serverResource = new ServerResource(this);
            return serverResource;
        }
        finally {
            this.lock.release();
        }
    }

    void closeResource() throws InterruptedException {
        if (this.usages.decrementAndGet() == 0 && this.idleShutdownSeconds >= 0L) {
            this.lock.acquire();
            try {
                if (this.usages.get() == 0) {
                    this.idleShutdownTask.set(new TimerTask(){
                        volatile boolean canceled = false;

                        @Override
                        public void run() {
                            try {
                                ServerManager.this.lock.acquire();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                            try {
                                if (this.canceled) {
                                    return;
                                }
                                if (ServerManager.this.usages.get() == 0 && !ServerManager.this.idleShutdown) {
                                    ServerManager.this.idleShutdown = true;
                                    ServerManager.this.destroyServer();
                                }
                            }
                            finally {
                                ServerManager.this.lock.release();
                            }
                        }

                        @Override
                        public boolean cancel() {
                            this.canceled = true;
                            return super.cancel();
                        }
                    });
                    new Timer("python-server-idle-shutdown-timer", true).schedule(this.idleShutdownTask.get(), this.idleShutdownSeconds * 1000L);
                }
            }
            finally {
                this.lock.release();
            }
        }
    }

    void destroyServer() {
        AccessController.doPrivileged(() -> {
            if (Thread.currentThread().isInterrupted()) {
                ExternalProcessTools.getSubprocesses(this.serverProcess).forEach(ProcessHandle::destroyForcibly);
                ConsumerWithThrowable.suppress(ignore -> this.cleanUpFuture.get(1L, TimeUnit.MINUTES)).accept(null);
                return null;
            }
            ExternalProcessTools.getSubprocesses(this.serverProcess).forEach(ProcessHandle::destroy);
            try {
                this.serverProcess.getProcess().waitFor(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ExternalProcessTools.getSubprocesses(this.serverProcess).forEach(ProcessHandle::destroyForcibly);
            ConsumerWithThrowable.suppress(ignore -> this.cleanUpFuture.get(1L, TimeUnit.MINUTES)).accept(null);
            return null;
        });
    }

    private synchronized void releaseStartupLock() {
        if (!this.startupLockReleased) {
            this.startupLockReleased = true;
            this.lock.release();
        }
    }
}

