/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.server.local;

import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.exception.ServerExitException;
import com.altair.ai.pel.python.exception.ServerStartupException;
import com.altair.ai.pel.python.exception.ServerTimeoutException;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.PythonStreamProvider;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.python.util.PythonRunnerTools;
import com.altair.ai.pel.server.local.ServerManager;
import com.altair.ai.pel.server.local.ServerResource;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.altair.ai.pel.util.FileTools;
import com.rapidminer.RapidMiner;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ShutdownHooks;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;

public enum ServerService {
    INSTANCE;

    static final long SHUTDOWN_MILLIS = 1000L;
    private static final String BLACKLISTED_REGEX = "[\\/\\\\\\:\\<\\>\\*\\?\\\"\\|]";
    private static final String SERVER_HOST = "localhost";
    private static final Path ROOT_SERVER_DIR;
    private volatile boolean shutDownRequested = false;
    private final Semaphore shutDownLock = new Semaphore(1);
    private final Map<PythonDistributionReference, ServerManager> distToServerMap = new ConcurrentHashMap<PythonDistributionReference, ServerManager>();

    private ServerService() {
        ShutdownHooks.addShutdownHook(() -> {
            LogService.getRoot().log(Level.INFO, () -> "ServerService in ShutdownHook");
            this.shutDownRequested = true;
            this.shutdownAllServers();
        });
    }

    public long getActiveServerCount() {
        return this.distToServerMap.values().stream().filter(ServerManager::isActive).count();
    }

    public void shutdownAllServers() {
        try {
            this.shutDownLock.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.distToServerMap.values().forEach(ServerManager::destroyServer);
            return;
        }
        try {
            this.distToServerMap.values().forEach(ServerManager::destroyServer);
        }
        finally {
            this.shutDownLock.release();
        }
    }

    public ServerResource openServerResource(PythonDistributionReference distRef, PythonBaseScript script) throws Exception {
        try {
            return this.parallelOpenServerResource(distRef, script);
        }
        catch (ServerExitException | ServerTimeoutException exception) {
            return this.sequentialOpenServerResource(distRef, script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerResource parallelOpenServerResource(PythonDistributionReference distRef, PythonBaseScript script) throws Exception {
        if (this.shutDownRequested) {
            throw new InterruptedException("Shutdown requested");
        }
        ServerManager serverManager = this.distToServerMap.get(distRef);
        if (serverManager != null) {
            try {
                return serverManager.openResource();
            }
            catch (ServerExitException | ServerTimeoutException exception) {
                // empty catch block
            }
        }
        this.shutDownLock.acquire();
        try {
            if (this.shutDownRequested) {
                throw new InterruptedException("Shutdown requested");
            }
            if (serverManager == this.distToServerMap.get(distRef)) {
                serverManager = this.startServer(distRef, script);
                this.distToServerMap.put(distRef, serverManager);
            } else {
                serverManager = this.distToServerMap.get(distRef);
            }
        }
        finally {
            this.shutDownLock.release();
        }
        return serverManager.openResource();
    }

    /*
     * Exception decompiling
     */
    private ServerResource sequentialOpenServerResource(PythonDistributionReference distRef, PythonBaseScript script) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ServerManager startServer(PythonDistributionReference distRef, PythonBaseScript script) throws Exception {
        String serverID = ServerService.generateID();
        String port = ServerService.getEnginePort();
        if ("-1".equals(port)) {
            throw new ServerStartupException("Python Server could not be started: No free port.");
        }
        long serverSideIdleShutdown = PythonSDKSettings.getPythonServerIdleShutdown();
        if (serverSideIdleShutdown >= 0L) {
            serverSideIdleShutdown += 60L;
        }
        List<String> inputArguments = script.createArguments(null);
        Path serverDir = ROOT_SERVER_DIR.resolve(serverID);
        Files.createDirectories(serverDir, new FileAttribute[0]);
        List<PythonStreamProvider> sourceProviders = script.createSourceProviders(null);
        PythonRunnerTools.writeContentToDisk(sourceProviders, serverDir);
        Path mainSourceFile = serverDir.resolve(sourceProviders.get(0).getContentName());
        List<String> commands = PythonDistributionTools.createPythonInvocationCommands(distRef);
        commands.add(mainSourceFile.toString());
        commands.add("--port");
        commands.add(port);
        commands.add("--idle-timeout");
        commands.add(String.valueOf(serverSideIdleShutdown));
        commands.addAll(inputArguments);
        Path shellScript = PythonDistributionTools.formatPythonInvocationCommandsAndWriteToShellScript(commands, serverDir);
        ServerManager serverManager = new ServerManager(serverID, ServerService.findCredentials(inputArguments), port, distRef, serverDir);
        ExternalProcess serverProcess = ExternalProcessBuilder.newBuilder().workingDir(serverDir).addEnv("CRYPTOGRAPHY_OPENSSL_NO_LEGACY", "True").addEnv("CONDA_ENVS_PATH", PythonSDKSettings.getMiniforgeEnvDir().toAbsolutePath().toString()).outputConsumer(serverManager::acceptStdOut).errorConsumer(serverManager::acceptStdErr).id(String.format("Python server %s", script.getId())).command(shellScript.toAbsolutePath().toString()).startProcess();
        serverManager.setServerProcess(serverProcess);
        LogService.getRoot().log(Level.INFO, () -> "Starting local python server " + serverID + " on port " + port);
        return serverManager;
    }

    private static char[] findCredentials(List<String> commands) {
        Iterator<String> iterator = commands.iterator();
        Object pw = null;
        String client = null;
        while (iterator.hasNext()) {
            String command = iterator.next();
            if ("--pw".equals(command) && iterator.hasNext()) {
                pw = iterator.next();
                continue;
            }
            if (!"--client".equals(command) || !iterator.hasNext()) continue;
            client = iterator.next();
        }
        if (pw == null) {
            throw new IllegalArgumentException("Bug in PEL: Commands must contain password");
        }
        String credentials = client == null ? pw : client + ":" + pw;
        return ("Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8))).toCharArray();
    }

    private static String generateID() {
        return ("server_" + UUID.randomUUID()).replaceAll(BLACKLISTED_REGEX, "_");
    }

    private static String getEnginePort() {
        int startIndex;
        int rangeLength;
        int rangeStartPort = PythonSDKSettings.getPythonServerMinPort();
        int port = ServerService.findFreePort(SERVER_HOST, rangeStartPort, rangeLength = PythonSDKSettings.getPythonServerMaxPort() - rangeStartPort + 1, startIndex = Math.floorMod(RapidMiner.getLongVersion().hashCode(), rangeLength));
        if (port < 0) {
            port = rangeStartPort + startIndex;
            LogService.getRoot().log(Level.WARNING, "No free port for Python Server found in range [" + rangeStartPort + ", " + (rangeStartPort + rangeLength - 1) + "], taking " + port);
        } else {
            LogService.getRoot().log(Level.FINE, "Found free port " + port + " for Python Server");
        }
        return String.valueOf(port);
    }

    private static int findFreePort(String host, int rangeStartPort, int rangeLength, int startIndex) {
        for (int i = 0; i < rangeLength; ++i) {
            int index = (startIndex + i) % rangeLength;
            int testPort = rangeStartPort + index;
            if (ServerService.isSocketInUse(host, testPort)) continue;
            return testPort;
        }
        return -1;
    }

    private static boolean isSocketInUse(String host, int port) {
        boolean bl;
        Socket ignored = new Socket(host, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    static {
        ROOT_SERVER_DIR = FileTools.getTempDirectory();
    }
}

