/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.server.local;

import com.altair.ai.pel.operator.PythonOperatorChainTools;
import com.altair.ai.pel.server.local.ServerStateListener;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;

public class ServerStateManager {
    private static final Consumer<String> LOG_CONSUMER = s -> LogService.getRoot().log(PythonOperatorChainTools.getPythonScriptLogLevel(), "Python script: " + s);
    private static final Consumer<String> ERR_CONSUMER = s -> LogService.getRoot().log(Level.WARNING, "Python error: " + s);
    private final List<ServerStateListener> listeners = new CopyOnWriteArrayList<ServerStateListener>();
    private ServerState state = ServerState.PRE_STARTUP;

    public synchronized ServerState getState() {
        return this.state;
    }

    void registerListener(ServerStateListener listener) {
        ValidationUtilV2.requireNonNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    void acceptStdOut(String logLine) {
        LOG_CONSUMER.accept(logLine);
        this.mapLogLineToState(logLine);
    }

    void acceptStdErr(String logLine) {
        ERR_CONSUMER.accept(logLine);
        this.mapLogLineToState(logLine);
    }

    private void mapLogLineToState(String logLine) {
        if (logLine.contains("Started server process") || logLine.contains("Starting wrapper server")) {
            this.state = ServerState.STARTUP;
            this.listeners.forEach(ServerStateListener::startup);
        } else if (logLine.contains("Application startup complete") || logLine.contains("server listening on")) {
            this.state = ServerState.READY;
            this.listeners.forEach(ServerStateListener::ready);
        } else if (logLine.contains("Shutting down") || logLine.contains("server closing")) {
            this.state = ServerState.SHUTDOWN;
            this.listeners.forEach(ServerStateListener::shutdown);
        } else if (logLine.contains("Finished server process") || logLine.contains("server closed")) {
            this.state = ServerState.FINISHED;
            this.listeners.forEach(ServerStateListener::finished);
        }
    }

    public static enum ServerState {
        PRE_STARTUP,
        STARTUP,
        READY,
        SHUTDOWN,
        FINISHED;

    }
}

