/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.util;

import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;

public final class ExternalProcessBuilder {
    private final Map<String, String> env = new HashMap<String, String>();
    private String[] command = new String[0];
    private Path workingDir = null;
    private Path targetFileForOutput = null;
    private Consumer<String> outputConsumer = null;
    private Consumer<String> errorConsumer = null;
    private CountDownLatch consumerLatch = null;
    private String id = String.format("external-process-%s", UUID.randomUUID());

    private ExternalProcessBuilder() {
    }

    public ExternalProcessBuilder command(String ... command) {
        ValidationUtilV2.requireNonNull((Object)command, (String)"command");
        if (command.length == 0) {
            throw new IllegalArgumentException("command is empty");
        }
        this.command = command;
        return this;
    }

    public ExternalProcessBuilder workingDir(Path workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public ExternalProcessBuilder redirectOutputToFile(Path targetFileForOutput) {
        this.targetFileForOutput = targetFileForOutput;
        return this;
    }

    public ExternalProcessBuilder outputConsumer(Consumer<String> outputConsumer) {
        this.outputConsumer = outputConsumer;
        return this;
    }

    public ExternalProcessBuilder errorConsumer(Consumer<String> errorConsumer) {
        this.errorConsumer = errorConsumer;
        return this;
    }

    public ExternalProcessBuilder awaitOutputStreamsClosing(CountDownLatch consumerLatch) {
        this.consumerLatch = consumerLatch;
        return this;
    }

    public ExternalProcessBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ExternalProcessBuilder addEnv(String key, String value) {
        this.env.put(ValidationUtilV2.requireNonEmptyString((String)key), value);
        return this;
    }

    public ExternalProcessBuilder addEnvForOperatingSystem(String key, Supplier<String> valueSupplier, SystemInfoUtilities.OperatingSystem ... operatingSystems) {
        if (operatingSystems != null && Set.of(operatingSystems).contains(SystemInfoUtilities.getOperatingSystem())) {
            this.env.put(ValidationUtilV2.requireNonEmptyString((String)key), (String)((Supplier)ValidationUtilV2.requireNonNull(valueSupplier, (String)"valueSupplier")).get());
        }
        return this;
    }

    public ExternalProcessBuilder addEnvUnlessOperatingSystem(String key, Supplier<String> valueSupplier, SystemInfoUtilities.OperatingSystem operatingSystem) {
        if (SystemInfoUtilities.getOperatingSystem() != operatingSystem) {
            this.env.put(ValidationUtilV2.requireNonEmptyString((String)key), (String)((Supplier)ValidationUtilV2.requireNonNull(valueSupplier, (String)"valueSupplier")).get());
        }
        return this;
    }

    public ExternalProcess startProcess() throws IOException {
        if (this.command.length == 0) {
            throw new IllegalStateException("No command specified!");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.command);
        if (!this.env.isEmpty()) {
            processBuilder.environment().putAll(this.env);
        }
        if (this.workingDir != null) {
            processBuilder.directory(this.workingDir.toFile());
        }
        if (this.targetFileForOutput != null) {
            processBuilder.redirectOutput(this.targetFileForOutput.toFile());
        }
        try {
            return AccessController.doPrivileged(() -> {
                Process process = processBuilder.start();
                if (this.targetFileForOutput == null) {
                    Consumer<String> combinedOutputConsumer = s -> {
                        if (this.outputConsumer != null) {
                            this.outputConsumer.accept((String)s);
                        }
                    };
                    ExternalProcessTools.startStreamLineConsumer(process.getInputStream(), combinedOutputConsumer, this.consumerLatch, this.id + "-output");
                }
                ExternalProcessTools.startStreamLineConsumer(process.getErrorStream(), this.errorConsumer != null ? this.errorConsumer : ignore -> {}, this.consumerLatch, this.id + "-error");
                Runnable killSwitch = () -> {
                    ExternalProcessTools.getSubprocesses(process).forEach(ProcessHandle::destroyForcibly);
                    process.destroyForcibly();
                };
                return new ExternalProcess(process, killSwitch);
            });
        }
        catch (PrivilegedActionException e) {
            LogService.getRoot().log(Level.WARNING, e.getCause(), () -> String.format("Failed to run command %s, message: %s", Arrays.toString(this.command), e.getCause().getMessage()));
            throw new IOException(e.getCause());
        }
    }

    public static ExternalProcessBuilder newBuilder() {
        return new ExternalProcessBuilder();
    }
}

