/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.util;

import com.altair.ai.pel.util.ExternalProcess;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class ExternalProcessTools
extends Enum<ExternalProcessTools> {
    private static final /* synthetic */ ExternalProcessTools[] $VALUES;

    public static ExternalProcessTools[] values() {
        return (ExternalProcessTools[])$VALUES.clone();
    }

    public static ExternalProcessTools valueOf(String name) {
        return Enum.valueOf(ExternalProcessTools.class, name);
    }

    public static void startStreamLineConsumer(InputStream in, Consumer<String> lineConsumer, CountDownLatch consumerLatch, String identifier) {
        Thread readerThread = new Thread(() -> {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = reader.readLine();
                while (line != null) {
                    lineConsumer.accept(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to get output for " + identifier);
            }
            finally {
                if (consumerLatch != null) {
                    consumerLatch.countDown();
                }
            }
        });
        readerThread.setName(identifier + "-consumer");
        readerThread.setDaemon(true);
        readerThread.start();
    }

    public static void logShellOutput(String prefix, Level level, String output) {
        ValidationUtilV2.requireNonEmptyString((String)prefix, (String)"prefix");
        ValidationUtilV2.requireNonNull((Object)level, (String)"level");
        if (StringUtils.trimToNull((String)output) == null) {
            return;
        }
        LogService.getRoot().log(level, () -> String.format("%s: %s", prefix, output));
    }

    public static List<ProcessHandle> getSubprocesses(Process process) {
        return ExternalProcessTools.getSubprocesses(process.toHandle());
    }

    public static List<ProcessHandle> getSubprocesses(ExternalProcess process) {
        return ExternalProcessTools.getSubprocesses(process.getProcess().toHandle());
    }

    public static List<ProcessHandle> getSubprocesses(ProcessHandle process) {
        List children = process.children().collect(Collectors.toList());
        ArrayList<ProcessHandle> result = new ArrayList<ProcessHandle>(children);
        for (ProcessHandle child : children) {
            result.addAll(ExternalProcessTools.getSubprocesses(child));
        }
        return result;
    }

    private static /* synthetic */ ExternalProcessTools[] $values() {
        return new ExternalProcessTools[0];
    }

    static {
        $VALUES = ExternalProcessTools.$values();
    }
}

