/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.util;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.TempFileTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.logging.Level;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FileBackup {
    private final DigestUtils digestUtils = new DigestUtils(DigestUtils.getSha3_256Digest());
    private final Path backupTarget;
    private Path backupTargetCopy;
    private String backupTargetHash;
    private boolean canRestore = true;
    private boolean didNotExist = false;

    public FileBackup(Path backupTarget) {
        this.backupTarget = (Path)ValidationUtilV2.requireNonNull((Object)backupTarget, (String)"backupTarget");
    }

    public void backupNow() throws IOException {
        if (!Files.exists(this.backupTarget, new LinkOption[0])) {
            this.canRestore = false;
            this.didNotExist = true;
            throw new FileNotFoundException(this.backupTarget + " does not exist");
        }
        if (Files.isDirectory(this.backupTarget, new LinkOption[0])) {
            this.canRestore = false;
            throw new IOException(this.backupTarget + " is a directory");
        }
        Path tempFile = TempFileTools.createTempFile((String)FilenameUtils.getBaseName((String)this.backupTarget.getFileName().toString()), (String)"");
        Files.copy(this.backupTarget, tempFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        this.backupTargetCopy = tempFile;
        this.backupTargetHash = this.digestUtils.digestAsHex(this.backupTarget, new OpenOption[0]);
    }

    public void restoreNowIfNeeded() throws IOException {
        if (this.didNotExist && Files.exists(this.backupTarget, new LinkOption[0])) {
            LogService.getRoot().log(Level.FINE, () -> String.format("File %s did not exist, but does now -> deleting it again", this.backupTarget));
            FileUtils.deleteQuietly((File)this.backupTarget.toFile());
            return;
        }
        if (!this.canRestore) {
            return;
        }
        if (this.backupTargetCopy != null) {
            String newHash = this.digestUtils.digestAsHex(this.backupTarget, new OpenOption[0]);
            if (!Objects.equals(this.backupTargetHash, newHash)) {
                Files.copy(this.backupTargetCopy, this.backupTarget, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                LogService.getRoot().log(Level.FINE, () -> String.format("Reverted changes to %s", this.backupTarget));
            } else {
                LogService.getRoot().log(Level.FINE, () -> String.format("File %s not changed, no revert necessary", this.backupTarget));
            }
        } else {
            throw new IOException("Previous file content is null");
        }
        FileUtils.deleteQuietly((File)this.backupTargetCopy.toFile());
    }

    public Path getBackupTarget() {
        return this.backupTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBackup that = (FileBackup)o;
        return Objects.equals(this.backupTarget, that.backupTarget) && Objects.equals(this.backupTargetCopy, that.backupTargetCopy) && Objects.equals(this.backupTargetHash, that.backupTargetHash);
    }

    public int hashCode() {
        return Objects.hash(this.backupTarget, this.backupTargetCopy, this.backupTargetHash);
    }

    public String toString() {
        return "FileBackup{backupTarget=" + this.backupTarget + ", backupTargetCopy=" + this.backupTargetCopy + ", backupTargetHash='" + this.backupTargetHash + "'}";
    }
}

