/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.util;

import com.altair.ai.pel.util.OSTools;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.FileSystemService;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;

public final class FileTools
extends Enum<FileTools> {
    private static final String PYTHON_EXTENSIONS_DIR = "python-extensions";
    private static final String EXTENSIONS_DIR = "extensions";
    private static final String DEFAULT_PY_RESOURCE_DIR = "temp";
    private static final String DEFAULT_PY_DISTS_DIR = "py-dists";
    private static final String MINIFORGE_DIR_PARENT = "AIToolsDevkit";
    private static final String MINIFORGE_DIR = "Miniforge3";
    private static final String MINIFORGE_FAKE_HOME_DIR = "miniforge_home";
    private static final /* synthetic */ FileTools[] $VALUES;

    public static FileTools[] values() {
        return (FileTools[])$VALUES.clone();
    }

    public static FileTools valueOf(String name) {
        return Enum.valueOf(FileTools.class, name);
    }

    public static Path getPythonExtensionLookupDirectory() {
        Path lookupDir = null;
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(10, 4, 0, "SNAPSHOT"))) {
            try {
                Class<?> dirServiceClass = Class.forName("com.rapidminer.tools.DirectoryService");
                Method getExtDirMethod = dirServiceClass.getDeclaredMethod("getExtensionsDir", new Class[0]);
                lookupDir = ((Path)getExtDirMethod.invoke(null, new Object[0])).resolve(PYTHON_EXTENSIONS_DIR);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to look up Python extensions in shared extension folder as DirectoryService could not be accessed.Falling back to the pre-10.4.0 lookup.", e);
            }
        }
        if (lookupDir == null) {
            lookupDir = FileSystemService.getUserRapidMinerDir().toPath().resolve(EXTENSIONS_DIR).resolve(PYTHON_EXTENSIONS_DIR);
        }
        return lookupDir;
    }

    public static Path getTempDirectory() {
        Path workingDir = null;
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(10, 4, 0, "SNAPSHOT"))) {
            try {
                Class<?> dirServiceClass = Class.forName("com.rapidminer.tools.DirectoryService");
                Method getTempDirMethod = dirServiceClass.getDeclaredMethod("resolveInternalCacheDir", new Class[0]);
                String tempDirName = (String)dirServiceClass.getDeclaredField("INTERNAL_CACHE_TEMP").get(null);
                workingDir = ((Path)getTempDirMethod.invoke(null, new Object[0])).resolve(tempDirName);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to look up working dir as DirectoryService could not be accessed.Falling back to the pre-10.4.0 lookup.", e);
            }
        }
        if (workingDir == null) {
            workingDir = FileSystemService.getUserRapidMinerDir().toPath().resolve("internal cache/temp");
        }
        return workingDir;
    }

    public static Path getPyDistDefaultRootDirectory() {
        Path pyDistDir = null;
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(10, 4, 0, "SNAPSHOT"))) {
            try {
                Class<?> dirServiceClass = Class.forName("com.rapidminer.tools.DirectoryService");
                Method getTempDirMethod = dirServiceClass.getDeclaredMethod("resolveInternalCacheDir", new Class[0]);
                pyDistDir = ((Path)getTempDirMethod.invoke(null, new Object[0])).resolve(DEFAULT_PY_DISTS_DIR);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to look up default python distribution lookup directory as DirectoryService could not be accessed.Falling back to the pre-10.4.0 lookup.", e);
            }
        }
        if (pyDistDir == null) {
            pyDistDir = FileSystemService.getUserRapidMinerDir().toPath().resolve("internal cache/temp").resolve(DEFAULT_PY_DISTS_DIR);
        }
        return pyDistDir;
    }

    public static Path getPyResourceDefaultRootDirectory() {
        Path pyResourceDir = null;
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(10, 4, 0, "SNAPSHOT"))) {
            try {
                Class<?> dirServiceClass = Class.forName("com.rapidminer.tools.DirectoryService");
                Method getTempDirMethod = dirServiceClass.getDeclaredMethod("resolveInternalCacheDir", new Class[0]);
                pyResourceDir = ((Path)getTempDirMethod.invoke(null, new Object[0])).resolve(DEFAULT_PY_RESOURCE_DIR);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to resolve default python resource directory as DirectoryService could not be accessed.Falling back to the pre-10.4.0 lookup.", e);
            }
        }
        if (pyResourceDir == null) {
            pyResourceDir = FileSystemService.getUserRapidMinerDir().toPath().resolve("internal cache/temp").resolve(DEFAULT_PY_RESOURCE_DIR);
        }
        return pyResourceDir;
    }

    public static Path getMiniforgeDefaultDirectory() {
        String baseDirSetting;
        if (OSTools.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            return Paths.get(System.getenv("LOCALAPPDATA"), new String[0]).resolve("Altair").resolve("MF");
        }
        Path baseDir = null;
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(10, 4, 0, "SNAPSHOT")) && (baseDirSetting = Settings.getSetting((String)"rapidminer.execution.working_directory")) != null) {
            baseDir = Paths.get(baseDirSetting, new String[0]);
        }
        if (baseDir == null) {
            baseDir = FileSystemService.getUserRapidMinerDir().toPath();
        }
        if (!RapidMiner.getExecutionMode().isHeadless() && !baseDir.endsWith(".RapidMiner")) {
            baseDir = baseDir.getParent();
        }
        return baseDir.resolve(MINIFORGE_DIR_PARENT).resolve(MINIFORGE_DIR);
    }

    public static Path getMiniforgeFakeHomeDefaultDirectory() {
        String baseDirSetting;
        if (OSTools.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            throw new IllegalStateException("Cannot use Miniforge fake home dir on Windows!");
        }
        Path baseDir = null;
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(10, 4, 0, "SNAPSHOT")) && (baseDirSetting = Settings.getSetting((String)"rapidminer.execution.working_directory")) != null) {
            baseDir = Paths.get(baseDirSetting, new String[0]);
        }
        if (baseDir == null) {
            baseDir = FileSystemService.getUserRapidMinerDir().toPath();
        }
        if (!RapidMiner.getExecutionMode().isHeadless() && !baseDir.endsWith(".RapidMiner")) {
            baseDir = baseDir.getParent();
        }
        return baseDir.resolve(MINIFORGE_DIR_PARENT).resolve(MINIFORGE_FAKE_HOME_DIR);
    }

    public static String tryShorteningPath(Path targetPath, Path shorthandPath, String shorthand) {
        try {
            Path candidate;
            Path realShorthandPath = shorthandPath.toRealPath(new LinkOption[0]);
            if (candidate != null && candidate.toRealPath(new LinkOption[0]).startsWith(realShorthandPath)) {
                for (candidate = targetPath.getParent(); candidate != null; candidate = candidate.getParent()) {
                    if (!candidate.toRealPath(new LinkOption[0]).equals(realShorthandPath)) continue;
                    return Path.of(shorthand, new String[0]).resolve(candidate.relativize(targetPath)).toString();
                }
            }
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Error while trying to shorten path.", e);
        }
        return targetPath.toString();
    }

    public static void ensureEmptyDirectoryExists(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            if (Files.exists(dir, new LinkOption[0])) {
                Files.delete(dir);
            }
            Files.createDirectories(dir, new FileAttribute[0]);
        } else {
            FileUtils.cleanDirectory((File)dir.toFile());
        }
    }

    public static Path createShellScript(Path shellScriptDir) throws IOException {
        ValidationUtilV2.requireNonNull((Object)shellScriptDir, (String)"shellScriptDir");
        if (Files.exists(shellScriptDir, new LinkOption[0]) && !Files.isDirectory(shellScriptDir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + shellScriptDir);
        }
        if (!Files.exists(shellScriptDir, new LinkOption[0])) {
            Files.createDirectories(shellScriptDir, new FileAttribute[0]);
        }
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                return FileTools.createShellScriptWindows(shellScriptDir);
            }
            case OSX: {
                return FileTools.createShellScriptMacOS(shellScriptDir);
            }
        }
        return FileTools.createShellScriptUnix(shellScriptDir);
    }

    private static Path createShellScriptWindows(Path shellScriptDir) throws IOException {
        Path shellScript;
        int i = 0;
        while (true) {
            if (!Files.exists(shellScript = shellScriptDir.resolve(String.format("invoke_python_%d.bat", i)), new LinkOption[0])) break;
            ++i;
        }
        Files.createFile(shellScript, new FileAttribute[0]);
        return shellScript;
    }

    private static Path createShellScriptUnix(Path shellScriptDir) throws IOException {
        Path shellScript;
        int i = 0;
        while (true) {
            if (!Files.exists(shellScript = shellScriptDir.resolve(String.format("invoke_python_%d.sh", i)), new LinkOption[0])) break;
            ++i;
        }
        Files.createFile(shellScript, PosixFilePermissions.asFileAttribute(Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)));
        return shellScript;
    }

    private static Path createShellScriptMacOS(Path shellScriptDir) throws IOException {
        return FileTools.createShellScriptUnix(shellScriptDir);
    }

    private static /* synthetic */ FileTools[] $values() {
        return new FileTools[0];
    }

    static {
        $VALUES = FileTools.$values();
    }
}

