/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.util;

import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.altair.ai.pel.util.OSArch;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public final class OSTools
extends Enum<OSTools> {
    private static final SystemInfoUtilities.OperatingSystem os;
    private static final OSArch arch;
    private static final String platformName;
    private static final /* synthetic */ OSTools[] $VALUES;

    public static OSTools[] values() {
        return (OSTools[])$VALUES.clone();
    }

    public static OSTools valueOf(String name) {
        return Enum.valueOf(OSTools.class, name);
    }

    public static SystemInfoUtilities.OperatingSystem getOperatingSystem() {
        return os;
    }

    public static OSArch getOperatingSystemArchitecture() {
        return arch;
    }

    public static String getPlatformName() {
        return platformName;
    }

    private static OSArch getOSArchForWindows() {
        String response = System.getenv("PROCESSOR_ARCHITECTURE");
        if (response != null) {
            response = response.toLowerCase();
        }
        if ("x86".equals(response)) {
            return OSArch.x86_32;
        }
        if ("amd64".equals(response)) {
            return OSArch.x86_64;
        }
        if ("arm64".equals(response)) {
            return OSArch.ARM64;
        }
        LogService.getRoot().log(Level.WARNING, "Unknown OS architecture: " + response);
        return OSArch.UNKNOWN;
    }

    private static OSArch getOSArchForUnix() {
        StringBuilder sb = new StringBuilder();
        try {
            CountDownLatch latch = new CountDownLatch(2);
            ExternalProcess result = ExternalProcessBuilder.newBuilder().outputConsumer(sb::append).errorConsumer(err -> ExternalProcessTools.logShellOutput("OS architecture check", Level.WARNING, err)).awaitOutputStreamsClosing(latch).id("os-arch-check").command("uname", "-m").startProcess();
            Process process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            String response = sb.toString().toLowerCase();
            if (response.contains("arch64") || response.contains("arm64")) {
                return OSArch.ARM64;
            }
            if (response.contains("ppc64le")) {
                return OSArch.PPC64LE;
            }
            if (response.contains("i386")) {
                return OSArch.x86_32;
            }
            if (response.contains("x86_64")) {
                return OSArch.x86_64;
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("Unknown OS architecture! Exit code: %d, response: %s", process.exitValue(), response));
            return OSArch.UNKNOWN;
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to look up OS architecture", e);
            return OSArch.UNKNOWN;
        }
    }

    private static OSArch getOSArchForMacOS() {
        String response;
        Process process;
        ExternalProcess result;
        CountDownLatch latch;
        StringBuilder sb = new StringBuilder();
        try {
            latch = new CountDownLatch(2);
            result = ExternalProcessBuilder.newBuilder().outputConsumer(sb::append).errorConsumer(err -> ExternalProcessTools.logShellOutput("OS architecture check", Level.WARNING, err)).awaitOutputStreamsClosing(latch).id("os-arch-check").command("sysctl", "hw.optional.arm64").startProcess();
            process = result.getProcessFuture().get(5L, TimeUnit.SECONDS);
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            if (process.exitValue() == 0) {
                response = sb.toString().toLowerCase();
                if (response.matches("hw\\.optional\\.arm64.+1")) {
                    return OSArch.ARM64;
                }
                if (response.matches("hw\\.optional\\.arm64.+0")) {
                    return OSArch.x86_64;
                }
                LogService.getRoot().log(Level.WARNING, () -> String.format("Failed first try to look up OS architecture, result was; %s", response));
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to look up OS architecture", e);
            return OSArch.UNKNOWN;
        }
        try {
            latch = new CountDownLatch(2);
            result = ExternalProcessBuilder.newBuilder().outputConsumer(sb::append).errorConsumer(err -> ExternalProcessTools.logShellOutput("OS architecture check", Level.WARNING, err)).awaitOutputStreamsClosing(latch).id("os-arch-check").command("uname", "-m").startProcess();
            process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            response = sb.toString().toLowerCase();
            if (response.contains("arm64")) {
                return OSArch.ARM64;
            }
            if (response.contains("x86_64")) {
                return OSArch.x86_64;
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("Unknown OS architecture! Exit code: %d, response: %s", process.exitValue(), response));
            return OSArch.UNKNOWN;
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to look up OS architecture", e);
            return OSArch.UNKNOWN;
        }
    }

    private static String getPlatformNameWindows() {
        if (arch == OSArch.x86_64) {
            return "win-64";
        }
        return "win-unsupported";
    }

    private static String getPlatformNameUnix() {
        switch (arch) {
            case x86_64: {
                return "linux-64";
            }
            case ARM64: {
                return "linux-aarch64";
            }
            case PPC64LE: {
                return "linux-ppc64le";
            }
        }
        return "linux-unsupported";
    }

    private static String getPlatformNameMacOS() {
        switch (arch) {
            case x86_64: {
                return "osx-64";
            }
            case ARM64: {
                return "osx-64";
            }
        }
        return "osx-unsupported";
    }

    private static /* synthetic */ OSTools[] $values() {
        return new OSTools[0];
    }

    static {
        $VALUES = OSTools.$values();
        os = SystemInfoUtilities.getOperatingSystem();
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                arch = OSTools.getOSArchForWindows();
                platformName = OSTools.getPlatformNameWindows();
                break;
            }
            case OSX: {
                arch = OSTools.getOSArchForMacOS();
                platformName = OSTools.getPlatformNameMacOS();
                break;
            }
            default: {
                arch = OSTools.getOSArchForUnix();
                platformName = OSTools.getPlatformNameUnix();
            }
        }
    }
}

