/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.util;

import com.altair.ai.pel.util.OSTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Objects;
import java.util.logging.Level;

public class WindowsRegistryHelper {
    public static final String MINIFORGE_INIT_CONFIG_PATH = "Software\\Microsoft\\Command Processor";
    public static final String MINIFORGE_INIT_CONFIG_KEY = "AutoRun";

    public WindowsRegistryHelper() {
        if (OSTools.getOperatingSystem() != SystemInfoUtilities.OperatingSystem.WINDOWS) {
            throw new IllegalStateException("WindowsRegistryHelper can only be used on Windows!");
        }
    }

    public String readValue(String path, String key) {
        try {
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key)) {
                return null;
            }
            return Objects.toString(Advapi32Util.registryGetValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)path, (String)key));
        }
        catch (Throwable t) {
            LogService.getRoot().log(Level.WARNING, "Failed to access the Windows registry.", t);
            return null;
        }
    }

    public void setValue(String path, String key, String value) {
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)path, (String)key, (String)value);
    }
}

