/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.altair.ai.pel.python.util.PythonOperatorTools;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.Collection;
import java.util.function.Supplier;

public class SupplierSimplePrecondition
extends AbstractPrecondition {
    private final Supplier<MetaData> expectedMetaData;
    private final boolean mandatory;

    public SupplierSimplePrecondition(InputPort inputPort, Supplier<MetaData> expectedMetaData, boolean mandatory) {
        super((InputPort)ValidationUtilV2.requireNonNull((Object)inputPort, (String)"inputPort"));
        this.expectedMetaData = (Supplier)ValidationUtilV2.requireNonNull(expectedMetaData, (String)"expectedMetaData");
        this.mandatory = mandatory;
    }

    public final void check(MetaData metaData) {
        InputPort inputPort = this.getInputPort();
        if (metaData == null) {
            if (this.isMandatory()) {
                inputPort.addError((MetaDataError)new InputMissingMetaDataError(inputPort, this.expectedMetaData.get().getObjectClass(), null));
            }
        } else {
            Collection errors = this.expectedMetaData.get().getErrorsForInput(inputPort, metaData, CompatibilityLevel.VERSION_5);
            for (MetaDataError error : errors) {
                inputPort.addError(error);
            }
            this.makeAdditionalChecks(metaData);
        }
    }

    public void makeAdditionalChecks(MetaData received) {
    }

    public String getDescription() {
        if (this.isMandatory()) {
            return I18N.getGUILabel((String)"operator.port.precondition.description.expects", (Object[])new Object[]{PythonOperatorTools.getTitleForDescription(this.expectedMetaData.get())});
        }
        return I18N.getGUILabel((String)"operator.port.precondition.description.optional", (Object[])new Object[]{PythonOperatorTools.getTitleForDescription(this.expectedMetaData.get())});
    }

    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        MetaData md = this.expectedMetaData.get();
        if (md != null) {
            return md.isCompatible(input, level);
        }
        return true;
    }

    public void assumeSatisfied() {
        MetaData md;
        if (this.mandatory && (md = this.expectedMetaData.get()) != null) {
            this.getInputPort().receiveMD(md);
        }
    }

    public MetaData getExpectedMetaData() {
        return this.expectedMetaData.get();
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }
}

