from importlib.metadata import version, PackageNotFoundError
from packaging.version import Version
import sys

def compare_versions(version1: str, version2: str) -> int:
    v1 = Version(version1)
    v2 = Version(version2)

    if v1 > v2:
        return 1
    elif v1 < v2:
        return -1
    else:
        return 0


def supported_multiple(required_packages: [(str, str)]) -> bool:
    sup = True
    for p in required_packages:
        if not sup:
            return False
        sup &= supported(p)
    return sup


def supported(package: (str, str)) -> bool:
    try:
        return compare_versions(version(package[0]), package[1]) >= 0
    except PackageNotFoundError:
        return False


# First, print Python version
print(sys.version)

package_aitools_sdk = ("altair-aitools-runtime", "1.0")

supported_aisdk = supported(package_aitools_sdk)

capabilities = []

if supported_aisdk:
    capabilities.append("PACKAGE_AITOOLS_SDK")

# Second, print supported capabilities
print(*capabilities)
