from __future__ import annotations

import base64
from typing import TYPE_CHECKING

from altair_aitools.ext.runtime import RuntimeConfig
from cryptography.hazmat.primitives.ciphers.aead import AESGCM

if TYPE_CHECKING:
    from ..wrapper.wrapper_json_parser import ConnectionParam


def decrypt_connection_params(enc_params: list[ConnectionParam]) -> dict[str,str]:
    from altair_aitools.ext.io.connections import SecretStr

    if "secret" in RuntimeConfig.config_dict:
        secret = RuntimeConfig.get("secret")
        key = base64.urlsafe_b64decode(secret)
        aesgcm = AESGCM(key)
    else:
        secret = None

    plain: dict[str,str] = {}
    for param in enc_params:
        if param.encrypted:
            if not secret:
                raise ValueError("Secret not set. Failed to decode connection parameter.")
            data = base64.urlsafe_b64decode(param.value)
            iv, ct = data[:12], data[12:]
            pt = aesgcm.decrypt(iv, ct, None)
            plain[param.key] = SecretStr(pt.decode('utf-8'))
        else:
            plain[param.key] = param.value
    return plain
