"""Wrapper script for Python extensions."""

import logging
from argparse import ArgumentParser, Namespace
from pathlib import Path

from altair_aitools.ext.runtime import RuntimeConfig

from pew.util import setup_logging
from pew.wrapper import Functions, FunctionWrapper


def parse_args() -> Namespace:
    """Parses the command line arguments."""
    description = "Wrapper script for Python extensions."
    parser = ArgumentParser(description=description)
    parser.add_argument("-f", "--file", type=Path, help="the extension arguments")
    parser.add_argument(
        "--temp-dir",
        type=Path,
        default=None,
        help="temporary directory to store the files",
    )

    parser.add_argument(
        "--secret",
        type=str,
        default=None,
        help="Shared secret to decrypt connection values"
    )
    parser.add_argument(
        "-v",
        "--verbose",
        action="store_true",
        help="make the operation more descriptive",
    )
    return parser.parse_args()


if __name__ == "__main__":
    print("Wrapper script started")
    args = parse_args()
    setup_logging(args.verbose)
    logging.debug("Logging setup completed")
    if args.temp_dir:
        RuntimeConfig.set("temp_dir", args.temp_dir)
    if args.secret:
        RuntimeConfig.set("secret", args.secret)
    with open(args.file) as file:
        logging.debug("Parsing functions from provided JSON file")
        functions = Functions.model_validate_json(file.read())
        logging.debug("Successfully parsed functions")
        wrapper = FunctionWrapper()
        wrapper.execute_functions(functions)
