/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.helpers;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.prescriptive.helpers.DataPoint;
import com.rapidminer.prescriptive.operator.CandidateOptimizationOperator;
import com.rapidminer.tools.LoggingHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CandidateSolutions {
    private List<DataPoint> solutions = new ArrayList<DataPoint>();
    private double currentBestFitness;
    private DataPoint currentBestSolution;
    boolean hasCandidates = false;
    private String xName;
    private String yName;
    CandidateOptimizationOperator caller;
    public double lastFitnessChange;
    public double lastPenalityChange;
    public int lastTouch;

    public CandidateSolutions(String xName, String yName, CandidateOptimizationOperator operator) {
        this.xName = xName;
        this.yName = yName;
        this.caller = operator;
        this.lastFitnessChange = 0.0;
        this.lastPenalityChange = 0.0;
        this.lastTouch = Integer.MIN_VALUE;
    }

    public void addPoint(DataPoint point) {
        this.solutions.add(point);
        Collections.sort(this.solutions);
        if (point.getFitness() > this.currentBestFitness || !this.hasCandidates) {
            this.currentBestFitness = point.getFitness();
            this.currentBestSolution = point;
        }
        this.hasCandidates = true;
    }

    void GreedyMinimizeByReplacing(List<DataPoint> neighbours, int iterationCounter, LoggingHandler logger) throws OperatorException {
        double currentTadeOff;
        double tradeOffBeforeReplacement = currentTadeOff = this.caller.getPenalityFitnessTradeOff(this.currentBestSolution, neighbours);
        double penalityBeforeReplacement = this.caller.calculatePenality(this.currentBestSolution, neighbours);
        double fitnessBeforeReplacement = this.currentBestSolution.getFitness();
        for (DataPoint p : this.solutions) {
            double thisTradeOff = this.caller.getPenalityFitnessTradeOff(p, neighbours);
            if (!(currentTadeOff < thisTradeOff)) continue;
            this.currentBestFitness = p.getFitness();
            this.currentBestSolution = p;
            currentTadeOff = thisTradeOff;
        }
        this.lastTouch = iterationCounter;
        this.lastFitnessChange = fitnessBeforeReplacement - this.currentBestFitness;
        this.lastPenalityChange = penalityBeforeReplacement - this.caller.calculatePenality(this.currentBestSolution, neighbours);
        logger.log("Replaced a value with fitness " + Double.toString(fitnessBeforeReplacement) + " and penality " + Double.toString(tradeOffBeforeReplacement) + "with a new candidate with fitness " + Double.toString(this.currentBestFitness) + "and penality  " + this.caller.getPenalityFitnessTradeOff(this.currentBestSolution, neighbours), 4);
    }

    public double getCurrentBestFitness() {
        return this.currentBestFitness;
    }

    public DataPoint getCurrentBestSolution() throws UserError {
        if (this.hasCandidates) {
            return this.currentBestSolution;
        }
        throw new UserError((Operator)this.caller, "error.prescriptive_analytics.NoCandidates.name");
    }
}

