/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.helpers;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.utils.ExampleSetBuilder;
import com.rapidminer.example.utils.ExampleSets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class DataPoint
implements Comparable {
    private double xValue;
    private double yValue;
    private double performance;
    private String xName;
    private String yName;
    private String performanceName;
    private HashMap<String, Double> additionalValues;
    private boolean minimizeFitness;

    public DataPoint(double xValue, double yValue, double performance, String xName, String yName, String performanceName, boolean minimizeFitness) {
        this.xValue = xValue;
        this.yValue = yValue;
        this.performance = performance;
        this.additionalValues = new HashMap();
        this.xName = xName;
        this.yName = yName;
        this.minimizeFitness = minimizeFitness;
        this.performanceName = performanceName;
    }

    public void addValue(String name, double value) {
        this.additionalValues.put(name, value);
    }

    public double getyValue() {
        return this.yValue;
    }

    public double getxValue() {
        return this.xValue;
    }

    public double getFitness() {
        if (this.minimizeFitness) {
            return -1.0 * this.performance;
        }
        return this.performance;
    }

    public double getAdditionalValue(String name) {
        if (this.additionalValues.containsKey(name)) {
            return this.additionalValues.get(name);
        }
        return Double.NaN;
    }

    public HashMap<String, Double> getAdditionalValues() {
        return this.additionalValues;
    }

    public int compareTo(DataPoint o) {
        if (this.getFitness() < o.getFitness()) {
            return -1;
        }
        return 1;
    }

    public ExampleSet toExampleSet() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(AttributeFactory.createAttribute((String)this.xName, (int)2));
        atts.add(AttributeFactory.createAttribute((String)this.yName, (int)2));
        atts.add(AttributeFactory.createAttribute((String)this.performanceName, (int)2));
        Set<String> additionalAttributeNames = this.additionalValues.keySet();
        for (String name : additionalAttributeNames) {
            atts.add(AttributeFactory.createAttribute((String)name, (int)2));
        }
        ExampleSetBuilder builder = ExampleSets.from(atts);
        double[] row = new double[3 + this.additionalValues.size()];
        row[0] = this.xValue;
        row[1] = this.yValue;
        row[2] = this.getPerformance();
        int i = 3;
        for (String name : this.additionalValues.keySet()) {
            row[i] = this.getAdditionalValue(name);
            ++i;
        }
        builder.addRow(row);
        ExampleSet result = builder.build();
        result.getAttributes().setSpecialAttribute((Attribute)atts.get(0), "x");
        result.getAttributes().setSpecialAttribute((Attribute)atts.get(1), "y");
        result.getAttributes().setSpecialAttribute((Attribute)atts.get(2), this.performanceName);
        return builder.build();
    }

    public void setxName(String xName) {
        this.xName = xName;
    }

    public void setyName(String yName) {
        this.yName = yName;
    }

    public String getxName() {
        return this.xName;
    }

    public String getyName() {
        return this.yName;
    }

    public String getPerformanceName() {
        return this.performanceName;
    }

    public double getPerformance() {
        return this.performance;
    }

    public int compareTo(Object o) {
        return this.compareTo((DataPoint)o);
    }
}

