/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.helpers;

import com.rapidminer.io.process.XMLTools;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;

public class ExtendableEqualStringCondition
extends ParameterCondition {
    private static final String ELEMENT_VALUES = "Values";
    private static final String ELEMENT_VALUE = "Value";
    private String[] types;

    public ExtendableEqualStringCondition(Element element) throws XMLException {
        super(element);
        Element valuesElement = XMLTools.getChildElement((Element)element, (String)ELEMENT_VALUES, (boolean)true);
        this.types = XMLTools.getChildTagsContentAsStringArray((Element)valuesElement, (String)ELEMENT_VALUE);
    }

    public ExtendableEqualStringCondition(ParameterHandler handler, String conditionParameter, boolean becomeMandatory, String ... types) {
        super(handler, conditionParameter, becomeMandatory);
        this.types = types;
    }

    public boolean isConditionFullfilled() {
        String isType;
        boolean equals = false;
        try {
            isType = this.parameterHandler.getParameterAsString(this.conditionParameter);
        }
        catch (UndefinedParameterError e) {
            return false;
        }
        for (String type : this.types) {
            equals |= type.equals(isType);
        }
        return equals;
    }

    public void addType(String newType) {
        String[] newTypes = new String[this.types.length + 1];
        int i = 0;
        for (String oldString : this.types) {
            newTypes[i] = this.types[i];
            ++i;
        }
        newTypes[this.types.length] = newType;
        this.types = newTypes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.types.length > 1) {
            builder.append(this.conditionParameter.replace('_', ' ') + " \u2208 {");
            for (int i = 0; i < this.types.length; ++i) {
                builder.append(this.types[i]);
                if (i + 1 >= this.types.length) continue;
                builder.append(", ");
            }
            builder.append("}");
        } else if (this.types.length > 0) {
            builder.append(this.conditionParameter.replace('_', ' ') + " = " + this.types[0]);
        }
        return builder.toString();
    }

    public void getDefinitionAsXML(Element element) {
        Element valuesElement = XMLTools.addTag((Element)element, (String)ELEMENT_VALUES);
        for (String value : this.types) {
            XMLTools.addTag((Element)valuesElement, (String)ELEMENT_VALUE, (String)value);
        }
    }
}

