/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.helpers;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.utils.ExampleSetBuilder;
import com.rapidminer.example.utils.ExampleSets;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.prescriptive.helpers.CandidateSolutions;
import com.rapidminer.prescriptive.helpers.DataPoint;
import com.rapidminer.prescriptive.operator.CandidateOptimizationOperator;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MatrixOfCandidates {
    private CandidateSolutions[][] candidateMatrix;
    private HashMap<Double, Integer> xMapping;
    private HashMap<Double, Integer> yMapping;
    private CandidateOptimizationOperator callingOperator;
    private ExampleSetBuilder optimizationLog;

    public MatrixOfCandidates(HashMap xMapping, HashMap yMapping, String xName, String yName, CandidateOptimizationOperator caller) {
        this.xMapping = xMapping;
        this.yMapping = yMapping;
        this.candidateMatrix = new CandidateSolutions[xMapping.size()][yMapping.size()];
        for (int xi = 0; xi < xMapping.size(); ++xi) {
            for (int yi = 0; yi < yMapping.size(); ++yi) {
                this.candidateMatrix[xi][yi] = new CandidateSolutions(xName, yName, caller);
            }
        }
        this.callingOperator = caller;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(AttributeFactory.createAttribute((String)"iteration", (int)2));
        atts.add(AttributeFactory.createAttribute((String)"fitnessChange", (int)2));
        atts.add(AttributeFactory.createAttribute((String)"penaltyChange", (int)2));
        atts.add(AttributeFactory.createAttribute((String)"tradeoffChange", (int)2));
        this.optimizationLog = ExampleSets.from(atts);
    }

    public void addDataPoint(DataPoint p) {
        int xi = this.xMapping.get(p.getxValue());
        int yi = this.yMapping.get(p.getyValue());
        double fitness = p.getFitness();
        this.candidateMatrix[xi][yi].addPoint(p);
    }

    public double calcPenality(int xi, int yi) throws OperatorException {
        return this.callingOperator.calculatePenality(this.candidateMatrix[xi][yi].getCurrentBestSolution(), this.getNeighbours(xi, yi));
    }

    public void greedyChange(int iterations, int iterationBlock) throws OperatorException {
        for (int i = 0; i < iterations; ++i) {
            double worstTradeOff = Double.MIN_VALUE;
            int worstXi = 0;
            int worstYi = 0;
            for (int xi = 0; xi < this.xMapping.size(); ++xi) {
                for (int yi = 0; yi < this.yMapping.size(); ++yi) {
                    if (i - this.candidateMatrix[xi][yi].lastTouch < iterationBlock) continue;
                    List<DataPoint> neighbours = this.getNeighbours(xi, yi);
                    double tradeoff = this.callingOperator.getPenalityFitnessTradeOff(this.candidateMatrix[xi][yi].getCurrentBestSolution(), neighbours);
                    if (!(tradeoff < worstTradeOff)) continue;
                    worstXi = xi;
                    worstYi = yi;
                    worstTradeOff = tradeoff;
                }
            }
            List<DataPoint> neighbours = this.getNeighbours(worstXi, worstYi);
            this.candidateMatrix[worstXi][worstYi].GreedyMinimizeByReplacing(neighbours, i, this.callingOperator.getLog());
            double[] row = new double[4];
            row[0] = i;
            row[1] = this.candidateMatrix[worstXi][worstYi].lastFitnessChange;
            row[2] = this.candidateMatrix[worstXi][worstYi].lastPenalityChange;
            this.optimizationLog.addRow(row);
        }
    }

    public void randomChange(int iterations) throws OperatorException {
        for (int i = 0; i < iterations; ++i) {
            int xi = RandomGenerator.getGlobalRandomGenerator().nextIntInRange(0, this.xMapping.size());
            int yi = RandomGenerator.getGlobalRandomGenerator().nextIntInRange(0, this.yMapping.size());
            this.candidateMatrix[xi][yi].GreedyMinimizeByReplacing(this.getNeighbours(xi, yi), i, this.callingOperator.getLog());
            double[] row = new double[4];
            row[0] = i;
            row[1] = this.candidateMatrix[xi][yi].lastFitnessChange;
            row[2] = this.candidateMatrix[xi][yi].lastPenalityChange;
            this.optimizationLog.addRow(row);
        }
    }

    private List<DataPoint> getNeighbours(int xi, int yi) throws UserError {
        ArrayList<DataPoint> neigbours = new ArrayList<DataPoint>();
        if (xi != 0) {
            neigbours.add(this.candidateMatrix[xi - 1][yi].getCurrentBestSolution());
        }
        if (yi != 0) {
            neigbours.add(this.candidateMatrix[xi][yi - 1].getCurrentBestSolution());
        }
        if (xi < this.xMapping.size() - 1) {
            neigbours.add(this.candidateMatrix[xi + 1][yi].getCurrentBestSolution());
        }
        if (yi < this.yMapping.size() - 1) {
            neigbours.add(this.candidateMatrix[xi][yi + 1].getCurrentBestSolution());
        }
        return neigbours;
    }

    public ExampleSet getResultMap() throws OperatorException {
        String performanceName = this.candidateMatrix[0][0].getCurrentBestSolution().getPerformanceName();
        String xName = this.candidateMatrix[0][0].getCurrentBestSolution().getxName();
        String yName = this.candidateMatrix[0][0].getCurrentBestSolution().getyName();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(AttributeFactory.createAttribute((String)xName, (int)2));
        atts.add(AttributeFactory.createAttribute((String)yName, (int)2));
        atts.add(AttributeFactory.createAttribute((String)performanceName, (int)2));
        atts.add(AttributeFactory.createAttribute((String)"penalty", (int)2));
        Set<String> additionalAttributeNames = this.candidateMatrix[0][0].getCurrentBestSolution().getAdditionalValues().keySet();
        for (String name : additionalAttributeNames) {
            atts.add(AttributeFactory.createAttribute((String)name, (int)2));
        }
        ExampleSetBuilder builder = ExampleSets.from(atts);
        for (int xi = 0; xi < this.xMapping.size(); ++xi) {
            for (int yi = 0; yi < this.yMapping.size(); ++yi) {
                DataPoint p = this.candidateMatrix[xi][yi].getCurrentBestSolution();
                double[] row = new double[4 + additionalAttributeNames.size()];
                row[0] = p.getxValue();
                row[1] = p.getyValue();
                row[2] = p.getPerformance();
                row[3] = this.calcPenality(xi, yi);
                int i = 4;
                for (String name : additionalAttributeNames) {
                    row[i] = p.getAdditionalValue(name);
                    ++i;
                }
                builder.addRow(row);
            }
        }
        return builder.build();
    }

    public ExampleSet getLog() {
        return this.optimizationLog.build();
    }
}

