/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.prescriptive.operator.AbstractOptimizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Deprecated
public abstract class AbstractSimpleBoundsOptimizer
extends AbstractOptimizer {
    public static final String PARAMETER_BOUNDS_CONFIG = "configure_bounds";
    public static final String PARAMETER_ATT_NAME = "attribute_name";
    public static final String PARAMETER_BOUNDS_CONFIG_MIN = "bounds_min";
    public static final String PARAMETER_BOUNDS_CONFIG_MAX = "bounds_max";
    public static final String PARAMETER_BOUNDS_CONFIG_START = "bounds_start";
    protected double[] minBounds;
    protected double[] maxBounds;
    protected double[] startingPoints;
    protected HashMap<String, HashMap<String, Double>> boundsMap;
    protected InputPort refInput = (InputPort)this.getInputPorts().createPort("ref");

    public AbstractSimpleBoundsOptimizer(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        super.doWork();
    }

    @Override
    public void init() throws UserError {
        super.init();
        this.initBounds();
        this.checkBounds();
        this.getLog().log(this.toString(), 3);
    }

    public void initBounds() throws UserError {
        this.initConstraintHashmap();
        int i = 0;
        this.minBounds = new double[this.attsToConsider.size()];
        this.maxBounds = new double[this.attsToConsider.size()];
        this.startingPoints = new double[this.attsToConsider.size()];
        ExampleSet refExa = null;
        ArrayList<String> refAtts = new ArrayList<String>();
        if (this.refInput.isConnected()) {
            refExa = (ExampleSet)this.refInput.getData(ExampleSet.class);
            refExa.recalculateAllAttributeStatistics();
            for (Attribute a : refExa.getAttributes()) {
                refAtts.add(a.getName());
            }
        }
        for (String attName : this.attsToConsider) {
            if (this.boundsMap.containsKey(attName)) {
                this.minBounds[i] = this.boundsMap.get(attName).get("min");
                this.maxBounds[i] = this.boundsMap.get(attName).get("max");
                this.startingPoints[i] = this.boundsMap.get(attName).get("start");
            } else if (refExa != null && refAtts.contains(attName)) {
                Attribute a = refExa.getAttributes().get(attName);
                this.minBounds[i] = refExa.getStatistics(a, "minimum");
                this.maxBounds[i] = refExa.getStatistics(a, "maximum");
                this.startingPoints[i] = refExa.getStatistics(a, "average");
            } else {
                this.getLog().log("Found no bounds for " + attName, 4);
                this.minBounds[i] = -1.7976931348623157E308;
                this.maxBounds[i] = Double.MAX_VALUE;
                this.startingPoints[i] = 0.0;
            }
            ++i;
        }
    }

    private void checkBounds() throws UserError {
        for (String key : this.boundsMap.keySet()) {
            if (!(this.boundsMap.get(key).get("min") > this.boundsMap.get(key).get("max"))) continue;
            throw new UserError((Operator)this, "prescriptive_analytics.MinMaxBounds", new Object[]{key});
        }
    }

    private void initConstraintHashmap() throws UndefinedParameterError {
        boolean i = false;
        List atts = null;
        atts = this.getParameterList(PARAMETER_BOUNDS_CONFIG);
        this.boundsMap = new HashMap(atts.size());
        for (String[] values : atts) {
            String[] settings = ParameterTypeTupel.transformString2Tupel((String)values[1]);
            HashMap<String, Double> tuple = new HashMap<String, Double>(3);
            tuple.put("min", Double.parseDouble(settings[1]));
            tuple.put("max", Double.parseDouble(settings[2]));
            tuple.put("start", Double.parseDouble(settings[0]));
            this.boundsMap.put(values[0], tuple);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bound Optimizer with these bounds: \n");
        for (int i = 0; i < this.minBounds.length; ++i) {
            sb.append((String)this.attsToConsider.get(i) + ":\t");
            sb.append("Min: " + this.minBounds[i] + " ");
            sb.append("Max: " + this.maxBounds[i] + " ");
            sb.append("Start: " + this.startingPoints[i] + " ");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList advancedParameters = new ParameterTypeList(PARAMETER_BOUNDS_CONFIG, "Advanced parameters that can be set.", (ParameterType)new ParameterTypeAttribute(PARAMETER_ATT_NAME, PARAMETER_ATT_NAME, this.exaInput, new int[]{2}), (ParameterType)new ParameterTypeTupel("values (Start, Min, Max)", "(Start,Min,Max)", new ParameterType[]{new ParameterTypeDouble(PARAMETER_BOUNDS_CONFIG_START, PARAMETER_BOUNDS_CONFIG_START, -1.7976931348623157E308, Double.MAX_VALUE, false), new ParameterTypeDouble(PARAMETER_BOUNDS_CONFIG_MIN, PARAMETER_BOUNDS_CONFIG_MIN, -1.7976931348623157E308, Double.MAX_VALUE, false), new ParameterTypeDouble(PARAMETER_BOUNDS_CONFIG_MAX, PARAMETER_BOUNDS_CONFIG_MAX, -1.7976931348623157E308, Double.MAX_VALUE, false)}), true);
        types.add((ParameterType)advancedParameters);
        return types;
    }
}

