/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.prescriptive.operator.AbstractSimpleBoundsOptimizer;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.BOBYQAOptimizer;

@Deprecated
public class BYOBAOptimizeOperator
extends AbstractSimpleBoundsOptimizer
implements MultivariateFunction {
    public static final String PARAMETER_MAX_EVALUATIONS = "max_evaluations";
    public static final String PARAMETER_INITIAL_RADIUS = "initial_radius";
    public static final String PARMETER_STOPPING_RADIUS = "stopping_radius";
    public static final String PARAMETER_NUMBER_INTERPOLATION_POINTS = "number_of_interpolation_points";

    public BYOBAOptimizeOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        this.init();
        BOBYQAOptimizer optim = new BOBYQAOptimizer(this.getParameterAsInt(PARAMETER_NUMBER_INTERPOLATION_POINTS), this.getParameterAsDouble(PARAMETER_INITIAL_RADIUS), this.getParameterAsDouble(PARMETER_STOPPING_RADIUS));
        PointValuePair result = optim.optimize(new OptimizationData[]{new MaxEval(this.getParameterAsInt(PARAMETER_MAX_EVALUATIONS)), new ObjectiveFunction((MultivariateFunction)this), GoalType.MAXIMIZE, new SimpleBounds(this.minBounds, this.maxBounds), new InitialGuess(this.startingPoints)});
        this.perfOutput.deliver((IOObject)this.bestPerformance);
        this.exaOutput.deliver((IOObject)this.bestES);
    }

    public double value(double[] point) {
        PerformanceVector myPerf = null;
        try {
            myPerf = this.evaluateSingleExample(point);
        }
        catch (OperatorException e) {
            e.printStackTrace();
        }
        if (this.bestPerformance == null) {
            this.bestPerformance = myPerf;
        } else if (myPerf.compareTo((Object)this.bestPerformance) == 1) {
            this.getLog().log("New Best Performance: " + Double.toString(this.bestPerformance.getMainCriterion().getFitness()));
        }
        return myPerf.getMainCriterion().getFitness();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMBER_INTERPOLATION_POINTS, "Number of Interpolation points. Should be in [n+2, (n+1)(n+2)/2]}. n is the number of variables.", 0, Integer.MAX_VALUE, 10));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_MAX_EVALUATIONS, "Maximal Evaluations for the algorithm", 0, Integer.MAX_VALUE, 10000));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_INITIAL_RADIUS, "initial radius of the optimization algorithm", 0.0, Double.MAX_VALUE, 10.0));
        types.add((ParameterType)new ParameterTypeDouble(PARMETER_STOPPING_RADIUS, "Default Stopping Raidus radius of the optimization algorithm", 0.0, Double.MAX_VALUE, 1.0E-8));
        return types;
    }
}

