/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.join.ExampleSetMerge;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.prescriptive.helpers.DataPoint;
import com.rapidminer.prescriptive.helpers.MatrixOfCandidates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class CandidateOptimizationOperator
extends OperatorChain {
    public static final String PARAMETER_X_ATT = "x_attribute";
    public static final String PARAMETER_Y_ATT = "y_attribute";
    public static final String PARAMETER_PERFORMANCE_ATT = "performance_attribute";
    public static final String PARAMETER_NUMBER_OF_REPLACEMENTS = "number_of_replacements";
    public static final String PARAMETER_OPTIMIZATION_DIRECTION = "performance_optimization_direction";
    public static String[] DIRECTION_TYPES = new String[]{"maximize", "minimize"};
    public static final String PARAMETER_PERFORMANCE_PENALITY_TRADEOFF = "performance_penality_tradeoff";
    public static final String PARAMETER_REPLACEMENT_STRATEGY = "replacement_strategy";
    public static String[] REPLACEMENT_STRATEGIES = new String[]{"Random Greed", "Maximum Greed"};
    public static final String PARAMETER_ITERATION_BLOCK = "iteration_block";
    public InputPort exaInput = this.getInputPorts().createPort("exa", ExampleSet.class);
    public OutputPort exaOutput = (OutputPort)this.getOutputPorts().createPort("exa");
    public OutputPort oriOutput = (OutputPort)this.getOutputPorts().createPort("out");
    public OutputPort logOutput = (OutputPort)this.getOutputPorts().createPort("log");
    protected final OutputPort innerPointSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("point");
    protected final OutputPort innerNeigbourSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("neighbours");
    protected PortPairExtender inputExtender = new PortPairExtender("in", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    protected final InputPort innerPerformanceOutput = this.getSubprocess(0).getInnerSinks().createPort("Performance Vector", PerformanceVector.class);
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exaInput, new int[]{4, 3, 2});

    public CandidateOptimizationOperator(OperatorDescription description) {
        this(description, "Penalty Process");
    }

    public CandidateOptimizationOperator(OperatorDescription description, String subProcessName) {
        super(description, new String[]{subProcessName});
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                ExampleSetMetaData md = (ExampleSetMetaData)CandidateOptimizationOperator.this.exaInput.getMetaData();
                md = CandidateOptimizationOperator.this.attributeSelector.getMetaDataSubset(md, true);
                md.addAttribute(new AttributeMetaData("penalty", 2));
                try {
                    md.addAttribute(new AttributeMetaData(CandidateOptimizationOperator.this.getParameterAsString(CandidateOptimizationOperator.PARAMETER_X_ATT), 1));
                    md.addAttribute(new AttributeMetaData(CandidateOptimizationOperator.this.getParameterAsString(CandidateOptimizationOperator.PARAMETER_Y_ATT), 1));
                    md.addAttribute(new AttributeMetaData(CandidateOptimizationOperator.this.getParameterAsString(CandidateOptimizationOperator.PARAMETER_PERFORMANCE_ATT), 2));
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    undefinedParameterError.printStackTrace();
                }
                CandidateOptimizationOperator.this.exaOutput.deliverMD((MetaData)md);
            }
        });
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                ExampleSetMetaData md = new ExampleSetMetaData(ExampleSet.class);
                md.addAttribute(new AttributeMetaData("fitnessChange", 2));
                md.addAttribute(new AttributeMetaData("penaltyChange", 2));
                md.addAttribute(new AttributeMetaData("tradeoffChange", 2));
                CandidateOptimizationOperator.this.logOutput.deliverMD((MetaData)md);
            }
        });
    }

    public void doWork() throws OperatorException {
        ExampleSet inputSet = (ExampleSet)this.exaInput.getData(ExampleSet.class);
        this.oriOutput.deliver((IOObject)inputSet);
        Attribute xAtt = inputSet.getAttributes().get(this.getParameterAsString(PARAMETER_X_ATT));
        Attribute yAtt = inputSet.getAttributes().get(this.getParameterAsString(PARAMETER_Y_ATT));
        Attribute performanceAtt = inputSet.getAttributes().get(this.getParameterAsString(PARAMETER_PERFORMANCE_ATT));
        TreeSet<Double> xValues = new TreeSet<Double>();
        TreeSet<Double> yValues = new TreeSet<Double>();
        boolean minimizePerformance = true;
        if (this.getParameterAsInt(PARAMETER_OPTIMIZATION_DIRECTION) == 0) {
            minimizePerformance = false;
        }
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>(inputSet.size());
        for (Example e : inputSet) {
            double xValue = e.getValue(xAtt);
            double yValue = e.getValue(yAtt);
            double performance = e.getValue(performanceAtt);
            DataPoint dp = new DataPoint(xValue, yValue, performance, xAtt.getName(), yAtt.getName(), performanceAtt.getName(), minimizePerformance);
            for (Attribute att : this.attributeSelector.getAttributeSubset(inputSet, false)) {
                dp.addValue(att.getName(), e.getValue(att));
            }
            dataPoints.add(dp);
            xValues.add(xValue);
            yValues.add(yValue);
        }
        HashMap<Double, Integer> xMapping = new HashMap<Double, Integer>(xValues.size());
        HashMap<Double, Integer> yMapping = new HashMap<Double, Integer>(yValues.size());
        int xi = 0;
        for (Double x : xValues) {
            xMapping.put(x, xi);
            ++xi;
        }
        int yi = 0;
        for (Double y : yValues) {
            yMapping.put(y, yi);
            ++yi;
        }
        MatrixOfCandidates matrixOfCandidates = new MatrixOfCandidates(xMapping, yMapping, xAtt.getName(), yAtt.getName(), this);
        for (DataPoint point : dataPoints) {
            matrixOfCandidates.addDataPoint(point);
        }
        if (this.getParameterAsInt(PARAMETER_REPLACEMENT_STRATEGY) == 0) {
            matrixOfCandidates.randomChange(this.getParameterAsInt(PARAMETER_NUMBER_OF_REPLACEMENTS));
        } else if (this.getParameterAsInt(PARAMETER_REPLACEMENT_STRATEGY) == 1) {
            matrixOfCandidates.greedyChange(this.getParameterAsInt(PARAMETER_NUMBER_OF_REPLACEMENTS), this.getParameterAsInt(PARAMETER_ITERATION_BLOCK));
        }
        this.exaOutput.deliver((IOObject)matrixOfCandidates.getResultMap());
        this.logOutput.deliver((IOObject)matrixOfCandidates.getLog());
    }

    public double calculatePenality(DataPoint point, List<DataPoint> neighbours) throws OperatorException {
        ExampleSet pointSet = this.setRoles(point.toExampleSet(), point);
        ExampleSetMerge merger = new ExampleSetMerge(this.getOperatorDescription());
        ArrayList<ExampleSet> esList = new ArrayList<ExampleSet>(neighbours.size());
        for (DataPoint p : neighbours) {
            esList.add(p.toExampleSet());
        }
        ExampleSet neighbourSet = merger.merge(esList);
        neighbourSet = this.setRoles(neighbourSet, neighbours.get(0));
        this.inputExtender.passDataThrough();
        this.innerNeigbourSource.deliver((IOObject)neighbourSet);
        this.innerPointSource.deliver((IOObject)pointSet);
        super.doWork();
        PerformanceVector perf = (PerformanceVector)this.innerPerformanceOutput.getData(PerformanceVector.class);
        return perf.getMainCriterion().getFitness();
    }

    public double getPenalityFitnessTradeOff(DataPoint point, List<DataPoint> neighbours) throws OperatorException {
        return point.getFitness() + this.getParameterAsDouble(PARAMETER_PERFORMANCE_PENALITY_TRADEOFF) * this.calculatePenality(point, neighbours);
    }

    private ExampleSet setRoles(ExampleSet es, DataPoint p) {
        es.getAttributes().setSpecialAttribute(es.getAttributes().get(p.getxName()), "x");
        es.getAttributes().setSpecialAttribute(es.getAttributes().get(p.getyName()), "y");
        es.getAttributes().setSpecialAttribute(es.getAttributes().get("fitness"), "fitness");
        return es;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        types.add(new ParameterTypeCategory(PARAMETER_REPLACEMENT_STRATEGY, ".", REPLACEMENT_STRATEGIES, 0, false));
        types.add(new ParameterTypeAttribute(PARAMETER_X_ATT, "x dimension of the matrix", this.exaInput, new int[]{2}));
        types.add(new ParameterTypeAttribute(PARAMETER_Y_ATT, "y dimension of the matrix", this.exaInput, new int[]{2}));
        types.add(new ParameterTypeAttribute(PARAMETER_PERFORMANCE_ATT, "Fitness", this.exaInput, new int[]{2}));
        types.add(new ParameterTypeDouble(PARAMETER_PERFORMANCE_PENALITY_TRADEOFF, "trade_off", 0.0, Double.MAX_VALUE, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_REPLACEMENTS, "number of replacements", 0, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_ITERATION_BLOCK, "number of iterations until the same cell can be changed", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeCategory(PARAMETER_OPTIMIZATION_DIRECTION, ".", DIRECTION_TYPES, 0, false));
        return types;
    }
}

