/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.preprocessing.MaterializeDataInMemory;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.prescriptive.helpers.ExtendableEqualStringCondition;
import com.rapidminer.prescriptive.optimizer.BYOBAOptimizer;
import com.rapidminer.prescriptive.optimizer.BYOBAOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.CMAESOptimizerAdapter;
import com.rapidminer.prescriptive.optimizer.CMAESOptimizerAdapterBuilder;
import com.rapidminer.prescriptive.optimizer.ESOptimizer;
import com.rapidminer.prescriptive.optimizer.ESOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.GridOptimizer;
import com.rapidminer.prescriptive.optimizer.GridOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.PowellOptimizerAdapter;
import com.rapidminer.prescriptive.optimizer.PowellOptimizerAdapterBuilder;
import com.rapidminer.prescriptive.optimizer.SimpleBoundsOptimizer;
import com.rapidminer.prescriptive.optimizer.SimpleOptimizer;
import com.rapidminer.prescriptive.optimizer.SimpleOptimizerBuilder;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OptimizationOperator
extends OperatorChain {
    public static String[] optimizers = new String[]{BYOBAOptimizer.getName(), ESOptimizer.getName(), GridOptimizer.getName(), CMAESOptimizerAdapter.getName(), PowellOptimizerAdapter.getName()};
    public static String PARAMETER_OPTIMIZATION_METHOD = "optimization_method";
    public static final String PARAMTER_INIT_START_VALUES = "method_for_start_values";
    public static final String PARAMETER_REFERENCE_INPUT_INDEX = "reference_example_index";
    public static final String[] PARAMETER_START_METHODS = new String[]{"input example", "reference example", "random", "average", "minimum", "maximum"};
    public static final String PARAMETER_BOUNDS_CONFIG = "configure_bounds";
    public static final String PARAMETER_ATT_NAME = "attribute_name";
    public static final String PARAMETER_BOUNDS_CONFIG_MIN = "bounds_min";
    public static final String PARAMETER_BOUNDS_CONFIG_MAX = "bounds_max";
    public static final String PARAMETER_NUMBER_CANDIDATES = "number_of_candidates";
    public static final String PARAMETER_MAX_EVALUATIONS = "max_evaluations";
    public static final String PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD = "stopping_threshold";
    public static final String PARAMETER_RELATIVE_STOPPING_TRHESHOLD = "relative_stopping_threshold";
    public static final String PARAMETER_INITIAL_RADIUS = "initial_radius";
    public static final String PARMETER_STOPPING_RADIUS = "stopping_radius";
    public static final String PARAMETER_NUMBER_INTERPOLATION_POINTS = "number_of_interpolation_points";
    public static final String PARAMETER_USE_INTERPOLATION_POINTS_DEFAULT = "use_interpolation_points_default";
    public static final String PARAMETER_MAX_GENERATIONS = "max_generations";
    public static final String PARAMETER_USE_EARLY_STOPPING = "use_early_stopping";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_TOURNAMENT_FRACTION = "tournament_fraction";
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_MUTATION_TYPE = "mutation_type";
    public static final String PARAMETER_SELECTION_TYPE = "selection_type";
    public static final String PARAMETER_CROSSOVER_PROB = "crossover_prob";
    public static final String PARAMETER_SHOW_CONVERGENCE_PLOT = "show_convergence_plot";
    public static final String PARAMETER_SPECIFIY_POPULATION_SIZE = "specify_population_size";
    public static final String PARAMETER_STEPS = "steps";
    public static final String PARAMETER_SIGMA = "sigma_factor";
    public static final String PARAMETER_POP_SIZE = "population_size";
    public static final String PARAMETER_IS_ACTIVE_CMA = "active_cma";
    public static final String PARAMETER_NUMBER_OF_DIAGONAL_ITERATIONS = "number_of_diagonal_iterations";
    protected InputPort exaInput = (InputPort)this.getInputPorts().createPort("example set input");
    protected InputPort refInput = (InputPort)this.getInputPorts().createPort("ref");
    protected final OutputPort innerExampleSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("training set");
    protected final InputPort innerPerformanceOutput = this.getSubprocess(0).getInnerSinks().createPort("Performance Vector", PerformanceVector.class);
    protected OutputPort exaOutput = (OutputPort)this.getOutputPorts().createPort("exa");
    protected OutputPort perfOutput = (OutputPort)this.getOutputPorts().createPassThroughPort("per");
    protected OutputPort optimizationHistory = (OutputPort)this.getOutputPorts().createPort("optimization history");
    protected PortPairExtender inputExtender = new PortPairExtender("in", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    protected final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exaInput, new int[]{2});

    public OptimizationOperator(OperatorDescription description) {
        this(description, "Nested Process");
    }

    protected OptimizationOperator(OperatorDescription description, String subProcessName) {
        super(description, new String[]{subProcessName});
        this.inputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addPassThroughRule(this.exaInput, this.innerExampleSource);
        this.getTransformer().addRule((MDTransformationRule)new ExampleSetPassThroughRule(this.exaInput, this.exaOutput, SetRelation.EQUAL){

            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.addAttribute(new AttributeMetaData("fitness", 4));
                return metaData;
            }
        });
        this.getTransformer().addRule((MDTransformationRule)new ExampleSetPassThroughRule(this.exaInput, this.optimizationHistory, SetRelation.EQUAL){

            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.addAttribute(new AttributeMetaData("fitness", 4));
                return metaData;
            }
        });
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addGenerationRule(this.perfOutput, PerformanceVector.class);
    }

    public void doWork() throws OperatorException {
        ExampleSet refExa = null;
        if (this.refInput.isConnected()) {
            refExa = (ExampleSet)this.refInput.getData(ExampleSet.class);
        } else {
            String startMethod = this.getParameterAsString(PARAMTER_INIT_START_VALUES);
            if (startMethod.equals("reference example") || startMethod.equals("average") || startMethod.equals("maximum") || startMethod.equals("minimum")) {
                throw new UserError((Operator)this, "prescriptive_analytics.RefExaMissing");
            }
        }
        ExampleSet optimizationSet = MaterializeDataInMemory.materializeExampleSet((ExampleSet)new MappedExampleSet((ExampleSet)this.exaInput.getData(ExampleSet.class), new int[]{0}));
        HashMap<String, HashMap<String, Double>> boundsMap = this.getHashConstraintsHashmap();
        ArrayList<String> attsToConsider = this.getAttributes();
        String optimizationMethod = this.getParameterAsString(PARAMETER_OPTIMIZATION_METHOD);
        SimpleOptimizerBuilder builder = null;
        switch (optimizationMethod) {
            case "BYOBA": {
                builder = new BYOBAOptimizerBuilder();
                int numberOfInterpolationPoints = this.getParameterAsBoolean(PARAMETER_USE_INTERPOLATION_POINTS_DEFAULT) ? attsToConsider.size() + 2 : this.getParameterAsInt(PARAMETER_NUMBER_INTERPOLATION_POINTS);
                builder = ((BYOBAOptimizerBuilder)builder).numberOfInterpolationPoints(numberOfInterpolationPoints).initialRadius(this.getParameterAsDouble(PARAMETER_INITIAL_RADIUS)).stoppingRadius(this.getParameterAsDouble(PARMETER_STOPPING_RADIUS)).maxEval(this.getParameterAsInt(PARAMETER_MAX_EVALUATIONS)).boundsmap(boundsMap);
                break;
            }
            case "Evolutionary Optimization": {
                builder = new ESOptimizerBuilder();
                RandomGenerator generator = RandomGenerator.getGlobalRandomGenerator();
                int seed = this.getProcess().getRootOperator().getParameterAsInt("random_seed");
                if (this.getParameterAsBoolean("use_local_random_seed")) {
                    seed = this.getParameterAsInt("local_random_seed");
                    generator = new RandomGenerator((long)seed);
                }
                int populationSize = attsToConsider.size();
                if (this.getParameterAsBoolean(PARAMETER_SPECIFIY_POPULATION_SIZE)) {
                    populationSize = this.getParameterAsInt(PARAMETER_POP_SIZE);
                }
                ((ESOptimizerBuilder)builder).maxGenerations(this.getParameterAsInt(PARAMETER_MAX_GENERATIONS)).populationSize(populationSize).selectionType(this.getParameterAsInt(PARAMETER_SELECTION_TYPE)).tournementFraction(this.getParameterAsDouble(PARAMETER_TOURNAMENT_FRACTION)).keepBest(this.getParameterAsBoolean(PARAMETER_KEEP_BEST)).mutationType(this.getParameterAsInt(PARAMETER_MUTATION_TYPE)).crossOverProb(this.getParameterAsDouble(PARAMETER_CROSSOVER_PROB)).showConvergencePlot(this.getParameterAsBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT)).generator(generator).boundsmap(boundsMap);
                break;
            }
            case "Grid": {
                builder = new GridOptimizerBuilder();
                builder = ((GridOptimizerBuilder)builder).steps(this.getParameterAsInt(PARAMETER_STEPS)).boundsmap(boundsMap);
                break;
            }
            case "CMA-ES": {
                int seed = this.getProcess().getRootOperator().getParameterAsInt("random_seed");
                if (this.getParameterAsBoolean("use_local_random_seed")) {
                    seed = this.getParameterAsInt("local_random_seed");
                }
                builder = new CMAESOptimizerAdapterBuilder();
                builder = ((CMAESOptimizerAdapterBuilder)builder).maxEval(this.getParameterAsInt(PARAMETER_MAX_EVALUATIONS)).sigma(this.getParameterAsDouble(PARAMETER_SIGMA)).popSize(this.getParameterAsInt(PARAMETER_POP_SIZE)).absoluteThreshold(this.getParameterAsDouble(PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD)).isActiveCMA(this.getParameterAsBoolean(PARAMETER_IS_ACTIVE_CMA)).numberOfDiagonalOnlyIterations(this.getParameterAsInt(PARAMETER_NUMBER_OF_DIAGONAL_ITERATIONS)).seed(seed).boundsmap(boundsMap);
                break;
            }
            case "Powell": {
                builder = new PowellOptimizerAdapterBuilder();
                builder = ((PowellOptimizerAdapterBuilder)builder).maxEval(this.getParameterAsInt(PARAMETER_MAX_EVALUATIONS)).absoluteThreshold(this.getParameterAsDouble(PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD)).relativeThreshold(this.getParameterAsDouble(PARAMETER_RELATIVE_STOPPING_TRHESHOLD));
            }
        }
        if (this.getParameterAsString(PARAMTER_INIT_START_VALUES).equals("input example")) {
            builder = builder.startExample(((ExampleSet)this.exaInput.getData(ExampleSet.class)).getExample(0));
        }
        if (this.getParameterAsString(PARAMTER_INIT_START_VALUES).equals("reference example")) {
            builder = builder.startExample(refExa.getExample(this.getParameterAsInt(PARAMETER_REFERENCE_INPUT_INDEX)));
        }
        builder = builder.refExa(refExa).attsToConsider(attsToConsider).EStoOptimize(optimizationSet).caller(this).numberOfCandidates(this.getParameterAsInt(PARAMETER_NUMBER_CANDIDATES)).startMethod(this.getParameterAsString(PARAMTER_INIT_START_VALUES));
        SimpleOptimizer optimizer = builder.build();
        optimizer.initializeStartingPoints();
        if (optimizer.isBounded()) {
            ((SimpleBoundsOptimizer)optimizer).checkBounds();
        }
        optimizer.optimize();
        this.perfOutput.deliver((IOObject)optimizer.bestPerformance);
        this.exaOutput.deliver((IOObject)optimizer.getCandidates());
        this.optimizationHistory.deliver((IOObject)optimizer.getOptimizationHistory());
    }

    public PerformanceVector evaluateSingleExample(ExampleSet es) throws OperatorException {
        this.innerExampleSource.deliver((IOObject)es);
        this.inputExtender.passDataThrough();
        super.doWork();
        PerformanceVector perf = (PerformanceVector)this.innerPerformanceOutput.getData(PerformanceVector.class);
        return perf;
    }

    private HashMap<String, HashMap<String, Double>> getHashConstraintsHashmap() throws UndefinedParameterError {
        boolean i = false;
        List atts = null;
        atts = this.getParameterList(PARAMETER_BOUNDS_CONFIG);
        HashMap<String, HashMap<String, Double>> boundsMap = new HashMap<String, HashMap<String, Double>>(atts.size());
        for (String[] values : atts) {
            String[] settings = ParameterTypeTupel.transformString2Tupel((String)values[1]);
            HashMap<String, Double> tuple = new HashMap<String, Double>(3);
            tuple.put("min", Double.parseDouble(settings[0]));
            tuple.put("max", Double.parseDouble(settings[1]));
            boundsMap.put(values[0], tuple);
        }
        return boundsMap;
    }

    public ArrayList<String> getAttributes() throws UserError {
        MappedExampleSet EStoOptimize = new MappedExampleSet((ExampleSet)this.exaInput.getData(ExampleSet.class), new int[]{0});
        ArrayList<String> attsToConsider = new ArrayList<String>();
        for (Attribute a : this.attributeSelector.getAttributeSubset((ExampleSet)EStoOptimize, false, true)) {
            attsToConsider.add(a.getName());
        }
        return attsToConsider;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        types.add(new ParameterTypeCategory(PARAMETER_OPTIMIZATION_METHOD, ".", optimizers, 0, false));
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_CANDIDATES, "number of candidate solutions", 1, Integer.MAX_VALUE, 1));
        for (ParameterType t : SimpleBoundsOptimizer.getParameters((Operator)this)) {
            this.setParameterDependencyOrAdd(t, types, BYOBAOptimizer.getName());
        }
        for (ParameterType t : BYOBAOptimizer.getParameters((Operator)this, true)) {
            this.setParameterDependencyOrAdd(t, types, BYOBAOptimizer.getName());
        }
        for (ParameterType t : ESOptimizer.getParameters((Operator)this, true)) {
            this.setParameterDependencyOrAdd(t, types, ESOptimizer.getName());
        }
        for (ParameterType t : GridOptimizer.getParameters((Operator)this, true)) {
            this.setParameterDependencyOrAdd(t, types, GridOptimizer.getName());
        }
        for (ParameterType t : CMAESOptimizerAdapter.getParameters((Operator)this, true)) {
            this.setParameterDependencyOrAdd(t, types, CMAESOptimizerAdapter.getName());
        }
        for (ParameterType t : PowellOptimizerAdapter.getParameters((Operator)this, true)) {
            this.setParameterDependencyOrAdd(t, types, PowellOptimizerAdapter.getName());
        }
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    private void setParameterDependencyOrAdd(ParameterType newParam, List<ParameterType> types, String method) {
        boolean isIn = false;
        for (ParameterType oldParam : types) {
            if (!oldParam.getKey().equals(newParam.getKey())) continue;
            for (ParameterCondition c : oldParam.getConditions()) {
                if (!(c instanceof ExtendableEqualStringCondition)) continue;
                ExtendableEqualStringCondition p = null;
                try {
                    p = (ExtendableEqualStringCondition)c;
                }
                catch (Exception e) {
                    this.getLog().log("cannot add " + method, 5);
                    e.printStackTrace();
                }
                p.addType(method);
            }
            isIn = true;
        }
        if (!isIn) {
            newParam.registerDependencyCondition((ParameterCondition)new ExtendableEqualStringCondition((ParameterHandler)this, PARAMETER_OPTIMIZATION_METHOD, false, method));
            types.add(newParam);
        }
    }
}

