/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.prescriptive.optimizer.BYOBAOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.SimpleBoundsOptimizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.BOBYQAOptimizer;

public class BYOBAOptimizer
extends SimpleBoundsOptimizer {
    public static final String PARAMETER_MAX_EVALUATIONS = "max_evaluations";
    public static final String PARAMETER_INITIAL_RADIUS = "initial_radius";
    public static final String PARMETER_STOPPING_RADIUS = "stopping_radius";
    public static final String PARAMETER_NUMBER_INTERPOLATION_POINTS = "number_of_interpolation_points";
    public static final String PARAMETER_USE_INTERPOLATION_POINTS_DEFAULT = "use_interpolation_points_default";
    BOBYQAOptimizer optim;
    int numberOfInterpolationPoints;
    double initialRadius;
    double stoppingRadius;
    int maxEval;

    public BYOBAOptimizer(BYOBAOptimizerBuilder byobaOptimizerBuilder) throws UserError {
        super(byobaOptimizerBuilder);
        this.numberOfInterpolationPoints = byobaOptimizerBuilder.numberOfInterpolationPoints;
        this.initialRadius = byobaOptimizerBuilder.initialRadius;
        this.stoppingRadius = byobaOptimizerBuilder.stoppingRadius;
        this.maxEval = byobaOptimizerBuilder.maxEval;
        this.optim = new BOBYQAOptimizer(this.numberOfInterpolationPoints, this.initialRadius, this.stoppingRadius);
    }

    @Override
    public void optimize() throws OperatorException {
        try {
            PointValuePair pointValuePair = this.optim.optimize(new OptimizationData[]{new MaxEval(this.maxEval), new ObjectiveFunction((MultivariateFunction)this), GoalType.MAXIMIZE, new SimpleBounds(this.minBounds, this.maxBounds), new InitialGuess(this.startingPoints)});
        }
        catch (RuntimeException e) {
            if (this.thrownUserError != null) {
                throw this.thrownUserError;
            }
            throw new OperatorException(e.getMessage());
        }
    }

    public static final List<ParameterType> getParameters(Operator parameterHandler, boolean withSuper) {
        List<ParameterType> types = withSuper ? SimpleBoundsOptimizer.getParameters(parameterHandler) : new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_USE_INTERPOLATION_POINTS_DEFAULT, "If activated a #Attributes+2 is used for number of interpolation points.", true, false));
        ParameterTypeInt pnip = new ParameterTypeInt(PARAMETER_NUMBER_INTERPOLATION_POINTS, "Number of Interpolation points. Should be in [n+2, (n+1)(n+2)/2]}. n is the number of variables.", 0, Integer.MAX_VALUE, 10);
        pnip.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)parameterHandler, PARAMETER_USE_INTERPOLATION_POINTS_DEFAULT, true, false));
        types.add((ParameterType)pnip);
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_MAX_EVALUATIONS, "Maximal Evaluations for the algorithm", 0, Integer.MAX_VALUE, 10000));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_INITIAL_RADIUS, "initial radius of the optimization algorithm", 0.0, Double.MAX_VALUE, 10.0));
        types.add((ParameterType)new ParameterTypeDouble(PARMETER_STOPPING_RADIUS, "Default Stopping Raidus radius of the optimization algorithm", 0.0, Double.MAX_VALUE, 1.0E-8));
        return types;
    }

    public static String getName() {
        return "BYOBA";
    }
}

