/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.prescriptive.optimizer.CMAESOptimizerAdapterBuilder;
import com.rapidminer.prescriptive.optimizer.SimpleBoundsOptimizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public class CMAESOptimizerAdapter
extends SimpleBoundsOptimizer
implements MultivariateFunction {
    public static final String PARAMETER_SIGMA = "sigma_factor";
    public static final String PARAMETER_POP_SIZE = "population_size";
    public static final String PARAMETER_MAX_EVAL = "max_evaluations";
    public static final String PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD = "stopping_threshold";
    public static final String PARAMETER_IS_ACTIVE_CMA = "active_cma";
    public static final String PARAMETER_NUMBER_OF_DIAGONAL_ITERATIONS = "number_of_diagonal_iterations";
    public static final String PARAMETER_RELATIVE_STOPPING_TRHESHOLD = "relative_stopping_threshold";
    CMAESOptimizer optim;
    private int maxEval;
    private int popSize;
    private double sigma;
    private double absoluteThreshold;
    private boolean isActiveCMA;
    private int numberOfDiagonalOnlyIterations;
    private int seed;

    public CMAESOptimizerAdapter(CMAESOptimizerAdapterBuilder builder) throws UserError {
        super(builder);
        this.maxEval = builder.maxEval;
        this.sigma = builder.sigma;
        this.popSize = builder.popSize;
        this.absoluteThreshold = builder.absoluteThreshold;
        this.isActiveCMA = builder.isActiveCMA;
        this.numberOfDiagonalOnlyIterations = builder.numberOfDiagonalOnlyIterations;
        this.seed = builder.seed;
        SimpleValueChecker convergenceChecker = new SimpleValueChecker(-1.0, this.absoluteThreshold);
        MersenneTwister mersenneTwister = null;
        mersenneTwister = this.seed != -1 ? new MersenneTwister(this.seed) : new MersenneTwister();
        this.optim = new CMAESOptimizer(this.maxEval, 0.0, this.isActiveCMA, this.numberOfDiagonalOnlyIterations, 0, (RandomGenerator)mersenneTwister, false, (ConvergenceChecker)convergenceChecker);
    }

    @Override
    public void optimize() throws OperatorException {
        try {
            PointValuePair pointValuePair = this.optim.optimize(new OptimizationData[]{new MaxEval(this.maxEval), new CMAESOptimizer.PopulationSize(this.popSize), new CMAESOptimizer.Sigma(this.getSigma()), new ObjectiveFunction((MultivariateFunction)this), GoalType.MAXIMIZE, new SimpleBounds(this.minBounds, this.maxBounds), new InitialGuess(this.startingPoints)});
        }
        catch (RuntimeException e) {
            if (this.thrownUserError != null) {
                throw this.thrownUserError;
            }
            throw new OperatorException(e.getMessage());
        }
    }

    public double[] getSigma() {
        double[] sigma = new double[this.minBounds.length];
        for (int i = 0; i < sigma.length; ++i) {
            sigma[i] = (this.maxBounds[i] - this.minBounds[i]) * this.sigma;
        }
        return sigma;
    }

    public static final List<ParameterType> getParameters(Operator parameterHandler, boolean withSuper) {
        List<ParameterType> types = withSuper ? SimpleBoundsOptimizer.getParameters(parameterHandler) : new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_MAX_EVAL, "maximal evaluations", 1, Integer.MAX_VALUE, 10000));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_SIGMA, "Intial variation for each variable. The set sigma is factor*(UpperBound-LowerBound) for each variable.", 0.0, 1.0, 1.0, false));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_POP_SIZE, PARAMETER_POP_SIZE, 1, Integer.MAX_VALUE, 5));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD, "Absolute threshold to stop", 0.0, Double.MAX_VALUE, 0.001));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_IS_ACTIVE_CMA, "Use Active CMA technique", true));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMBER_OF_DIAGONAL_ITERATIONS, "Number of iterations in the beginning, which only use the diagonal elements.", 0, Integer.MAX_VALUE, 0));
        return types;
    }

    public static String getName() {
        return "CMA-ES";
    }
}

