/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.prescriptive.optimizer.ESAdapter;
import com.rapidminer.prescriptive.optimizer.ESOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.SimpleBoundsOptimizer;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import java.util.ArrayList;
import java.util.List;

public class ESOptimizer
extends SimpleBoundsOptimizer {
    ESAdapter esOptimization;

    public ESOptimizer(ESOptimizerBuilder builder) throws UserError {
        super(builder);
        this.esOptimization = new ESAdapter(this, builder.populationSize, 5, builder.maxGenerations, builder.generationsWithoutImprovement, builder.selectionType, builder.tournementFraction, builder.keepBest, builder.mutationType, Double.NaN, builder.crossOverProb, builder.showConvergencePlot, builder.showPopulationPlot, builder.generator, this.getCaller().getLog());
    }

    @Override
    public void optimize() throws OperatorException {
        this.esOptimization.setStart(this.startingPoints);
        this.esOptimization.optimize();
    }

    public static final List<ParameterType> getParameters(Operator parameterHandler, boolean withSuper) {
        List<ParameterType> types = withSuper ? SimpleBoundsOptimizer.getParameters(parameterHandler) : new ArrayList<ParameterType>();
        types.addAll(ESOptimization.getParameterTypes((Operator)parameterHandler));
        return types;
    }

    public static String getName() {
        return "Evolutionary Optimization";
    }
}

