/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.prescriptive.optimizer.GridOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.SimpleBoundsOptimizer;
import java.util.ArrayList;
import java.util.List;

public class GridOptimizer
extends SimpleBoundsOptimizer {
    int steps;
    public static final String PARAMETER_STEPS = "steps";

    public GridOptimizer(GridOptimizerBuilder builder) throws UserError {
        super(builder);
        this.steps = builder.steps;
    }

    @Override
    public void optimize() throws OperatorException {
        double[] values = new double[this.attsToConsider.size()];
        for (int i = 0; i < this.steps + 1; ++i) {
            this.eval(0, values, i);
        }
    }

    public void eval(int attCounter, double[] values, int currentStep) throws OperatorException {
        double min = this.minBounds[attCounter];
        double max = this.maxBounds[attCounter];
        values[attCounter] = min + (max - min) * (double)currentStep / (double)this.steps;
        if (attCounter < this.attsToConsider.size() - 1) {
            for (int i = 0; i < this.steps + 1; ++i) {
                this.eval(attCounter + 1, values, i);
            }
        } else {
            PerformanceVector performanceVector = this.evaluateSingleExample(values);
        }
    }

    public static final List<ParameterType> getParameters(Operator parameterHandler, boolean withSuper) {
        List<ParameterType> types = withSuper ? SimpleBoundsOptimizer.getParameters(parameterHandler) : new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_STEPS, "Number of Steps", 1, Integer.MAX_VALUE, 5));
        return types;
    }

    public static String getName() {
        return "Grid";
    }
}

