/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.prescriptive.optimizer.PowellOptimizerAdapterBuilder;
import com.rapidminer.prescriptive.optimizer.UnboundedOptimizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.PowellOptimizer;

public class PowellOptimizerAdapter
extends UnboundedOptimizer
implements MultivariateFunction {
    private PowellOptimizer powell;
    private int maxEval;
    private double relThreshold;
    private double absThreshold;
    public static final String PARAMETER_MAX_EVALUATIONS = "max_evaluations";
    public static final String PARAMETER_RELATIVE_STOPPING_TRHESHOLD = "relative_stopping_threshold";
    public static final String PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD = "stopping_threshold";

    public PowellOptimizerAdapter(PowellOptimizerAdapterBuilder builder) {
        super(builder);
        this.relThreshold = builder.relativeThreshold;
        this.absThreshold = builder.absoluteThreshold;
        this.maxEval = builder.maxEval;
        this.powell = new PowellOptimizer(this.relThreshold, this.absThreshold);
    }

    @Override
    public void optimize() throws OperatorException {
        try {
            PointValuePair pointValuePair = this.powell.optimize(new OptimizationData[]{new MaxEval(this.maxEval), new ObjectiveFunction((MultivariateFunction)this), GoalType.MAXIMIZE, new InitialGuess(this.startingPoints)});
        }
        catch (RuntimeException e) {
            if (this.thrownUserError != null) {
                throw this.thrownUserError;
            }
            throw new OperatorException(e.getMessage());
        }
    }

    public static List<ParameterType> getParameters(Operator handler, boolean includeSuper) {
        List<ParameterType> types = includeSuper ? UnboundedOptimizer.getParameters(handler, includeSuper) : new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_MAX_EVALUATIONS, PARAMETER_MAX_EVALUATIONS, 1, Integer.MAX_VALUE));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD, PARAMETER_ABSOLUTE_STOPPING_TRHESHOLD, 0.0, Double.MAX_VALUE, 0.0));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_RELATIVE_STOPPING_TRHESHOLD, PARAMETER_RELATIVE_STOPPING_TRHESHOLD, 0.0, Double.MAX_VALUE, 0.001));
        return types;
    }

    public static String getName() {
        return "Powell";
    }
}

