/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.prescriptive.optimizer.SimpleBoundsOptimizerBuilder;
import com.rapidminer.prescriptive.optimizer.SimpleOptimizer;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class SimpleBoundsOptimizer
extends SimpleOptimizer {
    public static final String PARAMETER_ATT_NAME = "attribute_name";
    public static final String PARAMETER_BOUNDS_CONFIG_MIN = "bounds_min";
    public static final String PARAMETER_BOUNDS_CONFIG_MAX = "bounds_max";
    public static final String PARAMETER_BOUNDS_CONFIG = "configure_bounds";
    protected double[] minBounds;
    protected double[] maxBounds;
    protected HashMap<String, HashMap<String, Double>> boundsMap;

    public SimpleBoundsOptimizer(SimpleBoundsOptimizerBuilder builder) throws UserError {
        super(builder);
        this.boundsMap = builder.boundsmap;
        this.initBounds(this.refExa);
    }

    public void initBounds(ExampleSet refExa) throws UserError {
        this.minBounds = new double[this.attsToConsider.size()];
        this.maxBounds = new double[this.attsToConsider.size()];
        ArrayList<String> refAtts = new ArrayList<String>();
        if (refExa != null) {
            refExa.recalculateAllAttributeStatistics();
            for (Attribute a : refExa.getAttributes()) {
                refAtts.add(a.getName());
            }
        }
        int i = 0;
        for (String attName : this.attsToConsider) {
            if (this.boundsMap.containsKey(attName)) {
                this.minBounds[i] = this.boundsMap.get(attName).get("min");
                this.maxBounds[i] = this.boundsMap.get(attName).get("max");
            } else if (refExa != null && refAtts.contains(attName)) {
                Attribute a = refExa.getAttributes().get(attName);
                this.minBounds[i] = refExa.getStatistics(a, "minimum");
                this.maxBounds[i] = refExa.getStatistics(a, "maximum");
                this.caller.getLog().log(this.startMethod);
            } else {
                throw new UserError((Operator)this.getCaller(), "prescriptive_analytics.NoBoundsSet", new Object[]{attName});
            }
            ++i;
        }
    }

    @Override
    public void setRandomStartingPoints() throws OperatorException {
        if (this.minBounds == null || this.maxBounds == null) {
            throw new OperatorException("Trying to set random startvalues in SimpleBoundsOptimizer while bounds are not set");
        }
        for (int i = 0; i < this.minBounds.length; ++i) {
            RandomGenerator rnd = RandomGenerator.getGlobalRandomGenerator();
            if (!this.startMethod.equals("random")) continue;
            this.startingPoints[i] = this.minBounds[i] + rnd.nextDouble() * (this.maxBounds[i] - this.minBounds[i]);
        }
    }

    public void checkBounds() throws UserError {
        for (String key : this.boundsMap.keySet()) {
            if (!(this.boundsMap.get(key).get("min") > this.boundsMap.get(key).get("max"))) continue;
            throw new UserError((Operator)this.caller, "prescriptive_analytics.MinMaxBounds", new Object[]{key});
        }
        for (int i = 0; i < this.startingPoints.length; ++i) {
            if (this.startingPoints[i] < this.minBounds[i]) {
                throw new UserError((Operator)this.caller, "prescriptive_analytics.ValueTooSmall", new Object[]{this.attsToConsider.get(i)});
            }
            if (!(this.startingPoints[i] > this.maxBounds[i])) continue;
            throw new UserError((Operator)this.caller, "prescriptive_analytics.ValueTooBig", new Object[]{this.attsToConsider.get(i)});
        }
    }

    private void setConstraintsHashMap(HashMap<String, HashMap<String, Double>> map) throws UndefinedParameterError {
        this.boundsMap = map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bound Optimizer with these bounds: \n");
        for (int i = 0; i < this.minBounds.length; ++i) {
            sb.append((String)this.attsToConsider.get(i) + ":\t");
            sb.append("Min: " + this.minBounds[i] + " ");
            sb.append("Max: " + this.maxBounds[i] + " ");
            if (this.startingPoints != null) {
                sb.append("Start: " + this.startingPoints[i] + " ");
            }
            sb.append("\n");
        }
        sb.append("StartingMethod: " + this.startMethod + "\n");
        return sb.toString();
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    public static List<ParameterType> getParameters(Operator parameterHandler) {
        List<ParameterType> types = SimpleOptimizer.getParameters(parameterHandler);
        ParameterTypeList advancedParameters = new ParameterTypeList(PARAMETER_BOUNDS_CONFIG, "Advanced parameters that can be set.", (ParameterType)new ParameterTypeAttribute(PARAMETER_ATT_NAME, PARAMETER_ATT_NAME, (InputPort)parameterHandler.getInputPorts().getPortByName("example set input"), new int[]{2}), (ParameterType)new ParameterTypeTupel("values (Min, Max)", "(Min,Max)", new ParameterType[]{new ParameterTypeDouble(PARAMETER_BOUNDS_CONFIG_MIN, PARAMETER_BOUNDS_CONFIG_MIN, -1.7976931348623157E308, Double.MAX_VALUE, true), new ParameterTypeDouble(PARAMETER_BOUNDS_CONFIG_MAX, PARAMETER_BOUNDS_CONFIG_MAX, -1.7976931348623157E308, Double.MAX_VALUE, true)}));
        advancedParameters.setOptional(true);
        types.add((ParameterType)advancedParameters);
        return types;
    }

    public static String getName() {
        return "Simple Bounds";
    }
}

