/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.prescriptive.optimizer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.preprocessing.MaterializeDataInMemory;
import com.rapidminer.operator.preprocessing.join.ExampleSetMerge;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.prescriptive.operator.OptimizationOperator;
import com.rapidminer.prescriptive.optimizer.SimpleOptimizerBuilder;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;

public abstract class SimpleOptimizer
implements MultivariateFunction {
    public static final String PARAMTER_INIT_START_VALUES = "method_for_start_values";
    public static final String PARAMETER_REFERENCE_INPUT_INDEX = "reference_example_index";
    public static String[] startMethods = new String[]{"input example", "reference example", "random", "average", "minimum", "maximum"};
    public String startMethod;
    protected ExampleSet refExa;
    public OptimizationOperator caller;
    public ExampleSet EStoOptimize;
    protected Example startExample;
    public List<String> attsToConsider;
    public PerformanceVector bestPerformance;
    protected ExampleSet bestES;
    protected List<Tuple> topEs;
    protected List<Tuple> completeOptimizationHistory;
    protected double minimalfitness;
    protected double[] startingPoints;
    private boolean startingPointsAreSet = false;
    protected UserError thrownUserError = null;
    private int numberOfCandidates;

    public SimpleOptimizer(SimpleOptimizerBuilder builder) {
        this.refExa = builder.refExa;
        this.caller = builder.caller;
        this.EStoOptimize = builder.EStoOptimize;
        this.startExample = builder.startExample;
        this.attsToConsider = builder.attsToConsider;
        this.startMethod = builder.startMethod;
        this.numberOfCandidates = builder.numberOfCandidates;
        this.topEs = new ArrayList<Tuple>(5);
        this.completeOptimizationHistory = new ArrayList<Tuple>();
    }

    public void optimize() throws OperatorException {
        throw new OperatorException("trying to call optimize of SimpleOptimizer, which is just an interface.");
    }

    public PerformanceVector evaluateSingleExample(double[] values) throws OperatorException {
        Example e = this.EStoOptimize.getExample(0);
        int counter = 0;
        for (double v : values) {
            e.setValue(e.getAttributes().get(this.attsToConsider.get(counter)), v);
            ++counter;
        }
        PerformanceVector perf = this.caller.evaluateSingleExample(this.EStoOptimize);
        if (this.bestPerformance == null) {
            this.bestPerformance = perf;
            this.minimalfitness = perf.getMainCriterion().getFitness();
            this.bestES = MaterializeDataInMemory.materializeExampleSet((ExampleSet)this.EStoOptimize);
        } else if (perf.getMainCriterion().getFitness() > this.bestPerformance.getMainCriterion().getFitness()) {
            this.bestPerformance = perf;
            this.bestES = MaterializeDataInMemory.materializeExampleSet((ExampleSet)this.EStoOptimize);
        }
        this.completeOptimizationHistory.add(new Tuple(MaterializeDataInMemory.materializeExampleSet((ExampleSet)this.EStoOptimize), perf));
        if (perf.getMainCriterion().getFitness() >= this.minimalfitness) {
            this.topEs.add(new Tuple(MaterializeDataInMemory.materializeExampleSet((ExampleSet)this.EStoOptimize), perf));
            Collections.sort(this.topEs);
            if (this.topEs.size() > this.numberOfCandidates) {
                this.topEs.remove(0);
            }
            this.minimalfitness = this.topEs.get((int)0).perf.getMainCriterion().getFitness();
        }
        for (Tuple t : this.topEs) {
            this.caller.getLog().log(Double.toString(t.perf.getMainCriterion().getFitness()), 5);
        }
        return perf;
    }

    public ExampleSet getCandidates() throws OperatorException {
        return this.tupleToExampleSet(this.topEs);
    }

    public ExampleSet getOptimizationHistory() throws OperatorException {
        return this.tupleToExampleSet(this.completeOptimizationHistory);
    }

    private ExampleSet tupleToExampleSet(List<Tuple> exampleSetPerformanceTuple) throws OperatorException {
        ExampleSetMerge merger = new ExampleSetMerge(this.caller.getOperatorDescription());
        ArrayList<ExampleSet> es = new ArrayList<ExampleSet>();
        for (Tuple t : exampleSetPerformanceTuple) {
            es.add(t.es);
        }
        ExampleSet resultSet = merger.merge(es);
        Attribute fitnessatt = AttributeFactory.createAttribute((String)"fitness", (int)4);
        resultSet.getExampleTable().addAttribute(fitnessatt);
        resultSet.getAttributes().addRegular(fitnessatt);
        int i = 0;
        for (Tuple t : exampleSetPerformanceTuple) {
            resultSet.getExample(i).setValue(fitnessatt, t.perf.getMainCriterion().getAverage());
            ++i;
        }
        return resultSet;
    }

    public void initializeStartingPoints() throws OperatorException {
        this.caller.getLog().log(this.startMethod, 5);
        this.startingPoints = new double[this.attsToConsider.size()];
        if (this.startMethod.equals("average") || this.startMethod.equals("maximum") || this.startMethod.equals("minimum")) {
            this.caller.getLog().log("starting to set from reference", 5);
            this.setStartingPointFromReference();
        }
        if (this.startMethod.equals("random")) {
            this.setRandomStartingPoints();
        }
        if (this.startMethod.equals("input example") || this.startMethod.equals("reference example")) {
            if (this.startExample == null) {
                throw new OperatorException("Tried to initialize input example which does not exist");
            }
            this.setStartingPointfromExample(this.startExample);
        }
    }

    public double value(double[] point) {
        PerformanceVector myPerf = null;
        PerformanceVector bestPerformance = null;
        try {
            myPerf = this.evaluateSingleExample(point);
        }
        catch (UserError e) {
            this.thrownUserError = e;
        }
        catch (OperatorException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (bestPerformance == null) {
            bestPerformance = myPerf;
        } else if (myPerf.compareTo((Object)bestPerformance) == 1) {
            this.caller.getLog().log("New Best Performance: " + Double.toString(bestPerformance.getMainCriterion().getFitness()));
        }
        return myPerf.getMainCriterion().getFitness();
    }

    protected void setRandomStartingPoints() throws OperatorException {
        for (int i = 0; i < this.startingPoints.length; ++i) {
            this.startingPoints[i] = RandomGenerator.getGlobalRandomGenerator().nextDouble();
        }
    }

    protected void setStartingPointFromReference() throws OperatorException {
        if (this.refExa == null) {
            throw new OperatorException("Tried to set start values from non-existing reference");
        }
        this.refExa.recalculateAllAttributeStatistics();
        int i = 0;
        for (String aName : this.attsToConsider) {
            Attribute a = this.refExa.getAttributes().get(aName);
            this.startingPoints[i] = this.refExa.getStatistics(a, this.startMethod);
            this.getCaller().getLog().log(Double.toString(this.startingPoints[i]), 5);
            ++i;
        }
    }

    protected void setZeroStartingPoints() {
        for (int i = 0; i < this.attsToConsider.size(); ++i) {
            this.startingPoints[i] = 0.0;
        }
    }

    protected void setStartingPointfromExample(Example e) {
        this.startingPoints = this.exampleToArray(e);
        this.startingPointsAreSet = true;
    }

    public void setStartingExample(Example e) {
        this.startExample = e;
    }

    public void setNumberOfCandidates(int numberOfCandidates) {
        this.numberOfCandidates = numberOfCandidates;
    }

    private double[] exampleToArray(Example e) {
        double[] values = new double[this.attsToConsider.size()];
        int i = 0;
        for (String aName : this.attsToConsider) {
            values[i] = e.getValue(e.getAttributes().get(aName));
            ++i;
        }
        return values;
    }

    public static List<ParameterType> getParameters(Operator parameterHandler) {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeCategory(PARAMTER_INIT_START_VALUES, ".", startMethods, 0, false));
        ParameterTypeInt t = new ParameterTypeInt(PARAMETER_REFERENCE_INPUT_INDEX, "Which example of the reference set should be used as start value", 0, Integer.MAX_VALUE, 0, false);
        t.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)parameterHandler, PARAMTER_INIT_START_VALUES, true, new String[]{"reference example"}));
        types.add((ParameterType)t);
        return types;
    }

    public OptimizationOperator getCaller() {
        return this.caller;
    }

    public static String getName() {
        return "Simple Optimizer";
    }

    public abstract boolean isBounded();

    public class Tuple
    implements Comparable {
        public final ExampleSet es;
        public final PerformanceVector perf;

        public Tuple(ExampleSet es, PerformanceVector p) {
            this.es = es;
            this.perf = p;
        }

        public int compareTo(Object o) {
            Tuple p2 = (Tuple)o;
            if (p2.perf.getMainCriterion().getFitness() > this.perf.getMainCriterion().getFitness()) {
                return -1;
            }
            return 1;
        }
    }
}

