/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension;

import com.rapidminer.RapidMiner;
import com.rapidminer.connection.ConnectionHandlerRegistry;
import com.rapidminer.connection.gui.ConnectionGUIProvider;
import com.rapidminer.connection.gui.ConnectionGUIRegistry;
import com.rapidminer.connection.util.GenericHandler;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.actions.ExtractIntoSubprocessAction;
import com.rapidminer.extension.processdefined.actions.OpenInnerProcessAction;
import com.rapidminer.extension.processdefined.cloud.CloudActionRegistration;
import com.rapidminer.extension.processdefined.cloud.MetadataResolverRegistration;
import com.rapidminer.extension.processdefined.dictionary.connection.DictionaryHandler;
import com.rapidminer.extension.processdefined.dictionary.connection.gui.DictionaryGUIProvider;
import com.rapidminer.extension.processdefined.operator.OpenableCustomOperator;
import com.rapidminer.extension.processdefined.parameter.EnumerationAndRefreshValueCellEditor;
import com.rapidminer.extension.processdefined.parameter.ParameterTypeEnumerationAndRefresh;
import com.rapidminer.extension.professional.PluginInitProfessional;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.actions.OperatorActionContext;
import com.rapidminer.gui.actions.OperatorActionFactory;
import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.GUIProcessXMLFilter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.license.LicenseManagerRegistry;
import com.rapidminer.license.verification.JarVerifier;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class PluginInitProcessDefinedOperators {
    public static final String EXTENSION_ID = "process_defined_operators";
    public static final String FULL_EXTENSION_ID = "rmx_process_defined_operators";
    public static final String PARAMETER_CACHE_SIZE = "rapidminer.custom_operators.cache_size";
    public static final ThreadLocal<Boolean> PROCESS_WITHOUT_GUI_SWITCH;
    private static final VersionNumber MINIMUM_DATA_STRUCTURE_VERSION;
    public static final String CUSTOM_OPERATOR_CREATOR_EXTENSION_KEY = "rmx_custom_operator_creator";
    private static boolean dataStructurePresent;

    private PluginInitProcessDefinedOperators() {
    }

    public static void initPlugin() {
        ConnectionHandlerRegistry.getInstance().registerHandler((GenericHandler)DictionaryHandler.INSTANCE);
        ParameterService.registerParameter((ParameterType)new ParameterTypeInt(PARAMETER_CACHE_SIZE, "", 0, Integer.MAX_VALUE, 20));
        PluginInitProcessDefinedOperators.checkAndRegisterDataStructure();
        ProcessDefinedOperators.addStartupHook();
        if (RapidMiner.getVersion().isAbove(new VersionNumber(200, 6, 0))) {
            MetadataResolverRegistration.register();
        }
        if (RapidMiner.getVersion().isAbove(new VersionNumber(211, 1, 0))) {
            CloudActionRegistration.register();
        }
        if (Plugin.getPluginByExtensionId((String)CUSTOM_OPERATOR_CREATOR_EXTENSION_KEY) == null && (RapidMiner.getVersion().isAbove(new VersionNumber(11, 1, 1)) && !RapidMiner.getVersion().isAbove(new VersionNumber(200, 0, 0)) || RapidMiner.getVersion().isAbove(new VersionNumber(211, 0, 99)))) {
            try {
                Class<?> categoryManager = Class.forName("com.rapidminer.operator.categorization.CategoryManager");
                Method addMethod = categoryManager.getMethod("addOperatorToCategory", String.class, String.class);
                Plugin thisPlugin = Plugin.getPluginByExtensionId((String)FULL_EXTENSION_ID);
                String pluginResourceOperators = thisPlugin.getPluginResourceOperators();
                try (InputStream operatorsXMLStream = thisPlugin.getClassLoader().getResourceAsStream(pluginResourceOperators);){
                    Document parsed = XMLTools.parse((InputStream)operatorsXMLStream);
                    NodeList keys = parsed.getElementsByTagName("key");
                    for (int i = 0; i < keys.getLength(); ++i) {
                        String opKey = keys.item(i).getTextContent().trim();
                        addMethod.invoke(null, "process_defined_operators:" + opKey, "hidden");
                    }
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.FINER, "Could not hide operators", e);
            }
        }
    }

    public static void initGui(MainFrame mainframe) {
        if (Plugin.getPluginByExtensionId((String)CUSTOM_OPERATOR_CREATOR_EXTENSION_KEY) == null) {
            ResourceAction installAction = SwingTools.createMarketplaceDownloadActionForNamespace((String)"process_defined_operators.install_creator", (String)CUSTOM_OPERATOR_CREATOR_EXTENSION_KEY.replace("rmx_", ""));
            mainframe.getFileMenu().add((Action)installAction);
            mainframe.getExtensionsMenu().add((Action)installAction);
        }
        ConnectionGUIRegistry.INSTANCE.registerGUIProvider((ConnectionGUIProvider)new DictionaryGUIProvider(), DictionaryHandler.INSTANCE.getType());
        Actions actions = mainframe.getActions();
        final OpenInnerProcessAction openInnerProcessAction = new OpenInnerProcessAction(actions);
        final ExtractIntoSubprocessAction extractIntoSubprocessAction = new ExtractIntoSubprocessAction(actions);
        actions.register(new OperatorActionFactory(){
            private final OperatorActionFactory.ResourceEntry openProcess;
            private final OperatorActionFactory.ResourceEntry extractProcess;
            {
                this.openProcess = new OperatorActionFactory.ResourceEntry(openInnerProcessAction);
                this.extractProcess = new OperatorActionFactory.ResourceEntry(extractIntoSubprocessAction);
            }

            public List<OperatorActionFactory.ResourceEntry> create(OperatorActionContext context) {
                List selectedOperators = context.getOperators();
                if (selectedOperators.size() != 1) {
                    return Collections.emptyList();
                }
                if (selectedOperators.get(0) instanceof OpenableCustomOperator && !((OpenableCustomOperator)selectedOperators.get(0)).isHidden()) {
                    return Arrays.asList(this.openProcess, this.extractProcess);
                }
                return Collections.emptyList();
            }
        });
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeEnumerationAndRefresh.class, EnumerationAndRefreshValueCellEditor.class);
    }

    public static void initFinalChecks() {
    }

    public static void initPluginManager() {
    }

    public static boolean checkAndRegisterDataStructure() {
        Plugin processDefined;
        Plugin dataStructurePlugin = Plugin.getPluginByExtensionId((String)"rmx_data_structure");
        if (dataStructurePlugin != null && new VersionNumber(dataStructurePlugin.getVersion()).isAtLeast(MINIMUM_DATA_STRUCTURE_VERSION) && (processDefined = Plugin.getPluginForClass(PluginInitProcessDefinedOperators.class)) != null) {
            processDefined.getClassLoader().addDependency(dataStructurePlugin);
            dataStructurePresent = true;
        }
        return dataStructurePresent;
    }

    public static boolean isDataStructurePresent() {
        return dataStructurePresent;
    }

    static {
        MINIMUM_DATA_STRUCTURE_VERSION = new VersionNumber(0, 5, 999);
        dataStructurePresent = false;
        try {
            JarVerifier.verify((Class[])new Class[]{LicenseManagerRegistry.INSTANCE.get().getClass(), RapidMiner.class, PluginInitProfessional.class, PluginInitProcessDefinedOperators.class});
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        ThreadLocal ignoreSwitch = null;
        try {
            Object ignoreFilters = GUIProcessXMLFilter.class.getDeclaredField("IGNORE_FILTERS").get(null);
            if (ignoreFilters instanceof ThreadLocal) {
                ignoreSwitch = (ThreadLocal)ignoreFilters;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        PROCESS_WITHOUT_GUI_SWITCH = ignoreSwitch;
    }
}

