/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined;

import com.rapidminer.Process;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.processdefined.operator.CustomSubprocess;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.extension.processdefined.util.DocuInfos;
import com.rapidminer.extension.processdefined.util.PortInfo;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.extension.processdefined.util.SubprocessInfo;
import com.rapidminer.extension.processdefined.util.TutorialInfo;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLExporter;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.container.Pair;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CustomOperatorTemplate {
    private static final String TITLE = "title";
    private static final String ICON = "icon";
    private static final String DESCRIPTION = "description";
    private static final String SYNOPSIS = "synopsis";
    private static final String CUSTOM_OPERATOR_TYPE = "custom-operator-type";
    private static final String INPUT_PORT_SCHEMA_MAP = "input-port-schema-map";
    private static final String INPUT_PORT_SCHEMA = "input-port-schema";
    private static final String INPUT_PORT_NAME = "input-port-name";
    private static final String SCHEMA_LOCATION = "schema-location";
    private static final String OUTPUT_PORT_VIS_CONFIG_MAP = "output-port-vis-config-map";
    private static final String OUTPUT_PORT_VIS_CONFIG = "output-port-vis-config";
    private static final String OUTPUT_PORT_NAME = "output-port-name";
    private static final String VIS_CONFIG_LOCATION = "vis-config-location";
    private static final String DEFINES_OPTIONALS = "defines-optionals";
    private static final String NO_RECURSION = "no-recursion";
    private static final String PARAM_ORDERING = "param-ordering";
    private static final String TEMPLATE_PARAMETER = "template-parameter";
    private static final String OPERATOR = "operator";
    private static final String PARAMETER = "parameter";
    private static final String ALIAS = "alias";
    private static final String DOCUMENTATION = "documentation";
    private static final String OPTIONAL = "optional";
    private static final String EXPERT = "expert";
    private static final String DEPENDENCY = "dependency";
    private static final String PARAMETER_ALIAS = "parameter-alias";
    private static final String PARAMETER_VALUE = "parameter-value";
    private static final String PROCESS_INPUTS = "number-of-inputs";
    private static final String PROCESS_OUTPUTS = "number-of-outputs";
    private static final String INPUT_PORT_NAMES = "input-port-names";
    private static final String OUTPUT_PORT_NAMES = "output-port-names";
    private static final String INPUT_DOCU = "input-docu";
    private static final String OUTPUT_DOCU = "output-docu";
    private static final String PORT = "port";
    private static final String TYPE = "type";
    private static final String TUTORIAL = "tutorial";
    private static final String SUBPROCESS = "subprocess";
    private static final String TUTORIAL_XML = "xml";
    private static final String NAME = "name";
    private static final String NEW_RANDOM_SEED = "gets-random-seed";
    private static final String TUTORIAL_LOCATION = "location";
    private static final String COLOR = "color";
    private static final String TAGS = "tags";
    private String name = "unnamed";
    private String synopsis;
    private String description = "none";
    private String icon = "painters_palette.png";
    private Set<CustomParameterInfo> parameters = new TreeSet<CustomParameterInfo>();
    private CustomModuleUtils.CustomOperatorType customOperatorType = CustomModuleUtils.CustomOperatorType.STANDARD;
    private Map<String, String> inputPortSchemaMap = new LinkedHashMap<String, String>();
    private Map<String, String> outputPortVisConfigMap = new LinkedHashMap<String, String>();
    private DocuInfos docuInfos = new DocuInfos(new ArrayList<PortInfo>(), new ArrayList<PortInfo>(), new ArrayList<TutorialInfo>(), new ArrayList<String>());
    private final List<SubprocessInfo> subprocessInfos = new ArrayList<SubprocessInfo>();
    private String templateDefinition;
    private boolean definesOptionals = true;
    private boolean noRecursion = false;
    private boolean getsRandomSeed = false;
    private int numberOfInputs = -1;
    private int numberOfOutputs = -1;
    private List<String> inputPortNames = Collections.emptyList();
    private List<String> outputPortNames = Collections.emptyList();
    private String color;

    public CustomOperatorTemplate(String name, String icon, String color, String synopsis, String description, Set<CustomParameterInfo> parameters, DocuInfos docuInfos, List<String> inputPortNames, List<String> outputPortNames) {
        this.name = name;
        this.synopsis = synopsis;
        this.description = description;
        this.parameters = parameters;
        this.icon = icon;
        this.color = color;
        this.docuInfos = docuInfos;
        this.inputPortNames = inputPortNames;
        this.outputPortNames = outputPortNames;
    }

    public CustomOperatorTemplate(String name, String icon, String color, String synopsis, String description, CustomModuleUtils.CustomOperatorType customOperatorType, Map<String, String> inputPortSchemaMap, Map<String, String> outputPortVisConfigMap, Set<CustomParameterInfo> parameters, DocuInfos docuInfos, List<String> inputPortNames, List<String> outputPortNames) {
        this(name, icon, color, synopsis, description, parameters, docuInfos, inputPortNames, outputPortNames);
        this.customOperatorType = customOperatorType;
        this.inputPortSchemaMap = inputPortSchemaMap;
        this.outputPortVisConfigMap = outputPortVisConfigMap;
    }

    public CustomOperatorTemplate(InputStream ins) throws IOException, SAXException {
        if (!ins.markSupported()) {
            ins = new BufferedInputStream(ins);
        }
        this.parse(ins);
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSynopsis() {
        if (this.synopsis == null) {
            return "";
        }
        return this.synopsis;
    }

    public CustomModuleUtils.CustomOperatorType getCustomOperatorType() {
        return this.customOperatorType;
    }

    public Map<String, String> getInputPortSchemaMap() {
        return this.inputPortSchemaMap;
    }

    public Map<String, String> getOutputPortVisConfigMap() {
        return this.outputPortVisConfigMap;
    }

    public Collection<CustomParameterInfo> getParameters() {
        return this.parameters;
    }

    public void saveAsCustomOperator(Process process, String saveLocation) throws IOException, XMLException {
        String targetLocation;
        String name = this.getName();
        if (!Tools.canFileBeStoredOnCurrentFilesystem((String)(name = CustomOperatorTemplate.makeFileName(name)))) {
            SwingTools.showVerySimpleErrorMessage((String)"name_contains_illegal_chars", (Object[])new Object[]{name});
            return;
        }
        String originalName = null;
        if (saveLocation == null) {
            targetLocation = RepositoryLocationChooser.selectLocation(null, null, (Component)RapidMinerGUI.getMainFrame(), (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true, RepositoryUtils.FILESYSTEM_REPOS_FILTER, (String)"custom_operators.export_process_operator");
            if (StringUtils.trimToNull((String)targetLocation) == null) {
                return;
            }
        } else {
            int splitIndex = saveLocation.lastIndexOf(47);
            targetLocation = saveLocation.substring(0, splitIndex);
            originalName = saveLocation.substring(splitIndex + 1).replace(".cusop", "");
        }
        if ((targetLocation = CustomOperatorTemplate.checkTargetFolder(targetLocation)) == null) {
            return;
        }
        if (!name.equals(originalName) && (targetLocation = CustomOperatorTemplate.checkCusopFile(targetLocation, name)) == null) {
            return;
        }
        File cusopFile = new File(RepositoryUtils.locationToFolderPath(targetLocation).toFile(), name + ".cusop");
        Document doc = this.getTemplateXML(process, true);
        XMLTools.stream((Document)doc, (File)cusopFile, (Charset)XMLImporter.PROCESS_FILE_CHARSET);
        RepositoryUtils.refreshFolder(targetLocation);
    }

    public void writeWithoutDoku(Path path) throws IOException, XMLException {
        Document doc = this.getTemplateXML(this.getProcess(), false);
        XMLTools.stream((Document)doc, (File)path.toFile(), (Charset)XMLImporter.PROCESS_FILE_CHARSET);
    }

    private static String checkTargetFolder(String targetLocation) {
        while (RepositoryUtils.locationToFolderPath(targetLocation) == null) {
            int res = SwingTools.showConfirmDialog((String)"custom_operator.folder_failed", (int)0, (Object[])new Object[]{targetLocation});
            if (res == 0) {
                targetLocation = RepositoryLocationChooser.selectLocation(null, null, (Component)RapidMinerGUI.getMainFrame(), (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true, RepositoryUtils.FILESYSTEM_REPOS_FILTER, (String)"custom_operators.export_process_operator");
                if (StringUtils.trimToNull((String)targetLocation) != null) continue;
                return null;
            }
            return null;
        }
        return targetLocation;
    }

    private void parse(InputStream ins) throws IOException, SAXException {
        String tags;
        String newParameterOrdering;
        String newRandomSeedDefined;
        String noRecursionDefined;
        String optionalsDefined;
        String parsedOutputs;
        this.templateDefinition = Tools.readTextFile((InputStream)ins);
        Document doc = XMLTools.parse((InputStream)new ByteArrayInputStream(this.templateDefinition.getBytes(XMLImporter.PROCESS_FILE_CHARSET)));
        this.name = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)TITLE);
        this.icon = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)ICON);
        this.color = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)COLOR);
        this.description = StringEscapeUtils.unescapeHtml4((String)XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)DESCRIPTION));
        this.synopsis = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)SYNOPSIS);
        String parsedInputs = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)PROCESS_INPUTS);
        if (parsedInputs != null) {
            try {
                this.numberOfInputs = Integer.parseInt(parsedInputs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((parsedOutputs = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)PROCESS_OUTPUTS)) != null) {
            try {
                this.numberOfOutputs = Integer.parseInt(parsedOutputs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!"true".equals(optionalsDefined = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)DEFINES_OPTIONALS))) {
            this.definesOptionals = false;
        }
        if ("true".equals(noRecursionDefined = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)NO_RECURSION))) {
            this.noRecursion = true;
        }
        if ("true".equals(newRandomSeedDefined = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)NEW_RANDOM_SEED))) {
            this.getsRandomSeed = true;
        }
        if (Boolean.parseBoolean(newParameterOrdering = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)PARAM_ORDERING))) {
            this.parameters = new LinkedHashSet<CustomParameterInfo>();
        }
        if ((tags = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)TAGS)) != null) {
            List tagList = ParameterTypeEnumeration.transformString2List((String)tags);
            this.docuInfos.getTags().addAll(tagList);
        }
        this.readParameters(doc);
        this.readDataStructureFields(doc);
        this.readSubprocesses(doc);
        this.readPortsDocu(doc, true);
        this.readPortsDocu(doc, false);
        this.readTutorials(doc);
        this.readPortNames(doc, true);
        this.readPortNames(doc, false);
    }

    private void readParameters(Document doc) {
        NodeList freeParameterElements = doc.getDocumentElement().getElementsByTagName(TEMPLATE_PARAMETER);
        for (int i = 0; i < freeParameterElements.getLength(); ++i) {
            Element freeParameterElement = (Element)freeParameterElements.item(i);
            String operator = XMLTools.getTagContents((Element)freeParameterElement, (String)OPERATOR);
            String parameterKey = XMLTools.getTagContents((Element)freeParameterElement, (String)PARAMETER);
            String alias = XMLTools.getTagContents((Element)freeParameterElement, (String)ALIAS);
            String docu = XMLTools.getTagContents((Element)freeParameterElement, (String)DOCUMENTATION);
            String optional = XMLTools.getTagContents((Element)freeParameterElement, (String)OPTIONAL);
            String expert = XMLTools.getTagContents((Element)freeParameterElement, (String)EXPERT);
            boolean isOptional = "true".equals(optional);
            boolean isExpert = "true".equals(expert);
            CustomParameterInfo parameterInfo = new CustomParameterInfo(operator, parameterKey, alias, docu, isOptional, isExpert);
            NodeList dependencyElements = freeParameterElement.getElementsByTagName(DEPENDENCY);
            if (dependencyElements != null && dependencyElements.getLength() > 0) {
                Element dependencyElement = (Element)dependencyElements.item(0);
                String parameterAlias = XMLTools.getTagContents((Element)dependencyElement, (String)PARAMETER_ALIAS);
                String parameterValue = XMLTools.getTagContents((Element)dependencyElement, (String)PARAMETER_VALUE);
                if (parameterAlias != null && !parameterAlias.isEmpty() && parameterValue != null && !parameterValue.isEmpty()) {
                    parameterInfo.setDependency((Pair<String, String>)new Pair((Object)parameterAlias, (Object)parameterValue));
                }
            }
            this.parameters.add(parameterInfo);
        }
    }

    private void readPortNames(Document doc, boolean input) {
        String portNames = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)(input ? INPUT_PORT_NAMES : OUTPUT_PORT_NAMES));
        if (portNames != null && portNames.length() > 0) {
            String[] split = portNames.split("\u241e");
            if (input) {
                this.inputPortNames = Arrays.asList(split);
            } else {
                this.outputPortNames = Arrays.asList(split);
            }
        }
    }

    private void readPortsDocu(Document doc, boolean input) {
        NodeList inPorts = doc.getDocumentElement().getElementsByTagName(input ? INPUT_DOCU : OUTPUT_DOCU);
        if (inPorts != null && inPorts.getLength() > 0) {
            NodeList portElements = ((Element)inPorts.item(0)).getElementsByTagName(PORT);
            for (int i = 0; i < portElements.getLength(); ++i) {
                Element portElement = (Element)portElements.item(i);
                String portType = XMLTools.getTagContents((Element)portElement, (String)TYPE);
                String portDescription = XMLTools.getTagContents((Element)portElement, (String)DESCRIPTION);
                if (portType == null || portType.isEmpty() || !portType.contains(".") || OperatorService.getIOObjectClass((String)portType.substring(portType.lastIndexOf(46) + 1)) == null) {
                    portType = IOObject.class.getName();
                }
                List<PortInfo> portInfos = input ? this.docuInfos.getInputPortInfos() : this.docuInfos.getOutputPortInfos();
                portInfos.add(new PortInfo(portType, portDescription == null ? "" : portDescription));
            }
        }
    }

    private void readTutorials(Document doc) {
        NodeList tutorials = doc.getDocumentElement().getElementsByTagName(TUTORIAL);
        if (tutorials != null && tutorials.getLength() > 0) {
            for (int i = 0; i < tutorials.getLength(); ++i) {
                Element tutorialElement = (Element)tutorials.item(i);
                String tutorialTitle = XMLTools.getTagContents((Element)tutorialElement, (String)TITLE);
                String tutorialDescription = XMLTools.getTagContents((Element)tutorialElement, (String)DESCRIPTION);
                String tutorialXml = XMLTools.getTagContents((Element)tutorialElement, (String)TUTORIAL_XML);
                String tutorialLocation = XMLTools.getTagContents((Element)tutorialElement, (String)TUTORIAL_LOCATION);
                this.docuInfos.getTutorialInfos().add(new TutorialInfo(tutorialTitle, StringEscapeUtils.unescapeHtml4((String)tutorialDescription), tutorialXml, tutorialLocation));
            }
        }
    }

    private void readSubprocesses(Document doc) {
        NodeList subprocesses = doc.getDocumentElement().getElementsByTagName(SUBPROCESS);
        if (subprocesses != null && subprocesses.getLength() > 0) {
            for (int i = 0; i < subprocesses.getLength(); ++i) {
                Element subprocessElement = (Element)subprocesses.item(i);
                String name = XMLTools.getTagContents((Element)subprocessElement, (String)NAME);
                String parsedInputs = XMLTools.getTagContents((Element)subprocessElement, (String)PROCESS_INPUTS);
                int inputs = 0;
                if (parsedInputs != null) {
                    try {
                        inputs = Integer.parseInt(parsedInputs);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                String parsedOutputs = XMLTools.getTagContents((Element)subprocessElement, (String)PROCESS_OUTPUTS);
                int outputs = 0;
                if (parsedOutputs != null) {
                    try {
                        outputs = Integer.parseInt(parsedOutputs);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.subprocessInfos.add(new SubprocessInfo(inputs, outputs, name));
            }
        }
    }

    private void readDataStructureFields(Document doc) {
        NodeList outputPortsElements;
        String customOperatorTypeTagContent = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)CUSTOM_OPERATOR_TYPE);
        this.customOperatorType = customOperatorTypeTagContent != null ? CustomModuleUtils.CustomOperatorType.get(customOperatorTypeTagContent) : CustomModuleUtils.CustomOperatorType.STANDARD;
        NodeList inputPortsElements = doc.getDocumentElement().getElementsByTagName(INPUT_PORT_SCHEMA);
        if (inputPortsElements != null && inputPortsElements.getLength() > 0) {
            for (int i = 0; i < inputPortsElements.getLength(); ++i) {
                Element inputPortElement = (Element)inputPortsElements.item(i);
                this.inputPortSchemaMap.put(XMLTools.getTagContents((Element)inputPortElement, (String)INPUT_PORT_NAME), XMLTools.getTagContents((Element)inputPortElement, (String)SCHEMA_LOCATION));
            }
        }
        if ((outputPortsElements = doc.getDocumentElement().getElementsByTagName(OUTPUT_PORT_VIS_CONFIG)) != null && outputPortsElements.getLength() > 0) {
            for (int i = 0; i < outputPortsElements.getLength(); ++i) {
                Element outputPortElement = (Element)outputPortsElements.item(i);
                this.outputPortVisConfigMap.put(XMLTools.getTagContents((Element)outputPortElement, (String)OUTPUT_PORT_NAME), XMLTools.getTagContents((Element)outputPortElement, (String)VIS_CONFIG_LOCATION));
            }
        }
    }

    private static String checkCusopFile(String targetLocation, String name) {
        String fileName = name + ".cusop";
        File cusopFile = new File(RepositoryUtils.locationToFolderPath(targetLocation).toFile(), fileName);
        while (cusopFile.exists()) {
            int res = SwingTools.showConfirmDialog((String)"custom_operator.folder_file_exists", (int)0, (Object[])new Object[]{targetLocation, fileName});
            if (res == 0) {
                return targetLocation;
            }
            targetLocation = RepositoryLocationChooser.selectLocation(null, null, (Component)RapidMinerGUI.getMainFrame(), (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true, RepositoryUtils.FILESYSTEM_REPOS_FILTER, (String)"custom_operators.export_process_operator");
            if (StringUtils.trimToNull((String)targetLocation) == null) {
                return null;
            }
            if ((targetLocation = CustomOperatorTemplate.checkTargetFolder(targetLocation)) == null) {
                return null;
            }
            cusopFile = new File(RepositoryUtils.locationToFolderPath(targetLocation).toFile(), fileName);
        }
        return targetLocation;
    }

    private static String makeFileName(String name) {
        return Arrays.stream(name.split("[^a-zA-Z0-9]")).filter(s -> !s.isEmpty()).map(String::toLowerCase).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining());
    }

    private Document getTemplateXML(Process process, boolean writeDocu) throws IOException {
        Element inputPortElement;
        Document doc = new XMLExporter(false, null).exportProcess((Operator)process.getRootOperator(), false);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)TITLE, (String)this.getName());
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)ICON, (String)this.getIcon());
        String colorString = this.getColor();
        if (writeDocu && colorString != null) {
            XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)COLOR, (String)colorString);
        }
        Node contextNode = this.removeLocationsInContext(doc, null, "input");
        this.removeLocationsInContext(doc, contextNode, "output");
        if (writeDocu) {
            XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)DESCRIPTION, (String)StringEscapeUtils.escapeHtml4((String)this.getDescription()));
        }
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)SYNOPSIS, (String)this.getSynopsis());
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)PROCESS_INPUTS, (String)("" + process.getRootOperator().getSubprocess(0).getInnerSources().getNumberOfConnectedPorts()));
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)PROCESS_OUTPUTS, (String)("" + process.getRootOperator().getSubprocess(0).getInnerSinks().getNumberOfConnectedPorts()));
        List<CustomSubprocess> customSubprocessOperators = this.getCustomSubprocessOperators(process);
        if (!customSubprocessOperators.isEmpty()) {
            Element infos = doc.createElement("subprocesses");
            doc.getDocumentElement().appendChild(infos);
            for (CustomSubprocess customSubprocess : customSubprocessOperators) {
                Element infoElement = doc.createElement(SUBPROCESS);
                infos.appendChild(infoElement);
                XMLTools.setTagContents((Element)infoElement, (String)NAME, (String)customSubprocess.getName());
                XMLTools.setTagContents((Element)infoElement, (String)PROCESS_INPUTS, (String)("" + customSubprocess.getNumberOfInputs()));
                XMLTools.setTagContents((Element)infoElement, (String)PROCESS_OUTPUTS, (String)("" + customSubprocess.getNumberOfOutputs()));
            }
        }
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)DEFINES_OPTIONALS, (String)"true");
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)PARAM_ORDERING, (String)"true");
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)NEW_RANDOM_SEED, (String)"true");
        if (this.hasNoRecursion()) {
            XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)NO_RECURSION, (String)"true");
        }
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)CUSTOM_OPERATOR_TYPE, (String)this.getCustomOperatorType().toString());
        if (!this.inputPortSchemaMap.isEmpty()) {
            Element inputPortsElement = doc.createElement(INPUT_PORT_SCHEMA_MAP);
            doc.getDocumentElement().appendChild(inputPortsElement);
            for (Map.Entry entry : this.inputPortSchemaMap.entrySet()) {
                inputPortElement = doc.createElement(INPUT_PORT_SCHEMA);
                inputPortsElement.appendChild(inputPortElement);
                XMLTools.setTagContents((Element)inputPortElement, (String)INPUT_PORT_NAME, (String)((String)entry.getKey()));
                XMLTools.setTagContents((Element)inputPortElement, (String)SCHEMA_LOCATION, (String)((String)entry.getValue()));
            }
        }
        if (!this.outputPortVisConfigMap.isEmpty()) {
            Element outputPortsElement = doc.createElement(OUTPUT_PORT_VIS_CONFIG_MAP);
            doc.getDocumentElement().appendChild(outputPortsElement);
            for (Map.Entry entry : this.outputPortVisConfigMap.entrySet()) {
                inputPortElement = doc.createElement(OUTPUT_PORT_VIS_CONFIG);
                outputPortsElement.appendChild(inputPortElement);
                XMLTools.setTagContents((Element)inputPortElement, (String)OUTPUT_PORT_NAME, (String)((String)entry.getKey()));
                XMLTools.setTagContents((Element)inputPortElement, (String)VIS_CONFIG_LOCATION, (String)((String)entry.getValue()));
            }
        }
        Element parameterInfos = doc.createElement("template-parameters");
        doc.getDocumentElement().appendChild(parameterInfos);
        for (CustomParameterInfo customParameterInfo : this.parameters) {
            this.addParameters(customParameterInfo, doc, parameterInfos, writeDocu);
        }
        List<String> tags = this.docuInfos.getTags();
        if (!tags.isEmpty()) {
            XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)TAGS, (String)ParameterTypeEnumeration.transformEnumeration2String(tags));
        }
        if (writeDocu) {
            this.addPorts(doc, this.docuInfos.getInputPortInfos(), INPUT_DOCU);
            this.addPorts(doc, this.docuInfos.getOutputPortInfos(), OUTPUT_DOCU);
            List<TutorialInfo> list = this.docuInfos.getTutorialInfos();
            if (!list.isEmpty()) {
                Element infos = doc.createElement("tutorials");
                doc.getDocumentElement().appendChild(infos);
                for (TutorialInfo tutorialInfo : list) {
                    if (tutorialInfo.isEmpty()) continue;
                    Element infoElement = doc.createElement(TUTORIAL);
                    infos.appendChild(infoElement);
                    XMLTools.setTagContents((Element)infoElement, (String)TITLE, (String)tutorialInfo.getTitle());
                    XMLTools.setTagContents((Element)infoElement, (String)DESCRIPTION, (String)StringEscapeUtils.escapeHtml4((String)tutorialInfo.getDescription()));
                    String location = tutorialInfo.getLocation();
                    if (tutorialInfo.useXML() || location == null || location.isEmpty()) {
                        XMLTools.setTagContents((Element)infoElement, (String)TUTORIAL_XML, (String)tutorialInfo.getXml());
                        continue;
                    }
                    XMLTools.setTagContents((Element)infoElement, (String)TUTORIAL_LOCATION, (String)location);
                    XMLTools.setTagContents((Element)infoElement, (String)TUTORIAL_XML, (String)"");
                }
            }
        }
        this.writePortNames(doc, this.inputPortNames, INPUT_PORT_NAMES);
        this.writePortNames(doc, this.outputPortNames, OUTPUT_PORT_NAMES);
        return doc;
    }

    private void writePortNames(Document doc, List<String> portNames, String tagName) {
        if (!portNames.isEmpty()) {
            XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)tagName, (String)String.join((CharSequence)"\u241e", portNames));
        }
    }

    private List<CustomSubprocess> getCustomSubprocessOperators(Process process) {
        return process.getAllOperators().stream().filter(o -> o instanceof CustomSubprocess).map(o -> (CustomSubprocess)((Object)o)).collect(Collectors.toList());
    }

    private Node removeLocationsInContext(Document doc, Node contextNode, String type) {
        Node typeNode;
        if (contextNode == null) {
            for (contextNode = doc.getDocumentElement().getFirstChild(); contextNode != null && !contextNode.getNodeName().equals("context"); contextNode = contextNode.getNextSibling()) {
            }
        }
        if (contextNode == null || !contextNode.getNodeName().equals("context")) {
            return contextNode;
        }
        for (typeNode = contextNode.getFirstChild(); typeNode != null && !typeNode.getNodeName().equals(type); typeNode = typeNode.getNextSibling()) {
        }
        if (typeNode == null || !typeNode.getNodeName().equals(type)) {
            return contextNode;
        }
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        for (Node locationNode = typeNode.getFirstChild(); locationNode != null; locationNode = locationNode.getNextSibling()) {
            nodesToRemove.add(locationNode);
        }
        nodesToRemove.forEach(typeNode::removeChild);
        return contextNode;
    }

    private void addParameters(CustomParameterInfo parameterInfo, Document doc, Element parameterInfos, boolean writeDoku) {
        String documentation;
        Element infoElement = doc.createElement(TEMPLATE_PARAMETER);
        parameterInfos.appendChild(infoElement);
        XMLTools.setTagContents((Element)infoElement, (String)OPERATOR, (String)parameterInfo.getOperator());
        XMLTools.setTagContents((Element)infoElement, (String)PARAMETER, (String)parameterInfo.getParameter());
        XMLTools.setTagContents((Element)infoElement, (String)ALIAS, (String)parameterInfo.getAlias());
        if (writeDoku && (documentation = parameterInfo.getDocumentation()) != null && !documentation.isEmpty()) {
            XMLTools.setTagContents((Element)infoElement, (String)DOCUMENTATION, (String)documentation);
        }
        if (parameterInfo.isOptional()) {
            XMLTools.setTagContents((Element)infoElement, (String)OPTIONAL, (String)"true");
        }
        if (parameterInfo.isExpert()) {
            XMLTools.setTagContents((Element)infoElement, (String)EXPERT, (String)"true");
        }
        if (parameterInfo.getDependency() != null) {
            Element dependency = doc.createElement(DEPENDENCY);
            infoElement.appendChild(dependency);
            XMLTools.setTagContents((Element)dependency, (String)PARAMETER_ALIAS, (String)((String)parameterInfo.getDependency().getFirst()));
            XMLTools.setTagContents((Element)dependency, (String)PARAMETER_VALUE, (String)((String)parameterInfo.getDependency().getSecond()));
        }
    }

    private void addPorts(Document doc, List<PortInfo> portInfos, String outerName) {
        if (!portInfos.isEmpty()) {
            Element infos = doc.createElement(outerName);
            doc.getDocumentElement().appendChild(infos);
            for (PortInfo inputInfo : portInfos) {
                Element infoElement = doc.createElement(PORT);
                infos.appendChild(infoElement);
                XMLTools.setTagContents((Element)infoElement, (String)TYPE, (String)inputInfo.getRawPortType());
                XMLTools.setTagContents((Element)infoElement, (String)DESCRIPTION, (String)inputInfo.getDescription());
            }
        }
    }

    public Process getProcess() throws IOException, XMLException {
        return new Process(this.templateDefinition, Process.NO_ENCRYPTION);
    }

    public Process getProcessWithoutGUI() throws IOException, XMLException {
        if (PluginInitProcessDefinedOperators.PROCESS_WITHOUT_GUI_SWITCH == null) {
            return new Process(this.templateDefinition, Process.NO_ENCRYPTION);
        }
        boolean unset = PluginInitProcessDefinedOperators.PROCESS_WITHOUT_GUI_SWITCH.get() == null;
        try {
            PluginInitProcessDefinedOperators.PROCESS_WITHOUT_GUI_SWITCH.set(true);
            Process process = new Process(this.templateDefinition, Process.NO_ENCRYPTION);
            return process;
        }
        finally {
            if (unset) {
                PluginInitProcessDefinedOperators.PROCESS_WITHOUT_GUI_SWITCH.remove();
            }
        }
    }

    public boolean definesOptionals() {
        return this.definesOptionals;
    }

    public boolean hasNoRecursion() {
        return this.noRecursion;
    }

    public boolean getsRandomSeed() {
        return this.getsRandomSeed;
    }

    public int getInputPorts() {
        return this.numberOfInputs;
    }

    public int getOutputPorts() {
        return this.numberOfOutputs;
    }

    public DocuInfos getDocuInfos() {
        return this.docuInfos;
    }

    public List<SubprocessInfo> getSubprocessInfos() {
        return this.subprocessInfos;
    }

    public List<String> getInputPortNames() {
        return this.inputPortNames;
    }

    public List<String> getOutputPortNames() {
        return this.outputPortNames;
    }

    public String getColor() {
        return this.color;
    }
}

