/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ExtensionNameProvider;
import com.rapidminer.extension.processdefined.cloud.MetadataResolverRegistration;
import com.rapidminer.extension.processdefined.operator.CustomOperatorCache;
import com.rapidminer.extension.processdefined.operator.CustomOperatorDescription;
import com.rapidminer.extension.processdefined.operator.HiddenProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.HiddenSubProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.ProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.ProcessDefinedOperatorDocBundle;
import com.rapidminer.extension.processdefined.operator.SubProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.UseCaseModuleOperator;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.extension.processdefined.util.SubprocessInfo;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.StartupHooks;
import com.rapidminer.tools.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.SAXException;

public final class ProcessDefinedOperators {
    public static final String CONTENTS_FILE = "CONTENTS";
    public static final String PROCESS_OPERATORS_FOLDER = "process_operators/";
    public static final String CUSOP_EXTENSION = ".cusop";

    private ProcessDefinedOperators() {
        throw new AssertionError();
    }

    public static void registerAll(Class<?> pluginInitClass) {
        try {
            List<String> names = ProcessDefinedOperators.getNames(pluginInitClass);
            StartupHooks.addStartupHook(() -> {
                Plugin plugin = Plugin.getPluginForClass((Class)pluginInitClass);
                try {
                    AccessController.doPrivileged(() -> {
                        ProcessDefinedOperators.registerForAll(names, plugin);
                        CustomOperatorCache.clearBrokenProcesses();
                        ExtensionNameProvider.INSTANCE.reset();
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    LogService.getRoot().log(Level.WARNING, "Not allowed to register custom operators", e);
                }
            });
        }
        catch (RepositoryException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to load custom operators", e);
        }
        ProcessDefinedOperators.register(pluginInitClass);
    }

    public static void register(Class<?> pluginInitClass) {
        try {
            AccessController.doPrivileged(() -> {
                RepositoryUtils.copyHiddenRepository(Plugin.getPluginForClass((Class)pluginInitClass));
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            LogService.getRoot().log(Level.WARNING, "Not allowed to register hidden repository", e);
        }
    }

    public static void addStartupHook() {
        StartupHooks.addStartupHook(() -> {
            if (!PluginInitProcessDefinedOperators.isDataStructurePresent()) {
                PluginInitProcessDefinedOperators.checkAndRegisterDataStructure();
            }
            CustomOperatorCache.clearBrokenProcesses();
            ExtensionNameProvider.INSTANCE.reset();
        });
    }

    static void registerAllOperators(Plugin plugin) {
        try {
            List<String> names = ProcessDefinedOperators.getNames(plugin);
            try {
                AccessController.doPrivileged(() -> {
                    ProcessDefinedOperators.registerForAll(names, plugin);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                LogService.getRoot().log(Level.WARNING, "Not allowed to register custom operators", e);
            }
        }
        catch (RepositoryException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to load custom operators", e);
        }
    }

    private static void registerForAll(List<String> names, Plugin plugin) {
        if (!PluginInitProcessDefinedOperators.isDataStructurePresent()) {
            PluginInitProcessDefinedOperators.checkAndRegisterDataStructure();
        }
        boolean hidden = false;
        try {
            String hiddenString = plugin.getArchive().getManifest().getMainAttributes().getValue("hide_defining_processes");
            hidden = Boolean.parseBoolean(hiddenString);
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to read custom operator extension manifest for " + plugin.getName(), e);
        }
        for (String name : names) {
            try {
                String[] split = name.split("/");
                ProcessDefinedOperators.register(split[split.length - 1], name, plugin, hidden);
            }
            catch (Throwable e) {
                LogService.getRoot().log(Level.WARNING, "Failed to register custom operator " + name, e);
            }
        }
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(200, 6, 0, "SAAS"))) {
            MetadataResolverRegistration.registerProcessSuggestions(plugin);
            MetadataResolverRegistration.registerFromEnumerationSubsets(plugin);
        }
    }

    private static void register(String fileName, String fullPathName, Plugin plugin, boolean hidden) throws OperatorCreationException {
        String key = ProcessDefinedOperators.toSnakeCase(fileName);
        CustomOperatorTemplate template = null;
        try (InputStream resourceInputStream = ProcessDefinedOperators.getResourceStream(fullPathName, plugin, hidden);){
            template = new CustomOperatorTemplate(resourceInputStream);
        }
        catch (IOException | SAXException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to retrieve definition of custom operator " + fullPathName, e);
            return;
        }
        if (!hidden && CustomModuleUtils.CustomOperatorType.USE_CASE_MODULE.equals((Object)template.getCustomOperatorType()) && !PluginInitProcessDefinedOperators.isDataStructurePresent()) {
            LogService.getRoot().warning("Custom operator is of type " + (Object)((Object)CustomModuleUtils.CustomOperatorType.USE_CASE_MODULE) + " but data_structure extension is not provided. Operator name: " + template.getName());
            return;
        }
        ProcessDefinedOperatorDocBundle bundle = new ProcessDefinedOperatorDocBundle(key, template);
        String iconName = template.getIcon() == null ? "painters_palette.png" : template.getIcon();
        String group = "";
        int sepIndex = fullPathName.lastIndexOf(47);
        if (sepIndex > 0) {
            group = "." + fullPathName.substring(0, sepIndex).replace('/', '.');
        }
        OperatorService.registerOperator((OperatorDescription)new CustomOperatorDescription("extensions." + plugin.getName() + group, key, ProcessDefinedOperators.getCustomOperatorClass(hidden, template), null, iconName, plugin, bundle, fullPathName), null);
    }

    private static Class<? extends Operator> getCustomOperatorClass(boolean hidden, CustomOperatorTemplate template) {
        List<SubprocessInfo> subprocessInfos = template.getSubprocessInfos();
        if (subprocessInfos.isEmpty()) {
            CustomModuleUtils.CustomOperatorType customOperatorType = template.getCustomOperatorType();
            Class customOperatorClass = ProcessDefinedOperator.class;
            if (hidden) {
                customOperatorClass = HiddenProcessDefinedOperator.class;
            } else if (customOperatorType.equals((Object)CustomModuleUtils.CustomOperatorType.USE_CASE_MODULE)) {
                customOperatorClass = UseCaseModuleOperator.class;
            }
            return customOperatorClass;
        }
        return hidden ? HiddenSubProcessDefinedOperator.class : SubProcessDefinedOperator.class;
    }

    private static InputStream getResourceStream(String name, Plugin plugin, boolean hidden) throws IOException {
        if (!hidden) {
            return ProcessDefinedOperators.getResourceStream(name, plugin);
        }
        InputStream resourceStream = ProcessDefinedOperators.getResourceStream(name, plugin);
        byte[] arr = HiddenProcessDefinedOperator.class.getSimpleName().getBytes(StandardCharsets.UTF_8);
        try {
            SecretKeySpec obfuscator = new SecretKeySpec(arr, 0, 16, "AES");
            Cipher ob = Cipher.getInstance("AES");
            ob.init(2, obfuscator);
            return new CipherInputStream(resourceStream, ob);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IOException("Cannot deobfuscate defining xml': " + e, e);
        }
    }

    public static InputStream getResourceStream(String name, Plugin plugin) throws IOException {
        String nameWithExtension = name + CUSOP_EXTENSION;
        return ProcessDefinedOperators.getResourceStreamFullName(plugin, PROCESS_OPERATORS_FOLDER + nameWithExtension);
    }

    public static InputStream getResourceStreamFullName(Plugin plugin, String nameWithExtensionAndFolder) throws IOException {
        String fullPath = "com/rapidminer/extension/resources/" + nameWithExtensionAndFolder;
        URL resourceURL = plugin.getClassLoader().getResource(fullPath);
        if (resourceURL == null) {
            throw new IOException("Missing resource " + fullPath);
        }
        return resourceURL.openStream();
    }

    public static String toSnakeCase(String name) {
        return name.replaceAll("(.)(\\p{Upper})", "$1_$2").replace(" ", "_").replace("__", "_").toLowerCase();
    }

    private static List<String> getNames(Class<?> pluginInitClass) throws RepositoryException {
        Plugin plugin = Plugin.getPluginForClass(pluginInitClass);
        return ProcessDefinedOperators.getNames(plugin);
    }

    private static List<String> getNames(Plugin plugin) throws RepositoryException {
        ArrayList<String> arrayList;
        block12: {
            InputStream in = ProcessDefinedOperators.getResourceStreamFullName(plugin, "process_operators/CONTENTS");
            try {
                String[] lines = FileUtils.readText((InputStream)in).split("\n");
                ArrayList<String> names = new ArrayList<String>();
                for (String line : lines) {
                    line = line.trim();
                    int space = line.indexOf(32);
                    if (line.isEmpty() || space == -1) continue;
                    String name = line.substring(space + 1).trim();
                    String errorSource = null;
                    if (line.startsWith("FOLDER ")) continue;
                    if (line.startsWith("ENTRY")) {
                        int suffixStart = name.lastIndexOf(46);
                        String nameWOExt = name;
                        if (suffixStart >= 0) {
                            nameWOExt = name.substring(0, suffixStart);
                        }
                        names.add(nameWOExt);
                    } else {
                        errorSource = line;
                    }
                    if (errorSource == null) continue;
                    throw new IOException("Illegal entry type in CONTENTS for plugin '" + plugin.getName() + "': " + errorSource);
                }
                arrayList = names;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RepositoryException("Error reading contents of CONTENTS for plugin " + plugin.getName() + ": " + e, (Throwable)e);
                }
            }
            in.close();
        }
        return arrayList;
    }
}

