/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.actions;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.actions.ExtractSubprocessUtils;
import com.rapidminer.extension.processdefined.operator.OpenableCustomOperator;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.flow.processrendering.model.ProcessRendererModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.ProcessLayoutXMLFilter;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtractIntoSubprocessAction
extends ResourceAction {
    private static final long serialVersionUID = 807011844800438620L;
    private final transient Actions actions;

    public ExtractIntoSubprocessAction(Actions actions) {
        super(true, "process_defined_operators.extract_inner_process", new Object[0]);
        this.setCondition(0, 1);
        this.setCondition(2, -1);
        this.actions = actions;
    }

    public void loggedActionPerformed(ActionEvent e) {
        List selectedOperators = this.actions.getSelectedOperators();
        if (selectedOperators == null || selectedOperators.size() != 1) {
            return;
        }
        Operator selectedOperator = (Operator)selectedOperators.get(0);
        try {
            ExtractIntoSubprocessAction.extractCustomOperator(selectedOperator);
        }
        catch (Exception ex) {
            SwingTools.showSimpleErrorMessage((String)"extract_custom_subprocess.cannot_create_subprocess", (Throwable)ex, (Object[])new Object[0]);
        }
        ProcessRendererModel processRendererModel = RapidMinerGUI.getMainFrame().getProcessPanel().getProcessRenderer().getModel();
        processRendererModel.clearOperatorSelection();
    }

    public static void extractCustomOperator(Operator selectedOperator) throws OperatorCreationException {
        if (!(selectedOperator instanceof OpenableCustomOperator) || ((OpenableCustomOperator)selectedOperator).isHidden()) {
            return;
        }
        ExecutionUnit parent = selectedOperator.getExecutionUnit();
        if (parent == null) {
            return;
        }
        int operatorIndex = parent.getIndexOfOperator(selectedOperator);
        String name = selectedOperator.getName();
        Rectangle2D rect = ProcessLayoutXMLFilter.lookupOperatorRectangle((Operator)selectedOperator);
        Process innerProcess = ((OpenableCustomOperator)selectedOperator).getOpenableInnerProcess();
        if (innerProcess == null) {
            throw new IllegalStateException("Cannot open defining process of custom operator");
        }
        OperatorChain subProcessOperator = ExtractSubprocessUtils.INSTANCE.extract(innerProcess);
        HashMap<OutputPort, Integer> inputPorts = new HashMap<OutputPort, Integer>();
        HashMap<InputPort, Integer> outputPorts = new HashMap<InputPort, Integer>();
        int index = 0;
        for (InputPort inputPort : selectedOperator.getInputPorts().getAllPorts()) {
            if (inputPort.isConnected()) {
                inputPorts.put((OutputPort)inputPort.lockDisconnectAndGet(), index);
            }
            ++index;
        }
        index = 0;
        for (OutputPort outputPort : selectedOperator.getOutputPorts().getAllPorts()) {
            if (outputPort.isConnected()) {
                outputPorts.put((InputPort)outputPort.lockDisconnectAndGet(), index);
            }
            ++index;
        }
        selectedOperator.remove();
        parent.addOperator((Operator)subProcessOperator, operatorIndex);
        subProcessOperator.rename(name);
        for (Map.Entry entry : inputPorts.entrySet()) {
            ((InputPort)subProcessOperator.getInputPorts().getPortByIndex(((Integer)entry.getValue()).intValue())).connectTo((OutputPort)entry.getKey());
            ((OutputPort)entry.getKey()).unlock();
        }
        for (Map.Entry entry : outputPorts.entrySet()) {
            ((OutputPort)subProcessOperator.getOutputPorts().getPortByIndex(((Integer)entry.getValue()).intValue())).connectTo((InputPort)entry.getKey());
            ((InputPort)entry.getKey()).unlock();
        }
        ProcessLayoutXMLFilter.setOperatorRectangle((Operator)subProcessOperator, (Rectangle2D)rect);
    }
}

