/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.cloud;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.extension.processdefined.cloud.CloudAttribute;
import com.rapidminer.extension.processdefined.operator.parameter.AttributeSubsetParameterHelper;
import com.rapidminer.extension.processdefined.parameter.ParameterTypeResolverAttributeSubset;
import com.rapidminer.metadata.MetadataResolutionException;
import com.rapidminer.metadata.MetadataResolver;
import com.rapidminer.metadata.MetadataResolverInitializationException;
import com.rapidminer.metadata.dto.MetaDataDto;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AttributeSubsetHelperMetadataResolver
implements MetadataResolver {
    public static final String OPERATOR_KEY = "process_defined_operators:attribute_subset_parameter_macro";
    private List<CloudAttribute> portMD = null;
    private List<CloudAttribute> cache = null;
    private Map<String, String> lastOtherParameters = null;

    public void initialize(Operator operator, ParameterType parameterType) throws MetadataResolverInitializationException {
        if (!(parameterType instanceof ParameterTypeResolverAttributeSubset)) {
            throw new MetadataResolverInitializationException("Unsupported parameter type", (Exception)new IllegalArgumentException("Wrong parameter type"));
        }
        if (!(operator instanceof AttributeSubsetParameterHelper)) {
            throw new MetadataResolverInitializationException("Unsupported operator", (Exception)new IllegalArgumentException("Operator must be Attribute Subset Parameter Macro"));
        }
        IOTable ioTable = (IOTable)((InputPort)operator.getInputPorts().getPortByIndex(0)).getDataAsOrNull(IOTable.class);
        if (ioTable != null) {
            this.portMD = CloudAttribute.fromTable(ioTable.getTable());
        }
    }

    public MetaDataDto<?> resolveMetaData(Map<String, String> extraParameters) throws MetadataResolutionException {
        if (this.cache != null && this.lastOtherParameters != null && this.lastOtherParameters.equals(extraParameters)) {
            return new MetaDataDto(this.cache);
        }
        this.lastOtherParameters = extraParameters;
        if (!this.lastOtherParameters.get("use_fixed_values").equals("true")) {
            this.cache = this.portMD == null ? Collections.emptyList() : this.portMD;
        } else {
            String enumerationParameter = this.lastOtherParameters.get("values_to_choose_from");
            this.cache = CloudAttribute.fromEnumeration(enumerationParameter);
        }
        return new MetaDataDto(this.cache);
    }

    public void cleanup() {
        this.cache = null;
        this.portMD = null;
        this.lastOtherParameters = null;
    }
}

