/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.cloud;

import com.rapidminer.extension.processdefined.actions.ExtractIntoSubprocessAction;
import com.rapidminer.extension.processdefined.operator.OpenableCustomOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.FunctionWithThrowable;
import com.rapidminer.tools.LogService;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;

public enum CloudActionRegistration {


    public static void register() {
        FunctionWithThrowable<List<Object>, Object, Exception> checkFunction = new FunctionWithThrowable<List<Object>, Object, Exception>(){

            public Object applyWithException(List<Object> objects) throws Exception {
                if (objects.size() != 1 || !(objects.get(0) instanceof Operator)) {
                    throw new IllegalArgumentException("Expected exactly one operator");
                }
                if (!(objects.get(0) instanceof OpenableCustomOperator) || ((OpenableCustomOperator)objects.get(0)).isHidden()) {
                    return false;
                }
                return true;
            }
        };
        FunctionWithThrowable<List<Object>, Object, Exception> extractionFunction = new FunctionWithThrowable<List<Object>, Object, Exception>(){

            public Object applyWithException(List<Object> objects) throws Exception {
                if (objects.size() != 1 || !(objects.get(0) instanceof Operator)) {
                    throw new IllegalArgumentException("Expected exactly one operator");
                }
                if (!(objects.get(0) instanceof OpenableCustomOperator) || ((OpenableCustomOperator)objects.get(0)).isHidden()) {
                    throw new IllegalArgumentException("Expected non-hidden custom operator");
                }
                ExtractIntoSubprocessAction.extractCustomOperator((Operator)objects.get(0));
                return null;
            }
        };
        try {
            Class<?> myClass = Class.forName("com.rapidminer.studio.internal.ActionRegistry");
            Method registerAction = myClass.getDeclaredMethod("registerAction", String.class, FunctionWithThrowable.class);
            registerAction.invoke(null, "isExtractableCustomOperator", checkFunction);
            registerAction.invoke(null, "extractCustomOperator", extractionFunction);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to register Cloud Actions", e);
        }
    }
}

