/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.cloud;

import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.util.ColumnRole;
import com.rapidminer.operator.ports.metadata.table.ColumnInfo;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import java.util.ArrayList;
import java.util.List;

public class CloudAttribute {
    private String name;
    private RoleTypes role;
    private AttributeTypes type;

    public CloudAttribute(String name, RoleTypes role, AttributeTypes type) {
        this.name = name;
        this.role = role;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoleTypes getRole() {
        return this.role;
    }

    public void setRole(RoleTypes role) {
        this.role = role;
    }

    public AttributeTypes getType() {
        return this.type;
    }

    public void setType(AttributeTypes type) {
        this.type = type;
    }

    public static List<CloudAttribute> fromTableMD(TableMetaData tableMetaData) {
        ArrayList<CloudAttribute> attributes = new ArrayList<CloudAttribute>();
        for (String label : tableMetaData.labels()) {
            Column.TypeId type = null;
            ColumnInfo column = tableMetaData.column(label);
            if (column != null && column.getType().isPresent()) {
                type = ((ColumnType)column.getType().get()).id();
            }
            boolean isBoolean = column != null && column.getDictionary() != null && column.getDictionary().isBoolean();
            ColumnRole role = (ColumnRole)tableMetaData.getFirstColumnMetaData(label, ColumnRole.class);
            attributes.add(new CloudAttribute(label, CloudAttribute.convert(role), CloudAttribute.convert(type, isBoolean)));
        }
        return attributes;
    }

    public static List<CloudAttribute> fromTable(Table table) {
        ArrayList<CloudAttribute> attributes = new ArrayList<CloudAttribute>();
        for (String label : table.labels()) {
            Column.TypeId type = table.column(label).type().id();
            ColumnRole role = (ColumnRole)table.getFirstMetaData(label, ColumnRole.class);
            boolean isBoolean = table.column(label).type() == ColumnType.NOMINAL && table.column(label).getDictionary().isBoolean();
            attributes.add(new CloudAttribute(label, CloudAttribute.convert(role), CloudAttribute.convert(type, isBoolean)));
        }
        return attributes;
    }

    public static List<CloudAttribute> fromEnumeration(String enumerationParameterValue) {
        ArrayList<CloudAttribute> attributes = new ArrayList<CloudAttribute>();
        for (String entry : ParameterTypeEnumeration.transformString2List((String)enumerationParameterValue)) {
            attributes.add(new CloudAttribute(entry, RoleTypes.NONE, AttributeTypes.UNKNOWN));
        }
        return attributes;
    }

    private static AttributeTypes convert(Column.TypeId typeId, boolean isBoolean) {
        if (typeId == null) {
            return AttributeTypes.UNKNOWN;
        }
        if (typeId == Column.TypeId.NOMINAL && isBoolean) {
            return AttributeTypes.BINARY;
        }
        try {
            return AttributeTypes.valueOf(typeId.name());
        }
        catch (IllegalArgumentException e) {
            return AttributeTypes.UNKNOWN;
        }
    }

    private static RoleTypes convert(ColumnRole role) {
        if (role == null) {
            return RoleTypes.NONE;
        }
        try {
            return RoleTypes.valueOf(role.name());
        }
        catch (IllegalArgumentException e) {
            return RoleTypes.UNKNOWN;
        }
    }

    public static enum AttributeTypes {
        NUMERIC,
        NOMINAL,
        DATE,
        CATEGORICAL,
        OBJECT,
        INTEGER_53_BIT,
        REAL,
        TIME,
        DATE_TIME,
        TEXT,
        TEXT_SET,
        TEXT_LIST,
        BINARY,
        UNKNOWN;

    }

    public static enum RoleTypes {
        ID,
        LABEL,
        NONE,
        CONFIDENCE,
        PREDICTION,
        CLUSTER,
        WEIGHT,
        BATCH,
        OUTLIER,
        COST,
        BASE_VALUE,
        ENCODING,
        INTERPRETATION,
        METADATA,
        SCORE,
        SOURCE,
        UNKNOWN;

    }
}

