/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.cloud;

import com.rapidminer.extension.processdefined.cloud.AttributeSubsetHelperMetadataResolver;
import com.rapidminer.extension.processdefined.cloud.CustomExtensionMetadataResolver;
import com.rapidminer.extension.processdefined.cloud.FromEnumerationSubsetMetadataResolver;
import com.rapidminer.extension.processdefined.cloud.ProcessResultMetadataResolver;
import com.rapidminer.extension.processdefined.cloud.RepositorySuggestionMetadataResolver;
import com.rapidminer.metadata.MetadataResolverFactory;
import com.rapidminer.metadata.MetadataResolverKey;
import com.rapidminer.metadata.MetadataResolverRegistry;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;

public enum MetadataResolverRegistration {

    public static final String PROCESS_SUGGESTION_PARAMETERS_PATH = "com/rapidminer/extension/resources/process_operators/process_suggestion_parameters";
    public static final String FROM_ENUM_SUBSET_PARAMETERS_PATH = "com/rapidminer/extension/resources/process_operators/from_enum_subset_parameters";

    public static void register() {
        MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(CustomExtensionMetadataResolver.class, CustomExtensionMetadataResolver.getKeys()));
        MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(RepositorySuggestionMetadataResolver.RepositoryFileSuggestionMetadataResolver.class, Collections.singletonList(new MetadataResolverKey("process_defined_operators:open_custom_extension", "file_name"))));
        MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(RepositorySuggestionMetadataResolver.RepositoryObjectSuggestionMetadataResolver.class, Collections.singletonList(new MetadataResolverKey("process_defined_operators:retrieve_custom_extension", "object_name"))));
        MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(RepositorySuggestionMetadataResolver.RepositoryProcessSuggestionMetadataResolver.class, Arrays.asList(new MetadataResolverKey("process_defined_operators:custom_execute_process", "process_name"), new MetadataResolverKey("process_defined_operators:process_suggestion_parameter_macro", "suggestion_process"))));
        MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(AttributeSubsetHelperMetadataResolver.class, Collections.singletonList(new MetadataResolverKey("process_defined_operators:attribute_subset_parameter_macro", "value"))));
        MetadataResolverRegistration.registerProcessSuggestion("process_defined_operators:process_suggestion_parameter_macro", "value");
    }

    public static void registerProcessSuggestion(String fullOperatorKey, String parameterKey) {
        MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(ProcessResultMetadataResolver.class, Collections.singletonList(new MetadataResolverKey(fullOperatorKey, parameterKey))));
    }

    public static void registerProcessSuggestions(Plugin plugin) {
        URL resourceURL = plugin.getClassLoader().getResource(PROCESS_SUGGESTION_PARAMETERS_PATH);
        if (resourceURL == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream()));){
            String pluginKey = plugin.getPrefix();
            reader.lines().forEach(line -> {
                String[] pair = line.split(":");
                MetadataResolverRegistration.registerProcessSuggestion(pluginKey + ":" + pair[0], pair[1]);
            });
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Error reading contents of process_suggestion_parameters for plugin " + plugin.getName(), e);
        }
    }

    public static void registerFromEnumerationSubsets(Plugin plugin) {
        URL resourceURL = plugin.getClassLoader().getResource(FROM_ENUM_SUBSET_PARAMETERS_PATH);
        if (resourceURL == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream()));){
            String pluginKey = plugin.getPrefix();
            reader.lines().forEach(line -> {
                String[] pair = line.split(":");
                MetadataResolverRegistry.getInstance().registerResolverFactory(new MetadataResolverFactory(FromEnumerationSubsetMetadataResolver.class, Collections.singletonList(new MetadataResolverKey(pluginKey + ":" + pair[0], pair[1]))));
            });
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Error reading contents of from_enum_subset_parameters for plugin " + plugin.getName(), e);
        }
    }
}

