/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.cloud;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.extension.processdefined.operator.parameter.ProcessResultSuggestionProvider;
import com.rapidminer.extension.processdefined.operator.parameter.ProcessSuggestionParameterHelper;
import com.rapidminer.metadata.MetadataResolutionException;
import com.rapidminer.metadata.MetadataResolver;
import com.rapidminer.metadata.MetadataResolverInitializationException;
import com.rapidminer.metadata.dto.MetaDataDto;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.studio.internal.ProcessStoppedRuntimeException;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.belt.BeltConversionTools;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public class ProcessResultMetadataResolver
implements MetadataResolver {
    private static final int THREE_MIN_DELAY = 180000;
    private List<String> cache = null;
    private Map<String, String> lastOtherParameters = null;
    private IOContainer ioContainer = null;
    private Process cachedProcess = null;
    private ProcessLocation outerProcessLocation = null;
    private Map<String, String> outerContextMacros = Collections.emptyMap();

    public void initialize(Operator operator, ParameterType parameterType) throws MetadataResolverInitializationException {
        IOContainer run;
        ProcessResultSuggestionProvider suggestionProvider = ProcessResultMetadataResolver.getProcessResultSuggestionProvider(parameterType);
        Map<String, String> otherParameters = ProcessResultMetadataResolver.getOtherParameters(operator, parameterType);
        this.lastOtherParameters = Collections.unmodifiableMap(otherParameters);
        boolean useAvailableInputs = suggestionProvider.isUseAvailableInput();
        if (useAvailableInputs || operator instanceof ProcessSuggestionParameterHelper) {
            this.ioContainer = ProcessResultSuggestionProvider.fillIOContainer(new IOContainer(), operator);
        }
        try {
            this.cachedProcess = suggestionProvider.loadProcess();
        }
        catch (UserError | RepositoryException | XMLException | IOException e) {
            if (operator instanceof ProcessSuggestionParameterHelper) {
                return;
            }
            throw new MetadataResolverInitializationException("Could not load suggestion process: " + e.getMessage(), (Exception)e);
        }
        IOContainer newContainer = this.prepareProcessAndContainer(operator, otherParameters, useAvailableInputs);
        try {
            run = this.runWithTimer(newContainer);
        }
        catch (ProcessStoppedException | ProcessStoppedRuntimeException e) {
            return;
        }
        catch (OperatorException e) {
            if (operator instanceof ProcessSuggestionParameterHelper) {
                return;
            }
            throw new MetadataResolverInitializationException("Could not run suggestion process: " + e.getMessage(), (Exception)((Object)e));
        }
        IOTable ioTable = null;
        try {
            ioTable = ProcessResultMetadataResolver.getTable(run);
        }
        catch (OperatorException e) {
            if (operator instanceof ProcessSuggestionParameterHelper) {
                return;
            }
            throw new MetadataResolverInitializationException("Result of suggestion process is not a table", (Exception)((Object)e));
        }
        if (ioTable.getTable().width() < 1) {
            LogService.getRoot().log(Level.WARNING, "Suggestion process result contains no column.");
            this.cache = new ArrayList<String>();
            return;
        }
        Column firstColumn = ioTable.getTable().column(0);
        if (!firstColumn.type().elementType().equals(String.class)) {
            if (operator instanceof ProcessSuggestionParameterHelper) {
                return;
            }
            throw new MetadataResolverInitializationException("Result of suggestion process is not a string column", (Exception)((Object)new OperatorException("First column does not contain strings")));
        }
        this.cache = ProcessResultMetadataResolver.readColumn(firstColumn, ioTable);
    }

    public MetaDataDto<?> resolveMetaData(Map<String, String> extraParameters) throws MetadataResolutionException {
        if (this.cache == null || this.lastOtherParameters == null || !this.lastOtherParameters.equals(extraParameters)) {
            IOContainer run;
            IOContainer newContainer;
            if (!(this.cachedProcess != null && (extraParameters.get("extension_name") == null || extraParameters.get("suggestion_process") == null) || this.cachedProcess != null && this.lastOtherParameters != null && extraParameters.get("extension_name").equals(this.lastOtherParameters.get("extension_name")) && extraParameters.get("suggestion_process").equals(this.lastOtherParameters.get("suggestion_process")))) {
                try {
                    this.cachedProcess = ProcessResultSuggestionProvider.getProcess(extraParameters.get("extension_name"), extraParameters.get("suggestion_process"));
                }
                catch (UserError | RepositoryException | XMLException | IOException e) {
                    throw new MetadataResolutionException("Failed to load suggestion process: " + e.getMessage(), (Exception)e);
                }
                ProcessResultSuggestionProvider.cleanProcess(this.cachedProcess);
                this.cachedProcess.setProcessLocation(this.outerProcessLocation);
            }
            extraParameters.forEach((key, value) -> this.cachedProcess.getContext().addMacro(new Pair((Object)("parameter_" + key), value)));
            IOContainer iOContainer = newContainer = this.ioContainer == null ? new IOContainer() : this.ioContainer;
            if (extraParameters.containsKey("use_available_input") && !"true".equals(extraParameters.get("use_available_input"))) {
                newContainer = new IOContainer();
            }
            try {
                run = this.runWithTimer(newContainer);
            }
            catch (ProcessStoppedException | ProcessStoppedRuntimeException e) {
                throw new MetadataResolutionException("Suggestion process took too long", (Exception)e);
            }
            catch (OperatorException e) {
                throw new MetadataResolutionException("Failed to run suggestion process: " + e.getMessage(), (Exception)((Object)e));
            }
            IOTable ioTable = null;
            try {
                ioTable = ProcessResultMetadataResolver.getTable(run);
            }
            catch (OperatorException e) {
                throw new MetadataResolutionException("Result of suggestion process is not a table", (Exception)((Object)e));
            }
            if (ioTable.getTable().width() < 1) {
                LogService.getRoot().log(Level.WARNING, "Suggestion process result contains no column.");
                this.cache = new ArrayList<String>();
                return new MetaDataDto(this.cache);
            }
            Column firstColumn = ioTable.getTable().column(0);
            if (!firstColumn.type().elementType().equals(String.class)) {
                throw new MetadataResolutionException("Result of suggestion process is not a string column", (Exception)((Object)new OperatorException("First column does not contain strings")));
            }
            this.cache = ProcessResultMetadataResolver.readColumn(firstColumn, ioTable);
        }
        return new MetaDataDto(this.cache);
    }

    public void cleanup() {
        this.cache = null;
        this.lastOtherParameters = null;
    }

    private IOContainer prepareProcessAndContainer(Operator operator, Map<String, String> otherParameters, boolean useAvailableInputs) {
        ProcessResultSuggestionProvider.cleanProcess(this.cachedProcess);
        otherParameters.forEach((key, value) -> this.cachedProcess.getContext().addMacro(new Pair((Object)("parameter_" + key), value)));
        this.outerProcessLocation = operator.getProcess().getProcessLocation();
        this.cachedProcess.setProcessLocation(this.outerProcessLocation);
        this.outerContextMacros = Collections.unmodifiableMap(ProcessResultMetadataResolver.readContextMacros(operator));
        IOContainer newContainer = new IOContainer();
        if (useAvailableInputs || operator instanceof ProcessSuggestionParameterHelper && operator.getParameterAsBoolean("use_available_input")) {
            newContainer = this.ioContainer;
        }
        return newContainer;
    }

    private static ProcessResultSuggestionProvider getProcessResultSuggestionProvider(ParameterType parameterType) throws MetadataResolverInitializationException {
        if (!(parameterType instanceof ParameterTypeSuggestion)) {
            throw new MetadataResolverInitializationException("Unsupported parameter type", (Exception)new IllegalArgumentException("Wrong parameter type"));
        }
        ParameterTypeSuggestion suggestion = (ParameterTypeSuggestion)parameterType;
        if (!(suggestion.getSuggestionProvider() instanceof ProcessResultSuggestionProvider)) {
            throw new MetadataResolverInitializationException("Unsupported suggestion provider type", (Exception)new IllegalArgumentException("Wrong suggestion provider"));
        }
        return (ProcessResultSuggestionProvider)suggestion.getSuggestionProvider();
    }

    private static Map<String, String> readContextMacros(Operator operator) {
        HashMap<String, String> contextMacros = new HashMap<String, String>();
        Iterator macroIterator = operator.getProcess().getMacroHandler().getDefinedMacroNames();
        while (macroIterator.hasNext()) {
            String macroName = (String)macroIterator.next();
            contextMacros.put(macroName, operator.getProcess().getMacroHandler().getMacro(macroName));
        }
        return contextMacros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOContainer runWithTimer(IOContainer newContainer) throws OperatorException {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (ProcessResultMetadataResolver.this.cachedProcess.getProcessState() == 2) {
                    ProcessResultMetadataResolver.this.cachedProcess.stop();
                }
            }
        }, 180000L);
        try {
            IOContainer iOContainer = this.cachedProcess.run(newContainer, -1, this.getAdditionalMacros());
            return iOContainer;
        }
        finally {
            timer.cancel();
        }
    }

    private Map<String, String> getAdditionalMacros() {
        HashMap<String, String> newMacros = new HashMap<String, String>(this.outerContextMacros);
        List alreadyContextMacros = this.cachedProcess.getContext().getMacros();
        for (Pair contextMacro : alreadyContextMacros) {
            newMacros.remove(contextMacro.getFirst());
        }
        return newMacros;
    }

    private static IOTable getTable(IOContainer run) throws OperatorException {
        IOTable ioTable = BeltConversionTools.asIOTableOrNull((IOObject)run.get(IOObject.class, 0), null);
        if (ioTable == null) {
            throw new OperatorException("Result is not a data table");
        }
        return ioTable;
    }

    private static List<String> readColumn(Column firstColumn, IOTable ioTable) {
        ObjectReader reader = Readers.objectReader((Column)firstColumn, String.class);
        ArrayList<String> result = new ArrayList<String>(ioTable.getTable().height());
        while (reader.hasRemaining()) {
            result.add((String)reader.read());
        }
        return result;
    }

    private static Map<String, String> getOtherParameters(Operator operator, ParameterType parameterType) {
        String parameterName = parameterType.getKey();
        HashMap<String, String> otherParameters = new HashMap<String, String>();
        for (ParameterType type : operator.getParameterTypes()) {
            if (type.getKey().equals(parameterName)) continue;
            try {
                otherParameters.put(type.getKey(), operator.getParameter(type.getKey()));
            }
            catch (UndefinedParameterError undefinedParameterError) {}
        }
        return otherParameters;
    }
}

