/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.cloud;

import com.rapidminer.extension.processdefined.operator.access.RepositoryFileSuggestionProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositoryObjectSuggestionProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositoryProcessSuggestionProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositorySuggestionProvider;
import com.rapidminer.metadata.MetadataResolutionException;
import com.rapidminer.metadata.MetadataResolver;
import com.rapidminer.metadata.MetadataResolverInitializationException;
import com.rapidminer.metadata.dto.MetaDataDto;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.repository.RepositoryException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class RepositorySuggestionMetadataResolver
implements MetadataResolver {
    private List<String> cache = null;
    private String lastExtensionName = null;

    public void initialize(Operator operator, ParameterType parameterType) throws MetadataResolverInitializationException {
    }

    public MetaDataDto<?> resolveMetaData(Map<String, String> extraParameters) throws MetadataResolutionException {
        if (this.cache == null || this.lastExtensionName == null || !this.lastExtensionName.equals(extraParameters.get("extension_name"))) {
            String extensionName = extraParameters.get("extension_name");
            if (extensionName == null || extensionName.trim().isEmpty()) {
                throw new MetadataResolutionException("Failed to load suggestions: extension name empty", (Exception)new IllegalArgumentException("extension name must not be empty"));
            }
            try {
                this.cache = this.getSuggestionProvider().getSuggestions(extensionName);
            }
            catch (UserError | RepositoryException | IOException e) {
                throw new MetadataResolutionException("Failed to load suggestions: " + e.getMessage(), (Exception)e);
            }
        }
        return new MetaDataDto(this.cache);
    }

    public void cleanup() {
        this.cache = null;
        this.lastExtensionName = null;
    }

    abstract RepositorySuggestionProvider getSuggestionProvider();

    public static class RepositoryObjectSuggestionMetadataResolver
    extends RepositorySuggestionMetadataResolver {
        @Override
        RepositorySuggestionProvider getSuggestionProvider() {
            return RepositoryObjectSuggestionProvider.INSTANCE;
        }
    }

    public static class RepositoryProcessSuggestionMetadataResolver
    extends RepositorySuggestionMetadataResolver {
        @Override
        RepositorySuggestionProvider getSuggestionProvider() {
            return RepositoryProcessSuggestionProvider.INSTANCE;
        }
    }

    public static class RepositoryFileSuggestionMetadataResolver
    extends RepositorySuggestionMetadataResolver {
        @Override
        RepositorySuggestionProvider getSuggestionProvider() {
            return RepositoryFileSuggestionProvider.INSTANCE;
        }
    }
}

