/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.dictionary.operator;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.Builders;
import com.rapidminer.belt.table.MixedRowWriter;
import com.rapidminer.belt.table.Writers;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.processdefined.dictionary.connection.DictionaryHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.belt.BeltTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReadDictionaryOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "process_defined_operators:dictionary");

    public ReadDictionaryOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
        this.connectionSelector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public void doWork() throws OperatorException {
        IOTable output;
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = DictionaryHandler.getConfiguration(connection, this);
        if (configuration.isEmpty()) {
            output = new IOTable(Builders.newTableBuilder((int)0).build(BeltTools.getContext((Operator)this)));
        } else {
            ArrayList<String> columnNames = new ArrayList<String>(configuration.keySet());
            Object[] types = new Column.TypeId[columnNames.size()];
            Arrays.fill(types, Column.TypeId.NOMINAL);
            MixedRowWriter rowWriter = Writers.mixedRowWriter(columnNames, Arrays.asList(types), (int)1, (boolean)false);
            rowWriter.move();
            for (int i = 0; i < columnNames.size(); ++i) {
                rowWriter.set(i, (Object)configuration.get(columnNames.get(i)));
            }
            output = new IOTable(rowWriter.create());
        }
        this.connectionSelector.passDataThrough();
        this.outputPort.deliver((IOObject)output);
    }

    public List<ParameterType> getParameterTypes() {
        return new ArrayList<ParameterType>(ConnectionInformationSelector.createParameterTypes((ConnectionInformationSelector)this.connectionSelector));
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

